<?php

namespace App\Exports;

use App\Models\Clients;
use App\Models\PurchaseOrder;
use App\Models\Users;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class PurchaseExport implements FromCollection, WithHeadings
{
    /**
     * @return \Illuminate\Support\Collection
     */

    private $client;
    private $clientName;
    private $clientArea;
    private $clientLocation;
    private $clientPhone;
    private $Supplier;
    private $OrderDate;
    private $ordernum;

    public function __construct(int $clientId, int $order,int $userid)
    {
        $this->client = $clientId;
        $this->ordernum = $order;

        $demo = Users::where('id', '=', $userid)->pluck('is_demo')->first();

        if($demo == 1)
        {
            $this->clientName  = 'DEMO';
            $this->clientArea    = 'DEMO';
            $this->clientLocation    = 'DEMO';
            $this->clientPhone   = '**********';
        }
        else
        {
            $this->clientName  = Clients::where('ClientID', '=', $clientId)->pluck('ClientName')->first();
            $this->clientArea    = Clients::where('ClientID', '=', $clientId)->pluck('Area')->first();
            $this->clientLocation    = Clients::where('ClientID', '=', $clientId)->pluck('Location')->first();
            $this->clientPhone   = Clients::where('ClientID', '=', $clientId)->pluck('WhatsApp1')->first();
        }
       

        $this->Supplier    = PurchaseOrder::where('OrderNo', '=', $order)->pluck('Supplier')->first();

        $this->OrderDate    = PurchaseOrder::where('OrderNo', '=', $order)->pluck('OrderDate')->first();
        // $this->OrderDate    = DB::select( " select FORMAT( OrderDate , 'dd-MM-yyyy')  from received_orders1 where OrderNo = ".$order." " )
        
    }


    public function collection()
    {
        $stock = DB::select(" select ProductName,Quantity,Pack from received_orders1
        where OrderNo = ".$this->ordernum." and ClientID = ".$this->client." ");

        return collect($stock);
    }

    public function headings(): array
    {
        return [
            [' PURCHASE ORDER '],
            [],
            [$this->clientName. '-' .$this->clientArea . '-' .$this->clientLocation . '-' .$this->clientPhone  ],
            [$this->Supplier. '-' .$this->OrderDate  ],
            [],
            [
                'Product Name',
                'Quantity',
                'Pack',
               
            ]
        ];
       
    }

}
