<?php

namespace App\Exports;

use App\Models\Clients;
use App\Models\Stock;
use App\Models\Users;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;


class StockExport implements FromCollection, WithHeadings 
{
    /**
     * @return \Illuminate\Support\Collection
     */

    private $cli;
    private $userid;
    private $shopname;
    private $area;
    private $location;
    private $phone;

    public function __construct(int $clientId,int $userid)
    {
        $this->cli = $clientId;
        $this->userid = $userid;

        $demo = Users::where('id', '=', $userid)->pluck('is_demo')->first();
        if($demo == 1 )
        {
            $this->shopname = 'DEMO';
            $this->area = 'DEMO';
            $this->location = 'DEMO';
            $this->phone = '**********';
        }
        else
        {
            $this->shopname = Clients::where('ClientID', '=', $clientId)->pluck('ClientName')->first();
            $this->area = Clients::where('ClientID', '=', $clientId)->pluck('Area')->first();
            $this->location = Clients::where('ClientID', '=', $clientId)->pluck('Location')->first();
            $this->phone = Clients::where('ClientID', '=', $clientId)->pluck('WhatsApp1')->first();
        }
       
    }

    public function collection()
    {
        // return Stock::where('ClientID', '=', 354)->get();
        // DB::raw(" SUM(quantity) as totalQuantity ")
        // return Stock::select("Product_Name", "manufacturer", "Batch", "Purchase_quantity", "Sales_quantity", "uPack", "Expiry", "Unit_Rate", "MRP", "Sales_Rate", "GST")
        // ->where('ClientID', '=', $this->cli)
        // ->get();

        // return Stock::select("Product_Name", "manufacturer", "Batch", DB::raw(" Purchase_quantity - Sales_quantity as stock")
        // ,"uPack", "Expiry", "Unit_Rate", "Expiry", DB::raw(" Unit_Rate * ( Purchase_quantity -
        // Sales_quantity ) "), "MRP", DB::raw(" MRP * uPack ") , DB::raw(" Sales_Rate * ( Purchase_quantity -
        // Sales_quantity ) ") , "GST")
        // ->where('ClientID', '=', $this->cli)
        // ->get();


        $stock = DB::select(" SELECT Product_Name,manufacturer,Batch,Purchase_quantity - Sales_quantity as stock,uPack, CONCAT( concat(LPAD(month(expiry),2,0),'-') , right( year(expiry) ,2) ) as expiry ,round(Unit_Rate,2), round( Unit_Rate * ( Purchase_quantity -
        Sales_quantity), 2) as pratetot,round(MRP,2), round(MRP * uPack,2) as packmrp, round(Sales_Rate * ( Purchase_quantity -
        Sales_quantity ),2) as sratetot,GST from stock 
WHERE ClientID = '" . $this->cli . "' AND (Purchase_quantity - Sales_quantity) > 0
order by Product_Name,Batch ");

        return collect($stock);
    }

    public function headings(): array
    {
        return [
            ['STOCK REPORT'],
            [],
            [$this->shopname. '-' .$this->area . '-' .$this->location . '-' .$this->phone  ],
            [],
            [
                'Product Name',
                'Manufacturer',
                'Batch',
                'Stock',
                'Pack',
                'Expiry ( MM-YY )',
                'P.R',
                'P.R.T',
                'MRP',
                'MRP/P',
                'S.R.T',
                'GST %',
            ]
        ];
       
    }

  
}
