<?php

namespace App\Http\Controllers;

use App\Models\OnlineLog;
use Carbon\Carbon;
use DateTime;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class GeneralController extends Controller
{

    public static function checkIsAssignedToAnyAnotherShop($clientID)
    {
      $res = DB::select(" select ap.ClientID as assignedclient,ap.Managed_ClientID,c.ClientName,c.Area,c.Location from tbl_assigned_shops ap 
      left join clients c on ap.ClientID = c.ClientID
      where ap.Managed_ClientID = ".$clientID." and ap.ClientID != ".$clientID." ");

      $returnString = '';

      if( count($res) <= 0 )
      {
          $returnString = '';
      }
      else
      {
          foreach( $res as $re )
          {
            // $returnString = " Assigned To : " .$re->assignedclient ." - ". $re->ClientName ." - ". $re->Area." - ". $re->Location ; 
            $returnString = " Assigned To : " .$re->assignedclient ; 
          }
      }

      return $returnString;
      
    }

    public static function daysInDate($from, $to)
    {
        $datetime1 = new DateTime($from);
        $datetime2 = new DateTime($to);
        $interval = $datetime1->diff($datetime2);
        $days = $interval->format('%a');

        // $now = $to; // or your date as well
        // $your_date = $from;
        // $datediff = $now - $your_date;

        // echo round($datediff / (60 * 60 * 24));

        return $days + 1;
        // return round($datediff / (60 * 60 * 24));
    }

    public static function daysleft($args)
    {
        $today = Carbon::now()->format('Y-m-d');

        $remaining_days = Carbon::parse($today)->diffInDays(Carbon::parse($args));

        if ($today < Carbon::parse($args)) {
            return $remaining_days . ' days left';
        } else {
            return 'Date is Expired';
        }

        // return $remaining_days;
    }

    public static function daysleftDateOnly($args)
    {
        // $today = Carbon::now()->format('Y-m-d');

        // $remaining_days = Carbon::parse($today)->diffInDays(Carbon::parse($args));

        $today = Carbon::now()->format('Y-m-d');
        $remaining_days = Carbon::parse($today)->diffInDays(Carbon::parse($args));

        $res = $args >= Carbon::now();

        if( $res >= 1 )
        {
            return $remaining_days;
        }
        else
        {
            return '';
        }



        // if ($today < Carbon::parse($args)) {
        //     return $remaining_days . ' days left' ;
        // } else {
        //     return 'Date is Expired';
        // }

        // return $remaining_days;
    }
    
        public static function managedShopListUserID($uid)
    {
        $values =  DB::select(" select * from tbl_assigned_shops where User_ID = ".$uid." ");

        $managedShops = '';

        foreach ($values as $item) {
            $managedShops .= $item->Managed_ClientID . ',';
        }

        return substr($managedShops, 0, -1);
    }

    public static function managedShopList($email)
    {
        $values =  DB::select("  select distinct clients.clientid from tbl_assigned_shops 
        JOIN clients ON tbl_assigned_shops.Managed_ClientID=clients.ClientID 
        JOIN user ON tbl_assigned_shops.ClientID=user.userid 
        where user.UserName = '" . $email . "' ");

        $managedShops = '';

        foreach ($values as $item) {
            $managedShops .= $item->clientid . ',';
        }

        return substr($managedShops, 0, -1);;
    }

    public static function managedShopListByclientID($id)
    {
        $values =  DB::select("  select asp.Managed_ClientID,c2.ClientName,c2.Area,c2.Location from tbl_assigned_shops asp
        left JOIN clients c1 on asp.ClientID = c1.ClientID
        left join clients c2 on asp.Managed_ClientID = c2.ClientID
        where c1.ClientID = " . $id . " GROUP BY asp.Managed_ClientID ");

        // $managedShops = '';

        // foreach ($values as $item) {
        //     if( $item->Managed_ClientID != $id )
        //     {
        //         $managedShops .= $item->Managed_ClientID . ',';
        //     }

        // }

        // return substr($managedShops, 0, -1);
        return $values;
    }

    public static function managedShopListCountByclientID($id)
    {
        $assignedCount = 0;

        $values =  DB::select("  select COUNT( DISTINCT asp.Managed_ClientID) as assignedCount from tbl_assigned_shops asp
        left JOIN clients c1 on asp.ClientID = c1.ClientID
        left join clients c2 on asp.Managed_ClientID = c2.ClientID
        where c1.ClientID = " . $id . " ");

        foreach ($values as $item) {

            $assignedCount = $item->assignedCount;
        }

        return $assignedCount;
    }

    public static function adminCountByShopID($id)
    {
        $values =  DB::select("  SELECT count(UserName) as adminCount FROM user u where u.userid = " . $id . " and u.Admin = 1 and u.UserName != 'info@digitronicsindia.com' ");

        $managedShops = '';

        foreach ($values as $item) {

            $managedShops = $item->adminCount;
        }

        return $managedShops;
    }

    public static function shopCountByShopID($id)
    {
        $values =  DB::select("  SELECT count(UserName) as adminCount FROM user u where u.userid = " . $id . " and u.IsShop = 1  ");

        $managedShops = '';

        foreach ($values as $item) {

            $managedShops = $item->adminCount;
        }

        return $managedShops;
    }

    public static function userCountByShopID($id)
    {
        $values =  DB::select("  SELECT count(UserName) as adminCount FROM user u where u.userid = " . $id . " and u.IsStaff = 1  ");

        $managedShops = '';

        foreach ($values as $item) {

            $managedShops = $item->adminCount;
        }

        return $managedShops;
    }

    public static function getPermissionMaxDateUsingClientID($clientID)
    {
        $todate =  DB::select(" select MAX(up.per_to) as endDate from clients c
        left join user u on c.ClientID = u.userid
        left join tbl_userpermissions up on u.id = up.User_ID
        left join tbl_permissionActions pa on up.Package_ID = pa.act_package
        where pa.act_slug = 'trial' and c.ClientID = " . $clientID . " and u.Admin != 1  ");

        // return MainAcontroller::convertDate($todate->endDate);
        $managedShops = '';

        foreach ($todate as $to) {
            $managedShops = $to->endDate;
        }

        return $managedShops;
    }

    public static function getLastUpdatedTime($client)
    {
        $values =  OnlineLog::Where('UserName', '=', $client)->orderBy('Dt', 'desc')->pluck('Dt')->first();

        return $values;
    }
}
