<?php

namespace App\Http\Controllers;

use App\Models\AssignedShops;
use App\Models\Clients;
use App\Models\FreeTrail;
use App\Models\Packages;
use App\Models\PermissionActions;
use App\Models\ReportPermission;
use App\Models\TblAssignedShops;
use App\Models\TblSettings;
use App\Models\User;
use App\Models\UserPermissions;
use App\Models\Users;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use NumberToWords\NumberToWords;
use Spatie\FlareClient\View;

class MainAcontroller extends Controller
{

    public function enableForceLogout($userid)
    {
        $setID = TblSettings::where('user_id','=',$userid)->pluck('id')->first();

        $tblSet = TblSettings::find($setID);

        $tblSet->enable_forcelogout = 1;

        $superSave = $tblSet->save();

        if($superSave)
        {
            return back()->with('success', 'Force logout enabled successfully');
        }
        else
        {
            return back()->with('fail', 'Something went wrong');
        }
    }

    public function updateUserDetails(Request $request)
    {
        $updateID = $request->updateID;
        $updateName = $request->updateName;
        $updateEmail = $request->updateEmail;
        $updateMobile = $request->updateMobile;

        $existE = Users::where('UserName', '=', $updateEmail)->where('id', '!=', $updateID)->first();
        $existM = Users::where('Mobile', '=', $updateMobile)->where('id', '!=', $updateID)->first();

        if ($existE) {
            return back()->with('fail', 'E-Mail already exist');
        } elseif ($existM) {
            return back()->with('fail', 'Mobile number already exist');
        } elseif (!$existE && !$existM) {
            $user = Users::find($updateID);

            $user->Name = $updateName;
            $user->UserName = $updateEmail;
            $user->Mobile = $updateMobile;

            $save = $user->save();

            if ($save) {

                $user1 = Users::find($updateID);

                $useridzero = str_repeat('0', (4) - strlen(rtrim($user1->userid))) . $user1->userid;
                $password = substr($updateMobile, -4) . $useridzero;

                $user1->PassWord = md5($password);
                $doublesave = $user1->save();

                if($doublesave)
                {
                    $setID = TblSettings::where('user_id','=',$updateID)->pluck('id')->first();

                    $tblSet = TblSettings::find($setID);

                    $tblSet->enable_forcelogout = 1;

                    $superSave = $tblSet->save();

                    if($superSave)
                    {
                        return back()->with('success', 'Profile details updated successfully ');
                    }
                    else
                    {
                        return back()->with('fail', 'Something went wrong');
                    }
                    
                    
                }
                else
                {
                    return back()->with('fail', 'Something went wrong');
                }
            }
        }
    }

    public function viewUserReport(Request $request)
    {
        $userPack = $request->userPack;
        $userMode = $request->userMode;
        $userDemo = $request->userDemo;
        $userBillType = $request->userBillType;
        $userType = $request->userType;

        // 0 0 0 0 1 - 1
        if ($userPack == '' &&  $userMode == '' && $userDemo == '' && $userBillType == '' && $userType != '') {

            $res =  DB::select(" select u.id,u.Name,u.IsLive,u.is_MultiUser,u.is_SingleUser,u.is_demo,u.billing_type,pa.Pack_Name,up.per_from,up.per_to,
            c.ClientName,c.Area,c.Location from user u
            left join tbl_packages pa on u.Package_ID = pa.id
            left join tbl_userpermissions up on u.id = up.User_ID
            left join tbl_permissionActions pact on u.Package_ID = pact.act_package
            left join clients c on u.userid = c.ClientID
            where pact.act_slug = 'trial' and u.Admin != 1 and u.is_MultiUser = '" . $userType . "'
            group by u.id; ");
        }
        //  0 0 0 1 0 - 2
        else if ($userPack == '' &&  $userMode == '' && $userDemo == '' && $userBillType != '' && $userType == '') {

            $res =  DB::select(" select u.id,u.Name,u.IsLive,u.is_MultiUser,u.is_SingleUser,u.is_demo,u.billing_type,pa.Pack_Name,up.per_from,up.per_to,
                c.ClientName,c.Area,c.Location from user u
                left join tbl_packages pa on u.Package_ID = pa.id
                left join tbl_userpermissions up on u.id = up.User_ID
                left join tbl_permissionActions pact on u.Package_ID = pact.act_package
                left join clients c on u.userid = c.ClientID
                where pact.act_slug = 'trial' and u.Admin != 1 and u.billing_type = '" . $userBillType . "'
                group by u.id; ");
        }
        //  0 0 0 1 1 - 3
        else if ($userPack == '' &&  $userMode == '' && $userDemo == '' && $userBillType != '' && $userType != '') {
            $res =  DB::select(" select u.id,u.Name,u.IsLive,u.is_MultiUser,u.is_SingleUser,u.is_demo,u.billing_type,pa.Pack_Name,up.per_from,up.per_to,
            c.ClientName,c.Area,c.Location from user u
            left join tbl_packages pa on u.Package_ID = pa.id
            left join tbl_userpermissions up on u.id = up.User_ID
            left join tbl_permissionActions pact on u.Package_ID = pact.act_package
            left join clients c on u.userid = c.ClientID
            where pact.act_slug = 'trial' and u.Admin != 1 and u.billing_type = '" . $userBillType . "' and u.is_MultiUser = '" . $userType . "'
            group by u.id; ");
        }

        //  0 0 1 0 0 demo only - 4
        else if ($userPack == '' &&  $userMode == '' && $userDemo != '' && $userBillType == '' && $userType == '') {
            $res =  DB::select(" select u.id,u.Name,u.IsLive,u.is_MultiUser,u.is_SingleUser,u.is_demo,u.billing_type,pa.Pack_Name,up.per_from,up.per_to,
            c.ClientName,c.Area,c.Location from user u
            left join tbl_packages pa on u.Package_ID = pa.id
            left join tbl_userpermissions up on u.id = up.User_ID
            left join tbl_permissionActions pact on u.Package_ID = pact.act_package
            left join clients c on u.userid = c.ClientID
            where pact.act_slug = 'trial' and u.Admin != 1 and u.is_demo = " . $userDemo . "
            group by u.id; ");
        }

        //  0 0 1 0 1 demo and single/multi - 5
        else if ($userPack == '' &&  $userMode == '' && $userDemo != '' && $userBillType == '' && $userType != '') {
            $res =  DB::select(" select u.id,u.Name,u.IsLive,u.is_MultiUser,u.is_SingleUser,u.is_demo,u.billing_type,pa.Pack_Name,up.per_from,up.per_to,
            c.ClientName,c.Area,c.Location from user u
            left join tbl_packages pa on u.Package_ID = pa.id
            left join tbl_userpermissions up on u.id = up.User_ID
            left join tbl_permissionActions pact on u.Package_ID = pact.act_package
            left join clients c on u.userid = c.ClientID
            where pact.act_slug = 'trial' and u.Admin != 1 and u.is_demo = " . $userDemo . " and u.is_MultiUser = '" . $userType . "'
            group by u.id; ");
        }

        //  0 0 1 1 0  - 6 
        else if ($userPack == '' &&  $userMode == '' && $userDemo != '' && $userBillType != '' && $userType == '') {
            $res =  DB::select(" select u.id,u.Name,u.IsLive,u.is_MultiUser,u.is_SingleUser,u.is_demo,u.billing_type,pa.Pack_Name,up.per_from,up.per_to,
            c.ClientName,c.Area,c.Location from user u
            left join tbl_packages pa on u.Package_ID = pa.id
            left join tbl_userpermissions up on u.id = up.User_ID
            left join tbl_permissionActions pact on u.Package_ID = pact.act_package
            left join clients c on u.userid = c.ClientID
            where pact.act_slug = 'trial' and u.Admin != 1 and u.is_demo = " . $userDemo . " and u.billing_type = '" . $userBillType . "'
            group by u.id; ");
        }

        //  0 0 1 1 1  - 7
        else if ($userPack == '' &&  $userMode == '' && $userDemo != '' && $userBillType != '' && $userType != '') {
            $res =  DB::select(" select u.id,u.Name,u.IsLive,u.is_MultiUser,u.is_SingleUser,u.is_demo,u.billing_type,pa.Pack_Name,up.per_from,up.per_to,
            c.ClientName,c.Area,c.Location from user u
            left join tbl_packages pa on u.Package_ID = pa.id
            left join tbl_userpermissions up on u.id = up.User_ID
            left join tbl_permissionActions pact on u.Package_ID = pact.act_package
            left join clients c on u.userid = c.ClientID
            where pact.act_slug = 'trial' and u.Admin != 1 and u.is_demo = " . $userDemo . " and u.billing_type = '" . $userBillType . "' and u.is_MultiUser = '" . $userType . "'
            group by u.id; ");
        }

        //  0 1 0 0 0 - 8 
        else if ($userPack == '' &&  $userMode != '' && $userDemo == '' && $userBillType == '' && $userType == '') {
            $res =  DB::select(" select u.id,u.Name,u.IsLive,u.is_MultiUser,u.is_SingleUser,u.is_demo,u.billing_type,pa.Pack_Name,up.per_from,up.per_to,
            c.ClientName,c.Area,c.Location from user u
            left join tbl_packages pa on u.Package_ID = pa.id
            left join tbl_userpermissions up on u.id = up.User_ID
            left join tbl_permissionActions pact on u.Package_ID = pact.act_package
            left join clients c on u.userid = c.ClientID
            where pact.act_slug = 'trial' and u.Admin != 1 and u.IsLive = " . $userMode . "
            group by u.id; ");
        }

        //  0 1 0 0 1  - 9
        else if ($userPack == '' &&  $userMode != '' && $userDemo == '' && $userBillType == '' && $userType != '') {
            $res =  DB::select(" select u.id,u.Name,u.IsLive,u.is_MultiUser,u.is_SingleUser,u.is_demo,u.billing_type,pa.Pack_Name,up.per_from,up.per_to,
            c.ClientName,c.Area,c.Location from user u
            left join tbl_packages pa on u.Package_ID = pa.id
            left join tbl_userpermissions up on u.id = up.User_ID
            left join tbl_permissionActions pact on u.Package_ID = pact.act_package
            left join clients c on u.userid = c.ClientID
            where pact.act_slug = 'trial' and u.Admin != 1 and u.IsLive = " . $userMode . " and u.is_MultiUser = '" . $userType . "'
            group by u.id; ");
        }

        //  0 1 0 1 0  - 10
        else if ($userPack == '' &&  $userMode != '' && $userDemo == '' && $userBillType != '' && $userType == '') {
            $res =  DB::select(" select u.id,u.Name,u.IsLive,u.is_MultiUser,u.is_SingleUser,u.is_demo,u.billing_type,pa.Pack_Name,up.per_from,up.per_to,
            c.ClientName,c.Area,c.Location from user u
            left join tbl_packages pa on u.Package_ID = pa.id
            left join tbl_userpermissions up on u.id = up.User_ID
            left join tbl_permissionActions pact on u.Package_ID = pact.act_package
            left join clients c on u.userid = c.ClientID
            where pact.act_slug = 'trial' and u.Admin != 1 and u.IsLive = " . $userMode . " and u.billing_type = '" . $userType . "'
            group by u.id; ");
        }

        //  0 1 0 1 1 - 11
        else if ($userPack == '' &&  $userMode != '' && $userDemo == '' && $userBillType != '' && $userType != '') {
            $res =  DB::select(" select u.id,u.Name,u.IsLive,u.is_MultiUser,u.is_SingleUser,u.is_demo,u.billing_type,pa.Pack_Name,up.per_from,up.per_to,
            c.ClientName,c.Area,c.Location from user u
            left join tbl_packages pa on u.Package_ID = pa.id
            left join tbl_userpermissions up on u.id = up.User_ID
            left join tbl_permissionActions pact on u.Package_ID = pact.act_package
            left join clients c on u.userid = c.ClientID
            where pact.act_slug = 'trial' and u.Admin != 1 and u.IsLive = " . $userMode . " and u.billing_type = '" . $userBillType . "' and u.is_MultiUser = '" . $userType . "'
            group by u.id; ");
        }

        //  0 1 1 0 0 - 12
        else if ($userPack == '' &&  $userMode != '' && $userDemo != '' && $userBillType == '' && $userType == '') {
            $res =  DB::select(" select u.id,u.Name,u.IsLive,u.is_MultiUser,u.is_SingleUser,u.is_demo,u.billing_type,pa.Pack_Name,up.per_from,up.per_to,
            c.ClientName,c.Area,c.Location from user u
            left join tbl_packages pa on u.Package_ID = pa.id
            left join tbl_userpermissions up on u.id = up.User_ID
            left join tbl_permissionActions pact on u.Package_ID = pact.act_package
            left join clients c on u.userid = c.ClientID
            where pact.act_slug = 'trial' and u.Admin != 1 and u.IsLive = " . $userMode . " and u.is_demo = " . $userDemo . "
            group by u.id; ");
        }

        //  0 1 1 0 1 - 13
        else if ($userPack == '' &&  $userMode != '' && $userDemo != '' && $userBillType == '' && $userType != '') {
            $res =  DB::select(" select u.id,u.Name,u.IsLive,u.is_MultiUser,u.is_SingleUser,u.is_demo,u.billing_type,pa.Pack_Name,up.per_from,up.per_to,
            c.ClientName,c.Area,c.Location from user u
            left join tbl_packages pa on u.Package_ID = pa.id
            left join tbl_userpermissions up on u.id = up.User_ID
            left join tbl_permissionActions pact on u.Package_ID = pact.act_package
            left join clients c on u.userid = c.ClientID
            where pact.act_slug = 'trial' and u.Admin != 1 and u.IsLive = " . $userMode . " and u.is_demo = " . $userDemo . " and u.is_MultiUser = '" . $userType . "'
            group by u.id; ");
        }

        //  0 1 1 1 0 - 14
        else if ($userPack == '' &&  $userMode != '' && $userDemo != '' && $userBillType != '' && $userType == '') {
            $res =  DB::select(" select u.id,u.Name,u.IsLive,u.is_MultiUser,u.is_SingleUser,u.is_demo,u.billing_type,pa.Pack_Name,up.per_from,up.per_to,
            c.ClientName,c.Area,c.Location from user u
            left join tbl_packages pa on u.Package_ID = pa.id
            left join tbl_userpermissions up on u.id = up.User_ID
            left join tbl_permissionActions pact on u.Package_ID = pact.act_package
            left join clients c on u.userid = c.ClientID
            where pact.act_slug = 'trial' and u.Admin != 1 and u.IsLive = " . $userMode . " and u.is_demo = " . $userDemo . " and u.billing_type = '" . $userBillType . "'
            group by u.id; ");
        }

        //  0 1 1 1 1 -15
        else if ($userPack == '' &&  $userMode != '' && $userDemo != '' && $userBillType != '' && $userType != '') {
            $res =  DB::select(" select u.id,u.Name,u.IsLive,u.is_MultiUser,u.is_SingleUser,u.is_demo,u.billing_type,pa.Pack_Name,up.per_from,up.per_to,
            c.ClientName,c.Area,c.Location from user u
            left join tbl_packages pa on u.Package_ID = pa.id
            left join tbl_userpermissions up on u.id = up.User_ID
            left join tbl_permissionActions pact on u.Package_ID = pact.act_package
            left join clients c on u.userid = c.ClientID
            where pact.act_slug = 'trial' and u.Admin != 1 and u.IsLive = " . $userMode . " and u.is_demo = " . $userDemo . " and u.billing_type = '" . $userBillType . "' and u.is_MultiUser = '" . $userType . "' 
            group by u.id; ");
        }

        //  1 0 0 0 0 - 16
        else if ($userPack != '' &&  $userMode == '' && $userDemo == '' && $userBillType == '' && $userType == '') {
            $res =  DB::select(" select u.id,u.Name,u.IsLive,u.is_MultiUser,u.is_SingleUser,u.is_demo,u.billing_type,pa.Pack_Name,up.per_from,up.per_to,
            c.ClientName,c.Area,c.Location from user u
            left join tbl_packages pa on u.Package_ID = pa.id
            left join tbl_userpermissions up on u.id = up.User_ID
            left join tbl_permissionActions pact on u.Package_ID = pact.act_package
            left join clients c on u.userid = c.ClientID
            where pact.act_slug = 'trial' and u.Admin != 1 and u.Package_ID = " . $userPack . "
            group by u.id; ");
        }

        //  1 0 0 0 1 - 17
        else if ($userPack != '' &&  $userMode == '' && $userDemo == '' && $userBillType == '' && $userType != '') {
            $res =  DB::select(" select u.id,u.Name,u.IsLive,u.is_MultiUser,u.is_SingleUser,u.is_demo,u.billing_type,pa.Pack_Name,up.per_from,up.per_to,
            c.ClientName,c.Area,c.Location from user u
            left join tbl_packages pa on u.Package_ID = pa.id
            left join tbl_userpermissions up on u.id = up.User_ID
            left join tbl_permissionActions pact on u.Package_ID = pact.act_package
            left join clients c on u.userid = c.ClientID
            where pact.act_slug = 'trial' and u.Admin != 1 and u.Package_ID = " . $userPack . " and u.is_MultiUser = '" . $userType . "' 
            group by u.id; ");
        }

        //  1 0 0 1 0 - 18
        else if ($userPack != '' &&  $userMode == '' && $userDemo == '' && $userBillType != '' && $userType == '') {
            $res =  DB::select(" select u.id,u.Name,u.IsLive,u.is_MultiUser,u.is_SingleUser,u.is_demo,u.billing_type,pa.Pack_Name,up.per_from,up.per_to,
            c.ClientName,c.Area,c.Location from user u
            left join tbl_packages pa on u.Package_ID = pa.id
            left join tbl_userpermissions up on u.id = up.User_ID
            left join tbl_permissionActions pact on u.Package_ID = pact.act_package
            left join clients c on u.userid = c.ClientID
            where pact.act_slug = 'trial' and u.Admin != 1 and u.Package_ID = " . $userPack . " and u.billing_type = '" . $userBillType . "' 
            group by u.id; ");
        }

        //  1 0 0 1 1 - 19
        else if ($userPack != '' &&  $userMode == '' && $userDemo == '' && $userBillType != '' && $userType != '') {
            $res =  DB::select(" select u.id,u.Name,u.IsLive,u.is_MultiUser,u.is_SingleUser,u.is_demo,u.billing_type,pa.Pack_Name,up.per_from,up.per_to,
            c.ClientName,c.Area,c.Location from user u
            left join tbl_packages pa on u.Package_ID = pa.id
            left join tbl_userpermissions up on u.id = up.User_ID
            left join tbl_permissionActions pact on u.Package_ID = pact.act_package
            left join clients c on u.userid = c.ClientID
            where pact.act_slug = 'trial' and u.Admin != 1 and u.Package_ID = " . $userPack . " and u.billing_type = '" . $userBillType . "' and u.is_MultiUser = '" . $userType . "'
            group by u.id; ");
        }

        //  1 0 1 0 0 - 20
        else if ($userPack != '' &&  $userMode == '' && $userDemo != '' && $userBillType == '' && $userType == '') {
            $res =  DB::select(" select u.id,u.Name,u.IsLive,u.is_MultiUser,u.is_SingleUser,u.is_demo,u.billing_type,pa.Pack_Name,up.per_from,up.per_to,
            c.ClientName,c.Area,c.Location from user u
            left join tbl_packages pa on u.Package_ID = pa.id
            left join tbl_userpermissions up on u.id = up.User_ID
            left join tbl_permissionActions pact on u.Package_ID = pact.act_package
            left join clients c on u.userid = c.ClientID
            where pact.act_slug = 'trial' and u.Admin != 1 and u.Package_ID = " . $userPack . " and u.is_demo = " . $userDemo . " 
            group by u.id; ");
        }

        //  1 0 1 0 1 -21
        else if ($userPack != '' &&  $userMode == '' && $userDemo != '' && $userBillType == '' && $userType != '') {
            $res =  DB::select(" select u.id,u.Name,u.IsLive,u.is_MultiUser,u.is_SingleUser,u.is_demo,u.billing_type,pa.Pack_Name,up.per_from,up.per_to,
            c.ClientName,c.Area,c.Location from user u
            left join tbl_packages pa on u.Package_ID = pa.id
            left join tbl_userpermissions up on u.id = up.User_ID
            left join tbl_permissionActions pact on u.Package_ID = pact.act_package
            left join clients c on u.userid = c.ClientID
            where pact.act_slug = 'trial' and u.Admin != 1 and u.Package_ID = " . $userPack . " and u.is_demo = " . $userDemo . " and u.is_MultiUser = '" . $userType . "'
            group by u.id; ");
        }

        //  1 0 1 1 0 -22
        else if ($userPack != '' &&  $userMode == '' && $userDemo != '' && $userBillType != '' && $userType == '') {
            $res =  DB::select(" select u.id,u.Name,u.IsLive,u.is_MultiUser,u.is_SingleUser,u.is_demo,u.billing_type,pa.Pack_Name,up.per_from,up.per_to,
            c.ClientName,c.Area,c.Location from user u
            left join tbl_packages pa on u.Package_ID = pa.id
            left join tbl_userpermissions up on u.id = up.User_ID
            left join tbl_permissionActions pact on u.Package_ID = pact.act_package
            left join clients c on u.userid = c.ClientID
            where pact.act_slug = 'trial' and u.Admin != 1 and u.Package_ID = " . $userPack . " and u.is_demo = " . $userDemo . " and u.billing_type = '" . $userBillType . "'
            group by u.id; ");
        }

        //  1 0 1 1 1 -23
        else if ($userPack != '' &&  $userMode == '' && $userDemo != '' && $userBillType != '' && $userType != '') {
            $res =  DB::select(" select u.id,u.Name,u.IsLive,u.is_MultiUser,u.is_SingleUser,u.is_demo,u.billing_type,pa.Pack_Name,up.per_from,up.per_to,
            c.ClientName,c.Area,c.Location from user u
            left join tbl_packages pa on u.Package_ID = pa.id
            left join tbl_userpermissions up on u.id = up.User_ID
            left join tbl_permissionActions pact on u.Package_ID = pact.act_package
            left join clients c on u.userid = c.ClientID
            where pact.act_slug = 'trial' and u.Admin != 1 and u.Package_ID = " . $userPack . " and u.is_demo = " . $userDemo . " and u.billing_type = '" . $userBillType . "' and u.is_MultiUser = '" . $userType . "'
            group by u.id; ");
        }

        //  1 1 0 0 0  -24
        else if ($userPack != '' &&  $userMode != '' && $userDemo == '' && $userBillType == '' && $userType == '') {
            $res =  DB::select(" select u.id,u.Name,u.IsLive,u.is_MultiUser,u.is_SingleUser,u.is_demo,u.billing_type,pa.Pack_Name,up.per_from,up.per_to,
            c.ClientName,c.Area,c.Location from user u
            left join tbl_packages pa on u.Package_ID = pa.id
            left join tbl_userpermissions up on u.id = up.User_ID
            left join tbl_permissionActions pact on u.Package_ID = pact.act_package
            left join clients c on u.userid = c.ClientID
            where pact.act_slug = 'trial' and u.Admin != 1 and u.Package_ID = " . $userPack . " and u.IsLive = " . $userMode . " 
            group by u.id; ");
        }

        //  1 1 0 0 1  -25
        else if ($userPack != '' &&  $userMode != '' && $userDemo == '' && $userBillType == '' && $userType != '') {
            $res =  DB::select(" select u.id,u.Name,u.IsLive,u.is_MultiUser,u.is_SingleUser,u.is_demo,u.billing_type,pa.Pack_Name,up.per_from,up.per_to,
            c.ClientName,c.Area,c.Location from user u
            left join tbl_packages pa on u.Package_ID = pa.id
            left join tbl_userpermissions up on u.id = up.User_ID
            left join tbl_permissionActions pact on u.Package_ID = pact.act_package
            left join clients c on u.userid = c.ClientID
            where pact.act_slug = 'trial' and u.Admin != 1 and u.Package_ID = " . $userPack . " and u.IsLive = " . $userMode . " and u.is_MultiUser = '" . $userType . "'
            group by u.id; ");
        }

        //  1 1 0 1 0  -26
        else if ($userPack != '' &&  $userMode != '' && $userDemo == '' && $userBillType != '' && $userType == '') {
            $res =  DB::select(" select u.id,u.Name,u.IsLive,u.is_MultiUser,u.is_SingleUser,u.is_demo,u.billing_type,pa.Pack_Name,up.per_from,up.per_to,
            c.ClientName,c.Area,c.Location from user u
            left join tbl_packages pa on u.Package_ID = pa.id
            left join tbl_userpermissions up on u.id = up.User_ID
            left join tbl_permissionActions pact on u.Package_ID = pact.act_package
            left join clients c on u.userid = c.ClientID
            where pact.act_slug = 'trial' and u.Admin != 1 and u.Package_ID = " . $userPack . " and u.IsLive = " . $userMode . " and u.billing_type = '" . $userBillType . "'
            group by u.id; ");
        }

        //  1 1 0 1 1  -27
        else if ($userPack != '' &&  $userMode != '' && $userDemo == '' && $userBillType != '' && $userType != '') {
            $res =  DB::select(" select u.id,u.Name,u.IsLive,u.is_MultiUser,u.is_SingleUser,u.is_demo,u.billing_type,pa.Pack_Name,up.per_from,up.per_to,
            c.ClientName,c.Area,c.Location from user u
            left join tbl_packages pa on u.Package_ID = pa.id
            left join tbl_userpermissions up on u.id = up.User_ID
            left join tbl_permissionActions pact on u.Package_ID = pact.act_package
            left join clients c on u.userid = c.ClientID
            where pact.act_slug = 'trial' and u.Admin != 1 and u.Package_ID = " . $userPack . " and u.IsLive = " . $userMode . " and u.billing_type = '" . $userBillType . "' and u.is_MultiUser = '" . $userType . "'
            group by u.id; ");
        }

        //  1 1 1 0 0 -28
        else if ($userPack != '' &&  $userMode != '' && $userDemo != '' && $userBillType == '' && $userType == '') {
            $res =  DB::select(" select u.id,u.Name,u.IsLive,u.is_MultiUser,u.is_SingleUser,u.is_demo,u.billing_type,pa.Pack_Name,up.per_from,up.per_to,
            c.ClientName,c.Area,c.Location from user u
            left join tbl_packages pa on u.Package_ID = pa.id
            left join tbl_userpermissions up on u.id = up.User_ID
            left join tbl_permissionActions pact on u.Package_ID = pact.act_package
            left join clients c on u.userid = c.ClientID
            where pact.act_slug = 'trial' and u.Admin != 1 and u.Package_ID = " . $userPack . " and u.IsLive = " . $userMode . " and u.is_demo = " . $userDemo . " 
            group by u.id; ");
        }

        //  1 1 1 0 1 - 29
        else if ($userPack != '' &&  $userMode != '' && $userDemo != '' && $userBillType == '' && $userType != '') {
            $res =  DB::select(" select u.id,u.Name,u.IsLive,u.is_MultiUser,u.is_SingleUser,u.is_demo,u.billing_type,pa.Pack_Name,up.per_from,up.per_to,
            c.ClientName,c.Area,c.Location from user u
            left join tbl_packages pa on u.Package_ID = pa.id
            left join tbl_userpermissions up on u.id = up.User_ID
            left join tbl_permissionActions pact on u.Package_ID = pact.act_package
            left join clients c on u.userid = c.ClientID
            where pact.act_slug = 'trial' and u.Admin != 1 and u.Package_ID = " . $userPack . " and u.IsLive = " . $userMode . " and u.is_demo = " . $userDemo . " and u.is_MultiUser = '" . $userType . "'
            group by u.id; ");
        }

        //  1 1 1 1 0 -30
        else if ($userPack != '' &&  $userMode != '' && $userDemo != '' && $userBillType != '' && $userType == '') {
            $res =  DB::select(" select u.id,u.Name,u.IsLive,u.is_MultiUser,u.is_SingleUser,u.is_demo,u.billing_type,pa.Pack_Name,up.per_from,up.per_to,
            c.ClientName,c.Area,c.Location from user u
            left join tbl_packages pa on u.Package_ID = pa.id
            left join tbl_userpermissions up on u.id = up.User_ID
            left join tbl_permissionActions pact on u.Package_ID = pact.act_package
            left join clients c on u.userid = c.ClientID
            where pact.act_slug = 'trial' and u.Admin != 1 and u.Package_ID = " . $userPack . " and u.IsLive = " . $userMode . " and u.is_demo = " . $userDemo . " and u.billing_type = '" . $userBillType . "'
            group by u.id; ");
        }

        //  1 1 1 1 1 - 31
        else if ($userPack != '' &&  $userMode != '' && $userDemo != '' && $userBillType != '' && $userType != '') {
            $res =  DB::select(" select u.id,u.Name,u.IsLive,u.is_MultiUser,u.is_SingleUser,u.is_demo,u.billing_type,pa.Pack_Name,up.per_from,up.per_to,
            c.ClientName,c.Area,c.Location from user u
            left join tbl_packages pa on u.Package_ID = pa.id
            left join tbl_userpermissions up on u.id = up.User_ID
            left join tbl_permissionActions pact on u.Package_ID = pact.act_package
            left join clients c on u.userid = c.ClientID
            where pact.act_slug = 'trial' and u.Admin != 1 and u.Package_ID = " . $userPack . " and u.IsLive = " . $userMode . " and u.is_demo = " . $userDemo . " and u.billing_type = '" . $userBillType . "' and u.is_MultiUser = '" . $userType . "'
            group by u.id; ");
        }

        $data = [
            'report' => $res
        ];

        return view('Admin.userReport', $data);
    }

    public function getExistingPrivilageDateByUser(Request $request)
    {
        $allUsers = UserPermissions::select("tbl_userpermissions.per_from", "tbl_userpermissions.per_to")
            ->where('tbl_userpermissions.User_ID', '=', $request->user)
            ->join('tbl_permissionActions', 'tbl_userpermissions.userper_slug', '=', 'tbl_permissionActions.act_slug')
            ->where('tbl_permissionActions.act_slug', '=', 'trial')
            ->get();

        return $allUsers;
    }

    public function getPreviousRemarks(Request $request)
    {
        $allUsers = DB::select(" SELECT * FROM tbl_trials tb where tb.User_ID = " . $request->userid . " order by id desc limit 1 ");

        return $allUsers;
    }

    public function getUserDetailsByID(Request $request)
    {
        $allUsers = Users::where('id', '=', $request->userid)->get();

        return $allUsers;
    }

    public function resetpasswordtodefault($userid)
    {

        $uId = Crypt::decrypt($userid);

        $user = Users::find($uId);
        $useridzero = str_repeat('0', (4) - strlen(rtrim($user->userid))) . $user->userid;
        $password = substr($user->Mobile, -4) . $useridzero;

        // return $password;

        $user->PassWord = md5($password);
        $user->save();

        return back()->with('success', 'Password has reset to default successfully : '.$password);
    }

    public function getSimilarClients(Request $request)
    {
        $newSearch = str_replace(' ', '%', $request->search);

        $products = DB::select(" SELECT * from clients WHERE ClientName LIKE '" . $newSearch . "%'  ");

        return $products;
    }

    public static function checkForPrivilege($clientid)
    {
        $exist = UserPermissions::where('Client_ID', '=', $clientid)->where('User_ID', '=', session('LoggedUser')['id'])->get();

        if (sizeof($exist) > 0) {
            return true;
        } else {

            return false;
        }
    }

    public static function savenewuser(Request $request)
    {
        $name = $request->name;
        $username = $request->username;
        $password = $request->password;
        $mobile = $request->mobile;
        $utype = $request->utype;
        $uclient = $request->uclient == '' ? $request->demoClientID : $request->uclient;
        $upack = $request->upack;
        $createddate = $request->createddate;
        $mobile4digit = substr($request->mobile, -4);
        
        $clientWithZero = str_repeat('0', (4) - strlen(rtrim($uclient))).$uclient;


        $demoClientName = $request->demoClientName;
        $demoClientID = $request->demoClientID;
        $demoClientArea = $request->demoClientArea;
        $demoClientLocation = $request->demoClientLocation;

        $checkSetPrivilage = $request->input('checkSetPrivilage') == null ? 0 : $request->input('checkSetPrivilage');
        $checkIsDemo = $request->input('checkIsDemo') == null ? 0 : $request->input('checkIsDemo');

        $multiuser = $request->input('multiuser') == null ? 0 : $request->input('multiuser');
        $singleuser = $request->input('singleuser') == null ? 0 : $request->input('singleuser');

        if ($multiuser == 1) {
            $M = 'M';
        } else if ($singleuser == 1) {
            $M = 'S';
        } else if ($multiuser == 1 && $singleuser == 1) {
            $M = 'SM';
        }

        $isAdmin = 0;
        $isUser = 0;
        $isShop = 0;
        $isStaff = 0;

        if ($utype == 'admin') {
            $isAdmin = 1;
        } else if ($utype == 'shop') {
            $isShop = 1;
        } else if ($utype == 'staff') {
            $isStaff = 1;
        } else if ($utype == 'user') {
            $isUser = 1;
        }

        $mobileexist = Users::where('Mobile', '=', $mobile)->first();
        $emailexist = Users::where('UserName', '=', $username)->first();

        if ($mobileexist) {
            return back()->with('fail', 'Mobile number already exist');
        } elseif ($emailexist) {
            return back()->with('fail', 'E-Mail already exist');
        } else {
            $bann = new Users();

            $bann->Name = $name;
            $bann->UserName = $username;
            $bann->PassWord = md5($mobile4digit.$clientWithZero);
            $bann->Mobile = $mobile;
            $bann->Package_ID = $upack;
            $bann->userid = $uclient;
            $bann->Active = 1;
            $bann->IsUser = $isUser;
            $bann->IsShop = $isShop;
            $bann->IsStaff = $isStaff;
            $bann->Admin = $isAdmin;
            $bann->is_MultiUser = $M;
            $bann->is_SingleUser = 0;
            $bann->is_demo = $checkIsDemo;

            $res = $bann->save();

            $lastid = $bann->id;

            if ($res) {

                $set = new TblSettings();

                $set->ClientID = $uclient;
                $set->max_users = 2;
                $set->user_id = $lastid;

                $setSuccess = $set->save();

                if ($setSuccess) {
                    $ashop = new TblAssignedShops();

                    $ashop->User_ID = $lastid;
                    $ashop->ClientID = $uclient;
                    $ashop->Managed_ClientID = $uclient;

                    $aShopSuccess = $ashop->save();

                    if ($checkIsDemo == 1) {

                        $trial = new FreeTrail();

                        $trial->User_ID = $lastid;
                        $trial->Client_ID = $uclient;
                        $trial->Package = $upack;
                        $trial->Type = 'Initial Demo';
                        $trial->From_Date = $request->start == null ? '' : $request->start;
                        $trial->To_Date = $request->end == null ? '' : $request->end;
                        $trial->AllottedDate = date("Y-m-d");

                        $completed = $trial->save();
                    }

                    if ($aShopSuccess) {

                        if ($checkSetPrivilage != 0) {

                            $start = $request->start;
                            $end = $request->end;

                            // create new privilage 
                            $actions = PermissionActions::where('act_package', '=', $upack)->get();

                            // return $actions;

                            for ($count = 0; $count < count($actions); $count++) {

                                $data = array(
                                    'Client_ID' => $uclient,
                                    'User_ID' => $lastid,
                                    'Package_ID'  => $upack,
                                    'per_act'  => $actions[$count]['id'],
                                    'per_from'  => $start,
                                    'per_to'  => $end,
                                    'status'  => $actions[$count]['act_status'],
                                    'userper_slug'  => $actions[$count]['act_slug']
                                );

                                $insert_data[] = $data;
                            }

                            UserPermissions::insert($insert_data);

                            $uze = Users::find($lastid);

                            $uze->IsLive = 0;
                            $bann->app_usage_date = $createddate;

                            $save = $uze->save();

                            if ($save) {
                                $trial = new FreeTrail();

                                $trial->User_ID = $lastid;
                                $trial->Client_ID = $uclient;
                                $trial->Package = $upack;
                                $trial->Type = 'Privilege';
                                $trial->From_Date = $start;
                                $trial->To_Date = $end;
                                $trial->AllottedDate = date("Y-m-d");

                                $completed = $trial->save();

                                if ($completed) {
                                    return back()->with('success', 'User created and Permission allotted Successfully');
                                } else {
                                    return back()->with('fail', 'Something went wrong');
                                }
                            } else {
                                return back()->with('fail', 'Something went wrong');
                            }
                            // create new privilage close
                        } else {
                            return back()->with('success', 'User created Successfully');
                        }
                    }
                }
            } else {
                return back()->with('fail', 'Something went wrong');
            }
        }
    }


    public static function createnewuser($id)
    {
        $client_id = Crypt::decrypt($id);

        if ($client_id == 0) {
            $clients = Clients::all();
        } else {
            $clients = Clients::where('ClientID', '=', $client_id)->get();
        }


        $data = [
            'clients' => $clients,
            'packages' => Packages::all(),
            'cid' => $client_id,
        ];

        return view('Admin.createnewusers', $data);
    }

    public static function getFromDateForTrial($userid)
    {
        $fromdate = UserPermissions::where('tbl_userpermissions.User_ID', '=', $userid)
            ->join('tbl_permissionActions', 'tbl_userpermissions.userper_slug', '=', 'tbl_permissionActions.act_slug')
            ->where('tbl_permissionActions.act_slug', '=', 'trial')
            ->pluck('per_from')->first();

        if ($fromdate != '') {
            return MainAcontroller::convertDate($fromdate);
        } else {
            return '';
        }
    }

    public static function getFromDateForTrialWithClient($userid, $client)
    {
        $fromdate = UserPermissions::where('tbl_userpermissions.User_ID', '=', $userid)->where('tbl_userpermissions.Client_ID', '=', $client)
            ->join('tbl_permissionActions', 'tbl_userpermissions.userper_slug', '=', 'tbl_permissionActions.act_slug')
            ->where('tbl_permissionActions.act_slug', '=', 'trial')
            ->pluck('per_from')->first();

        if ($fromdate != '') {
            return MainAcontroller::convertDate($fromdate);
        } else {
            return '';
        }
    }

    public static function getToDateForTrial($userid)
    {
        $todate =  UserPermissions::where('tbl_userpermissions.User_ID', '=', $userid)
            ->join('tbl_permissionActions', 'tbl_userpermissions.userper_slug', '=', 'tbl_permissionActions.act_slug')
            ->where('tbl_permissionActions.act_slug', '=', 'trial')
            ->pluck('per_to')->first();

        return MainAcontroller::convertDate($todate);
    }

    public static function getToDateForTrialWithClient($userid, $client)
    {
        $todate =  UserPermissions::where('tbl_userpermissions.User_ID', '=', $userid)->where('tbl_userpermissions.Client_ID', '=', $client)
            ->join('tbl_permissionActions', 'tbl_userpermissions.userper_slug', '=', 'tbl_permissionActions.act_slug')
            ->where('tbl_permissionActions.act_slug', '=', 'trial')
            ->pluck('per_to')->first();

        if ($todate != '') {
            return MainAcontroller::convertDate($todate);
        } else {
            return '';
        }
    }

    public static function getToDateForTrialWithClientID($userid, $client)
    {
        $todate =  UserPermissions::where('tbl_userpermissions.User_ID', '=', $userid)->where('tbl_userpermissions.Client_ID', '=', $client)
            ->join('tbl_permissionActions', 'tbl_userpermissions.userper_slug', '=', 'tbl_permissionActions.act_slug')
            ->where('tbl_permissionActions.act_slug', '=', 'trial')
            ->pluck('per_to')->first();

        if ($todate != '') {
            return MainAcontroller::convertDate($todate);
        } else {
            return '';
        }
    }



    public static function getFromDateForTrialAdmin($userid, $clientid)
    {
        $fromdate = UserPermissions::where('tbl_userpermissions.User_ID', '=', $userid)
            ->where('tbl_userpermissions.Client_ID', '=', $clientid)
            ->join('tbl_permissionActions', 'tbl_userpermissions.userper_slug', '=', 'tbl_permissionActions.act_slug')
            ->where('tbl_permissionActions.act_slug', '=', 'trial')
            ->pluck('per_from')->first();

        return MainAcontroller::convertDate($fromdate);
    }

    public static function getToDateForTrialAdmin($userid, $clientid)
    {
        $todate =  UserPermissions::where('tbl_userpermissions.User_ID', '=', $userid)
            ->where('tbl_userpermissions.Client_ID', '=', $clientid)
            ->join('tbl_permissionActions', 'tbl_userpermissions.userper_slug', '=', 'tbl_permissionActions.act_slug')
            ->where('tbl_permissionActions.act_slug', '=', 'trial')
            ->pluck('per_to')->first();

        return MainAcontroller::convertDate($todate);
    }

    public function createSubUser(Request $request)
    {
        $name = $request->name;
        $username = $request->username;
        $password = $request->password;
        $package = $request->package;
        $clientid = $request->clientid;

        $usercount = Users::where('userid', '=', $clientid)->count();

        $maxuserconnection = Users::where('userid', '=', $clientid)->where('IsPrimary', '=', 1)->pluck('max_connections')->first();

        if ($usercount < $maxuserconnection) {

            $exist = Users::where('UserName', '=', $username)->first();

            if ($exist) {
                return back()->with('fail', 'E-Mail already exist');
            } else {
                $bann = new Users();

                $bann->Name = $name;
                $bann->UserName = $username;
                $bann->PassWord = md5($password);
                $bann->Package_ID = $package;
                $bann->userid = $clientid;
                $bann->Active = 1;
                $bann->IsStaff = 1;

                $res = $bann->save();

                if ($res) {
                    return back()->with('success', 'Sub User created Successfully');
                } else {
                    return back()->with('fail', 'Something went wrong');
                }
            }
        } else {
            return back()->with('fail', 'Max user connection is exceeded');
        }

        $data = [
            'usercount' => $usercount,
            'maxuser' => $maxuserconnection
        ];

        return $data;
    }

    public function managesubusers($userid)
    {
        $user = Crypt::decrypt($userid);

        $data = [

            'clientid' => $user,
            'users' => Users::where('userid', '=', $user)
                ->where('isPrimary', '=', '0')
                ->join('tbl_packages', 'user.Package_ID', '=', 'tbl_packages.id')
                ->get()

        ];
        // return $data;
        return view('Admin.managesubusers', $data);
    }

    public function purchaseorderpdf()
    {
        return view('Admin.purchaseorderpdf');
    }

    public function mainprivacypolicy()
    {
        return view('Admin.mainprivacy');
    }

    public function privacypolicy()
    {
        return view('Admin.privacy');
    }

    public function terms()
    {
        return view('Admin.terms');
    }

    public function changeSessionClientID(Request $request)
    {
        $id = session('LoggedUser')['id'];
        $name = session('LoggedUser')['name'];
        $shopname = Clients::where('ClientID', '=', $request->client)->pluck('ClientName')->first();
        $email = session('LoggedUser')['email'];
        $mobile = session('LoggedUser')['mobile'];
        $userRole = session('LoggedUser')['userRole'];
        // $userid = session('LoggedUser')['userid'];
        $managedShops = session('LoggedUser')['managedShops'];
        $ClientID = session('LoggedUser')['ClientID'];

        $request->session()->put('LoggedUser', [
            'id' =>  $id,
            'name' =>  $name,
            'shopname' =>  $shopname,
            'email' =>  $email,
            'mobile' => $mobile,
            'userRole' => $userRole,
            'userid' => $request->client,
            'ClientID' => $ClientID,
            'managedShops' => $managedShops
        ]);
    }

    public static function getShopDetailsByClientID($id)
    {
        $shopname = Clients::where('ClientID', '=', $id)->pluck('ClientName')->first();
        $Area = Clients::where('ClientID', '=', $id)->pluck('Area')->first();
        $Location = Clients::where('ClientID', '=', $id)->pluck('Location')->first();
        return $shopname . '|' . $Area . '|' . $Location;
    }

    public static function getShopNameByClientID($id)
    {
        $shopname = Clients::where('ClientID', '=', $id)->pluck('ClientName')->first();
        return $shopname;
    }

    public static function getShopAreaLocationByClientID($id)
    {
        $Area = Clients::where('ClientID', '=', $id)->pluck('Area')->first();
        $Location = Clients::where('ClientID', '=', $id)->pluck('Location')->first();
        return $Area . " , " . $Location;
    }

    public static function getBillingTypeForUser($user)
    {
        $Area = Users::where('id', '=', $user)->pluck('billing_type')->first();

        return $Area;
    }

    public static function checkForPODeletion($client, $user)
    {

        $pack_id = Users::where('id', '=', $user)->pluck('Package_ID')->first();

        // $shopname = UserPermissions::select('tbl_userpermissions.*','tbl_permissionActions.act_slug')
        // ->join('tbl_permissionActions','tbl_userpermissions.Package_ID','=','tbl_permissionActions.act_package')->orOn()
        // ->where('tbl_permissionActions.act_slug','=','deletepurchaseorder')
        // ->where('tbl_userpermissions.Client_ID','=', $client )
        // ->where('tbl_userpermissions.User_ID','=', $user )
        // ->where('tbl_userpermissions.Package_ID','=', $pack_id )
        // ->groupby('tbl_permissionActions.act_slug')
        // ->pluck('tbl_userpermissions.status')
        // ->first();

        $shopname = DB::select(" SELECT UP.* FROM tbl_userpermissions UP
        Join tbl_permissionActions PA on UP.Package_ID = PA.act_package and UP.userper_slug = PA.act_slug
        where PA.act_slug = 'deletepurchaseorder' and UP.Client_ID = " . $client . " and UP.User_ID = " . $user . " and UP.Package_ID = " . $pack_id . "
        group by PA.act_slug ");

        $status = 0;

        foreach ($shopname as $sh) {
            $status = $sh->status;
        }

        return $status;
    }

    public static function numberToWord($num = '')
    {
        $num    = (string) ((int) $num);

        if ((int) ($num) && ctype_digit($num)) {
            $words  = array();

            $num    = str_replace(array(',', ' '), '', trim($num));

            $list1  = array(
                '', 'one', 'two', 'three', 'four', 'five', 'six', 'seven',
                'eight', 'nine', 'ten', 'eleven', 'twelve', 'thirteen', 'fourteen',
                'fifteen', 'sixteen', 'seventeen', 'eighteen', 'nineteen'
            );

            $list2  = array(
                '', 'ten', 'twenty', 'thirty', 'forty', 'fifty', 'sixty',
                'seventy', 'eighty', 'ninety', 'hundred'
            );

            $list3  = array(
                '', 'thousand', 'million', 'billion', 'trillion',
                'quadrillion', 'quintillion', 'sextillion', 'septillion',
                'octillion', 'nonillion', 'decillion', 'undecillion',
                'duodecillion', 'tredecillion', 'quattuordecillion',
                'quindecillion', 'sexdecillion', 'septendecillion',
                'octodecillion', 'novemdecillion', 'vigintillion'
            );

            $num_length = strlen($num);
            $levels = (int) (($num_length + 2) / 3);
            $max_length = $levels * 3;
            $num    = substr('00' . $num, -$max_length);
            $num_levels = str_split($num, 3);

            foreach ($num_levels as $num_part) {
                $levels--;
                $hundreds   = (int) ($num_part / 100);
                $hundreds   = ($hundreds ? ' ' . $list1[$hundreds] . ' Hundred' . ($hundreds == 1 ? '' : 's') . ' ' : '');
                $tens       = (int) ($num_part % 100);
                $singles    = '';

                if ($tens < 20) {
                    $tens = ($tens ? ' ' . $list1[$tens] . ' ' : '');
                } else {
                    $tens = (int) ($tens / 10);
                    $tens = ' ' . $list2[$tens] . ' ';
                    $singles = (int) ($num_part % 10);
                    $singles = ' ' . $list1[$singles] . ' ';
                }
                $words[] = $hundreds . $tens . $singles . (($levels && (int) ($num_part)) ? ' ' . $list3[$levels] . ' ' : '');
            }
            $commas = count($words);
            if ($commas > 1) {
                $commas = $commas - 1;
            }

            $words  = implode(', ', $words);

            $words  = trim(str_replace(' ,', ',', ucwords($words)), ', ');
            if ($commas) {
                $words  = str_replace(',', ' and', $words);
            }

            return $words;
        } else if (!((int) $num)) {
            return 'Zero';
        }
        return '';
    }



    public static function convertDateandTime($getDate)
    {
        return date('d-m-Y h:i:s a ', strtotime($getDate));
    }

    public static function convertDatetoExpiry($getDate)
    {
        $date = substr($getDate, 0, 10);
        $normDate = date('m-Y', strtotime($date));

        $month = substr($normDate, 0, 2);
        $year = substr($normDate, 5, 7);

        return $month . "/" . $year;
    }


    public static function convertDate($getDate)
    {
        $date = str_replace('/', '-', $getDate);
        return date('d-m-Y', strtotime($date));
    }

    public static function convertDateYYMMDD($getDate)
    {
        $date = str_replace('/', '-', $getDate);
        return date('Y-m-d', strtotime($date));
    }

    public static function findDay($getDate)
    {
        // $date = str_replace('/', '-', $getDate);

        $day = Carbon::createFromFormat('d-m-Y', $getDate)->format('l');
        return substr($day, 0, 3);
    }


    function login()
    {
        return view('Auth.login');
    }

    function validateLogin(Request $request)
    {
        $acc_type = '';
        $email = $request->email;
        $password = $request->password;

        $hashPassword = md5($password);
        $adminAccount = Users::where('UserName', '=', $email)->first();
        $flag = true;

        if ($adminAccount->IsUser == 1) {
            $acc_type = 'user';
        } else if ($adminAccount->IsShop == 1) {
            $acc_type = 'shop';

            $inactiveValue = Clients::where('ClientID', '=', $adminAccount->userid)->pluck('Inactive')->first();

            if ($inactiveValue == 0) {
                $flag = true;
            } else {
                $flag = false;
            }
        } else if ($adminAccount->Admin == 1) {
            $acc_type = 'admin';
        }


        if ($adminAccount->Package_ID != 0) {
            if ($adminAccount->isWebLogin == 1 && $flag) {

                if ($adminAccount->PassWord == $hashPassword) {

                    $clientID = $adminAccount->userid;

                    $assignedShops = AssignedShops::where('ClientID', '=', $clientID)->get();
                    $shopname = Clients::where('ClientID', '=', $adminAccount->userid)->pluck('ClientName')->first();

                    $request->session()->put('LoggedUser', [
                        'id' =>  $adminAccount->id,
                        'name' =>  $adminAccount->Name,
                        'shopname' =>  $shopname,
                        'email' =>  $adminAccount->UserName,
                        'mobile' => $adminAccount->Mobile,
                        'userRole' => $acc_type,

                        'userid' => $adminAccount->userid,
                        'ClientID' => $adminAccount->userid,

                        'managedShops' => $assignedShops
                    ]);

                    return redirect('dashboard');
                } else {

                    return back()->with('fail', 'Incorrect password');
                }
            } else {
                return back()->with('fail', 'Web login is restricted or Client is blocked contact administrator');
            }
        } else {
            return back()->with('fail', 'Your account dont have an active pack to manage');
        }
    }

    function dashboard()
    {
        if (session('LoggedUser')['userRole'] == "shop") {

            $stockRPTS = ReportPermission::where('client_id', '=', session('LoggedUser')['userid'])->where('slug_url', '=', 'STKRPT')->pluck('status');

            $client = session('LoggedUser')['userid'];
            $id = session('LoggedUser')['id'];

            $data = [

                'slug' => Users::select("tbl_packages.Pack_Name")
                    ->leftjoin('tbl_packages', 'user.Package_ID', '=', 'tbl_packages.id')
                    ->where('user.userid', '=', $client)
                    ->where('user.id', '=', $id)
                    ->first(),

                'stockRPT' => $stockRPTS,
                'userid' => $id

            ];
        } else {
            $data = [
                 'clients' => Clients::count(),
                'users' => Users::where('IsShop', '=', '1')->where('active', '=', '1')->count(),
                'noactive' =>  Users::where('IsLive', '=', 2)->where('IsShop', '=', 1)->count(),
                'trial' =>  Users::where('IsLive', '=', 0)->where('IsShop', '=', 1)->where('active', '=', 1)->count(),
                'active' =>  Users::where('IsLive', '=', 1)->where('IsShop', '=', 1)->where('active', '=', 1)->count(),
                'logginedusers' =>  Users::where('app_login_count', '!=', 0)->count(),
                'customerappusers' =>  Users::where('IsUser', '=', 1)->count(),
                'packusers' => DB::select("SELECT tbl_packages.id as packid,tbl_packages.Pack_Name,tbl_packages.Pack_Slug,COUNT(user.id) as pack FROM `user` join tbl_packages on user.Package_ID = tbl_packages.id where user.IsShop = 1 and active = 1 group by user.Package_ID")
            ];
        }



        return view('Admin.dashboard', $data);
        // return  $data;
    }

    public static function logout()
    {
        if (session()->has('LoggedUser')) {
            session()->pull('LoggedUser');
            return redirect('/');
        }
    }
}
