@extends('Admin.Layouts.master')

<style>
    .answer {
        display: visible
    }
</style>

@section('content')
<div class="card">
    <div class="card-body">

        @if ($message = Session::get('success'))
        <div class="alert border-0 bg-light-success alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-success"><i class="bi bi-check-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-success">{{ $message }}</div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        @if ($message = Session::get('fail'))
        <div class="alert border-0 bg-light-danger alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-danger"><i class="bi bi-x-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-danger">
                        {{$message}}
                    </div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        <div class="border p-4 rounded">
            <div class="card-title d-flex align-items-center">
                <h5 class="mb-0">Create User</h5>
            </div>
            <hr />

            <form method="post" action="{{ route('web.savenewuser') }}" enctype="multipart/form-data">
                @csrf

                <div class="row mb-3">
                    <label for="inputEnterYourName" class="col-sm-3 col-form-label">Name</label>
                    <div class="col-sm-9">
                        <input name="name" type="text" required class="form-control" id="inputEnterYourName">
                    </div>
                </div>

                <div class="row mb-3">
                    <label for="inputEnterYourName" class="col-sm-3 col-form-label">Username</label>
                    <div class="col-sm-9">
                        <input name="username" type="email" autocomplete="off" required class="form-control" id="inputEnterYourName">
                    </div>
                </div>

                <div hidden class="row mb-3">
                    <label for="inputEnterYourName" class="col-sm-3 col-form-label">Password</label>
                    <div class="col-sm-9">
                        <input name="password" type="password" autocomplete="off"  class="form-control" id="inputEnterYourName">
                    </div>
                </div>

                <div class="row mb-3">
                    <label for="inputEnterYourName" class="col-sm-3 col-form-label">Mobile</label>
                    <div class="col-sm-9">
                        <input name="mobile" type="number" required class="form-control" id="inputEnterYourName">
                    </div>
                </div>



                <div class="row mb-3">
                    <label for="inputPhoneNo2" class="col-sm-3 col-form-label">User Type </label>
                    <div class="col-sm-9">
                        <select required name="utype" type="text" class="single-select" id="" placeholder="">
                            <option value=""> Choose one </option>

                            <option value="admin"> Admin </option>
                            <option value="shop"> Shop </option>
                            <option value="staff"> Staff </option>
                            <option value="user"> User </option>

                        </select>
                    </div>
                </div>

                <div class="row mb-3">

                    <label for="inputPhoneNo2" class="col-sm-3 col-form-label"> Account Type </label>

                    <div class="col-sm-9">
                        <div class="form-check form-check-inline">
                            <input name="checkIsDemo" class="form-check-input" type="checkbox" id="for_demo" value="1">
                            <label class="form-check-label" for="for_demo"> Check if create for demo purpose </label>
                        </div>
                    </div>

                </div>

                <div class="row mb-3">
                    <label for="inputPhoneNo2" class="col-sm-3 col-form-label">Client </label>
                    <div class="col-sm-9">
                        <select name="uclient" type="text" class="single-select selectedClient" placeholder="">
                            <option value=""> Choose one </option>
                            @foreach($clients as $client)
                            <option data-id=" {{ $client->ClientName }} | {{ $client->ClientID }} | {{ $client->Area }} | {{ $client->Location }} " value="{{ $client->ClientID }}"> {{ $client->ClientID }} | {{ $client->ClientName }} | {{ $client->Area }} | {{ $client->Location }} </option>
                            @endforeach
                        </select>
                    </div>
                </div>

                <div class="row mb-3">

                    <label for="inputPhoneNo2" class="col-sm-3 col-form-label"> Demo For </label>

                    <div class="col-sm-3">
                        <input placeholder="Client name" name="demoClientName" class="form-control" type="text" id="demoClientName" value="ASWAS COMMUNITY PHARMACY">
                    </div>
                    <div class="col-sm-2">
                        <input placeholder="Client id" name="demoClientID" class="form-control" type="text" id="demoClientID" value="50">
                    </div>
                    <div class="col-sm-2">
                        <input placeholder="Client area" name="demoClientArea" class="form-control" type="text" id="demoClientArea" value="Thiruvananthapuram">
                    </div>
                    <div class="col-sm-2">
                        <input placeholder="Client location" name="demoClientLocation" class="form-control" type="text" id="demoClientLocation" value="Karamana">
                    </div>

                </div>

                <div class="row mb-3">
                    <label for="inputPhoneNo2" class="col-sm-3 col-form-label"> Package </label>
                    <div class="col-sm-9">
                        <select required name="upack" type="text" class="single-select" id="" placeholder="">
                            <option value=""> Choose one </option>
                            @foreach($packages as $pack)
                            <option value="{{ $pack->id }}"> {{ $pack->Pack_Name }} </option>
                            @endforeach
                        </select>
                    </div>
                </div>

                <div class="row mb-3">

                    <label for="inputPhoneNo2" class="col-sm-3 col-form-label"> User Type </label>

                    <div class="col-sm-9">
                        <div class="form-check form-check-inline">
                            <input name="multiuser" class="form-check-input" type="checkbox" id="inlineCheckbox1" value="1">
                            <label class="form-check-label" for="inlineCheckbox1">Multi User</label>
                        </div>

                        <div class="form-check form-check-inline">
                            <input name="singleuser" class="form-check-input" type="checkbox" id="inlineCheckbox2" value="1">
                            <label class="form-check-label" for="inlineCheckbox2">Single User</label>
                        </div>
                    </div>

                </div>

                <div class="row mb-3">
                    <label for="inputEnterYourName" class="col-sm-3 col-form-label">Created date</label>
                    <div class="col-sm-9">
                        <input readonly name="createddate" type="date" value="<?php echo date('Y-m-d'); ?>" required class="form-control" id="inputEnterYourName">
                    </div>
                </div>

                <div class="row mb-3">

                    <label for="inputPhoneNo2" class="col-sm-3 col-form-label"> Privilage </label>

                    <div class="col-sm-9">
                        <div class="form-check form-check-inline">
                            <input name="checkSetPrivilage" class="form-check-input" type="checkbox" id="coupon_question" value="1">
                            <label class="form-check-label" for="coupon_question"> Set Privilage </label>
                        </div>
                    </div>

                </div>

                <div class="row mb-3 answer">

                    <label for="inputPhoneNo2" class="col-sm-3 col-form-label"> From </label>

                    <div class="col-sm-3">
                        <input value="<?php echo date('Y-m-d'); ?>" min="<?php echo date('Y-m-d'); ?>" name="start" type="date" class="form-control" id="startdate">
                    </div>

                    <div class="col-sm-3">
                        <input placeholder="enter number of days" name="daysCount" type="number" class="form-control onDateInput" id="daysCount">
                    </div>

                    <div class="col-sm-3">
                        <input name="end" type="date" class="form-control" id="enddate">
                    </div>

                </div>


                <div class="row">
                    <label class="col-sm-3 col-form-label"></label>
                    <div class="col-sm-9">
                        <button type="submit" class="btn btn-primary px-5">Create</button>
                    </div>
                </div>


            </form>

        </div>





    </div>
</div>

<script>
    $(document).ready(function() {


        $('.selectedClient').on('change', function() {
            var res = $(this).find(':selected').attr('data-id')
            //    alert(res);
            var myarr = res.split("|");

            document.getElementById('demoClientName').value = myarr[0];
            document.getElementById('demoClientID').value = myarr[1];
            document.getElementById('demoClientArea').value = myarr[2];
            document.getElementById('demoClientLocation').value = myarr[3];


        });



        $(".onDateInput").change(function() {

            const count = document.getElementById('daysCount').value;

            const start = new Date(document.getElementById('startdate').value);
            // alert(start);

            start.setDate(start.getDate() + parseInt(count));
            // alert(start.toLocaleDateString());

            document.getElementById('enddate').value = start.toISOString().slice(0, 10);


        });

        $(".answer").toggle(false);

        $("#coupon_question").on("click", function() {

            const start = document.getElementById('startdate');
            const end = document.getElementById('enddate');

            if (this.checked) {
                $(".answer").toggle(this.checked);
                start.setAttribute('required', '');
                end.setAttribute('required', '');
            } else {
                $(".answer").toggle(this.checked);
                start.removeAttribute('required');
                end.removeAttribute('required');
            }
        });

        $(".showImageLarge").click(function() {

            var id = $(this).data('path');
            document.getElementById("bannerLargeImage").src = id;
            $('#exampleLargeBanner').modal('show');

        });

        $.ajax({
            type: "GET",
            dataType: "json",
            url: "{{ route('web.getAllClients') }}",

            success: function(data) {

                $("#bannerSelectShops").empty();

                $('#bannerSelectShops')
                    .append($("<option></option>")
                        .attr("value", "")
                        .text("Choose one"));

                $.each(data, function(index, value) {

                    $('#bannerSelectShops')
                        .append($("<option></option>")
                            .attr("value", value.ClientID)
                            .text(value.ClientName + "|" + value.ClientID + "|" + value.Area + "|" + value.Location))

                });

            }
        });

    });
</script>
@endsection