<!DOCTYPE html>
<html>

<head>
    <style>
        .table {
            font-family: arial, sans-serif;
            border-collapse: collapse;
            width: 100%;
            font-size: 8px;
        }

        .nobdtable {
            font-family: arial, sans-serif;
            border-collapse: collapse;
            width: 100%;
            font-size: 8px;
        }

        .td,
        .th {
            border: .5px solid black;
            text-align: left;
            padding: 8px;
            font-size: 8px;
        }

        .notd {
            border-top: .5px solid white;
            border-bottom: .5px solid black;
            text-align: left;
            padding: 8px;
            font-size: 8px;
        }

        .box {
            overflow-y: auto;
            height: 800px;
        }

        #watermark {
            position: fixed;
            bottom: 9px;
            right: 9px;
            opacity: 0.4;
            color: black;
            background-color: rgba(131, 50, 185, 0.5);
            height: 40px;
            width: 100px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        #myid {
            background-color: azure;
            height: 125px;
        }

        .alignleft {
            float: left;
            font-size: 8px;
        }

        .alignright {
            float: right;
        }

        .alncenter {
            text-align: center;
        }

        .alnleft {
            text-align: right;
        }

        .alnright {
            text-align: right;
        }

        /* .table td {
            font-size: .8em;
        }

        .table th {
            font-size: .8em;
        } */



        /* label { 
            font-size: .8em
        }  */
    </style>
</head>

<body>


    <?php

    use App\Http\Controllers\MainAcontroller;
    use App\Http\Controllers\ProductController; ?>
    <div class="card">
        <div class="card-body">
            <div class="table-responsive box">


                @if($demo == 1)
                <center> <span class="alncenter"> DEMO </span></center>
                <center> <span class="alncenter"> Demo , Demo </span></center>
                @else
                <center> <span class="alncenter"> {{ $clientName }} </span></center>
                <center> <span class="alncenter"> {{ $clietArea }} , {{ $clientLocation }} </span></center>
                @endif


                <center> <span class="alncenter">{{ $title }}</span></center>
                <center> <span class="alncenter">Report generated on : <?php echo date('d-m-Y'); ?></span></center>

                <?php
                $num = 1;
                $totalCost = ProductController::getExpiredProductsSUMByClientID(0, $from, $to, $clientid);
                ?>

                <br>

                <table class="table">

                    <tr>
                        <td class="td" width="5%">SL</td>
                        <td class="td" width="30%">Product Name</td>
                        <td class="td" width="10%">Company</td>
                        <td class="td" width="10%">Batch</td>
                        <td class="td" width="5%">Exp. Dt.</td>
                        <td class="td" width="5%">Pack</td>
                        <td class="td" width="10%">MRP</td>
                        <td class="td" width="5%">Qty</td>
                        <td class="td" width="10%">P. Value</td>
                        <td class="td" width="10%">MRP Value</td>
                    </tr>

                    @foreach($expiry as $client)

                    <tr>
                        <td class="td">{{ $num }}</td>

                        <td class="td" align="left">{{ $client->product_name }} </td>

                        <td class="td" align="left">{{ $client->company_name }}</td>

                        <td class="td" align="center">{{ $client->batch }}</td>
                        <td class="td" align="center"> <?php echo MainAcontroller::convertDatetoExpiry($client->expiry) ?> </td>

                        <td class="td" align="center">{{ $client->pack }}</td>
                        <td class="td" align="center"> <?php echo number_format((float)$client->MRPPack, 2, '.', '') ?> </td>

                        <td class="td" align="center">{{ $client->stkqty }}</td>

                        <td class="alnright td"> <?php echo number_format((float)$client->PAmt, 2, '.', '') ?> </td>

                        <td class="alnright td"> <?php echo number_format((float)$client->MRPAmt, 2, '.', '') ?> </td>
                    </tr>

                    <?php $num++; ?>

                    @endforeach

                </table>


                <table class="nobdtable">
                    <tr>
                        <td class="notd" width="5%"></td>
                        <td class="notd" width="30%"></td>
                        <td class="notd" width="10%"></td>
                        <td class="notd" width="10%"></td>
                        <td class="notd" width="5%"></td>
                        <td class="notd" width="5%"></td>
                        <td class="notd" width="10%"></td>
                        <td class="notd" width="5%"></td>
                        <td class="notd" width="10%"></td>
                        <td class="notd" width="10%"></td>
                    </tr>

                    @foreach($totalCost as $tot)
                    <tr>
                        <td colspan="8" class="alnleft td"> Total Purchase Amount and MRP Amount </td>
                        <td class="alnright td"> <strong> <?php echo number_format((float)$tot->pCost, 2, '.', '') ?> </strong> </td>
                        <td class="alnright td"> <strong> <?php echo number_format((float)$tot->MRPCost, 2, '.', '') ?> </strong> </td>
                    </tr>
                    @endforeach
                </table>

                <span> Powered by MEDISOFT &#169; 2023</span>


            </div>
        </div>
    </div>



</body>

</html>