@extends('Admin.Layouts.master')

@section('content')

<?php

use App\Http\Controllers\MainAcontroller; ?>

<div class="card">
    <div class="card-body">

        @if ($message = Session::get('success'))
        <div class="alert border-0 bg-light-success alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-success"><i class="bi bi-check-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-success">{{ $message }}</div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        @if ($message = Session::get('fail'))
        <div class="alert border-0 bg-light-danger alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-danger"><i class="bi bi-x-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-danger">
                        {{$message}}
                    </div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        <h6 class="mb-0 text-uppercase text-center"> Bill NO : {{ $billno[0] }} <br> Edit ID : {{ $editid }} </h6>
        <hr />

        <div class="table-responsive">
            <table data-page-length='10' id="example2" class="table table-striped table-bordered">
                <thead class="table-secondary">
                    <tr>
                        <th>Sl No</th>
                        <th>Item</th>
                        <th>Batch</th>
                        <th>Quantity</th>
                        <th>Rate</th>
                        <th>Amount</th>

                        
                    </tr>
                </thead>
                <tbody>
                    <?php $num = 1; ?>
                    @foreach($total as $cli)
                    <tr>
                        <td>{{ $num }}</td>

                        <td>{{ $cli->Item_description }} </td>
                        <td>{{ $cli->batch }}</td>
                        <td>{{ $cli->quantity }}</td>
                        <td>{{ $cli->Rate }}</td>
                        <td>{{ $cli->amount }}</td>

                    </tr>
                    <?php $num++; ?>
                    @endforeach

                </tbody>
            </table>
        </div>
    </div>
</div>

<script>
    $(document).ready(function() {
        $(".clickToView").click(function() {
            $('#modalClientDetails').modal('show');

        });

        $(".deleteClient").click(function() {

            var id = $(this).data('id');

            document.getElementById("deleteClientID").value = id;

            $('#modalDeleteClient').modal('show');

        });

    });
</script>

@endsection