@extends('Admin.Layouts.master')

@section('content')

<div class="card">
    <div class="card-body">

        @if ($message = Session::get('success'))
        <div class="alert border-0 bg-light-success alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-success"><i class="bi bi-check-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-success">{{ $message }}</div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        @if ($message = Session::get('fail'))
        <div class="alert border-0 bg-light-danger alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-danger"><i class="bi bi-x-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-danger">
                        {{$message}}
                    </div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="ps-3">
                <h6 class="mb-0 text-uppercase">Manage Users</h6>
            </div>
            <div class="ms-auto">
                <div class="btn-group">

                    <a href="{{ route('web.createnewuser',Crypt::encrypt(0)) }}" class="btn btn-primary"> <i class="fadeIn animated bx bx-image-add"></i> Create User </a>
                </div>
            </div>
        </div>


        <hr />

        <div class="table-responsive">
            <!-- data-page-length='10' id="example2" class="table table-striped table-bordered" -->
            <table id="example" class="display" style="width:100%">
                <thead class="table-secondary">
                    <tr>
                        <th width="5%">Sl No</th>
                        <th width="10%">Name</th>
                        <th width="10%">Username</th>
                        <th width="10%">Package </th>
                        <th width="10%">Package Status</th>
                        <th width="10%">Package Expiry</th>
                        <!-- <th width="10%">Account Type</th> -->
                        <!-- <th width="10%">Managed Shops</th> -->
                        <!-- <th width="10%">App Status</th> -->
                        <!-- <th width="10%">Web Status</th> -->
                        <th width="10%">Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php

                    use App\Http\Controllers\GeneralController;
                    use App\Http\Controllers\MainAcontroller;

                    $num = 1; ?>
                    @foreach($users as $client)
                    <tr>
                        <td>{{ $num }}</td>

                        <td>
                            
                            <label class="text-danger"> User ID : {{ $client->id }} </label>

                            @if($client->IsLive == 1)
                            <span class="badge bg-success">Live Pack</span>
                            @elseif($client->IsLive == 0)
                            <span class="badge bg-danger">Trial Pack</span>
                            @endif

                            @if($client->is_demo == 1)
                            <span class="badge bg-danger">Demo Account</span>
                            @elseif($client->is_demo == 0)
                            <span class="badge bg-success">Main Account</span>
                            @endif


                            @if($client->is_MultiUser == 'S')
                            <span class="badge bg-danger"> Single User </span>
                            @elseif($client->is_MultiUser == 'M')
                            <span class="badge bg-info"> Multi User </span>
                            @elseif($client->is_MultiUser == 'SM')
                            <span class="badge bg-success"> Single and Multi User </span>
                            @endif
                            <br>

                            {{ $client->Name }}
                            <br>
                            {{ $client->ClientName }} - <label class="text-danger"> {{ $client->userid }} </label>
                            {{ $client->Area }} , {{ $client->Location }}


                            <p>Managed Shops : <?php echo GeneralController::managedShopListUserID($client->id) ?></p>

                            @if($client->Active == 1)
                            App Login : <label style="color: green;">Active</label>
                            @else
                            App Login : <label style="color: red;">Inactive</label>
                            @endif
                            &nbsp; <label class="text-danger"> | </label>
                            @if($client->isWebLogin == 1)
                            Web Login <label style="color: green;">Active</label>
                            @else
                            Web Login <label style="color: red;">Inactive</label>
                            @endif

                        </td>
                        <td>
                            <p> {{ $client->UserName }} </p>
                            <p> {{ $client->Mobile }} </p>

                        </td>

  <td>
                            @if($client->Package_ID == 3)
                            <span> Platinum User </span>
                            @elseif($client->Package_ID == 2)
                            <span> Gold User </span>
                            @elseif($client->Package_ID == 1)
                            <span> Silver User </span>
                            @endif
                        </td>

                        @if($client->IsLive == 2)

                        <td align="center"> <label style="color: red;"> No Active Pack </label> </td>

                        @elseif( $client->IsLive == 1 )

                        <td align="center"> <label style="color: green;">Active Pack</label> , <label class="text-success"> 
                        @if($client->billing_type == 'Y') 
                        <label class="text-danger">Yearly Billing</label> 
                        @elseif($client->billing_type == 'M') 
                        <label class="text-danger">Monthly Billing</label> 
                        @endif </label> <br>

                            <a href="{{ route('web.assignedAppPermissions',[ Crypt::encrypt($client->id) , Crypt::encrypt($client->userid)] )}}" class="btn alert-success radius-30 px-4"> <label > <?php echo MainAcontroller::getFromDateForTrial($client->id) ?> to <?php echo MainAcontroller::getToDateForTrial($client->id) ?></label> </a>

                        </td>

                        @else
                        <td align="center"> <label style="color: blue;">Trial</label> <br>

                            <a href="{{ route('web.assignedAppPermissions',[ Crypt::encrypt($client->id) , Crypt::encrypt($client->userid)] )}}" class="btn alert-info radius-30 px-4"> <label><?php echo MainAcontroller::getFromDateForTrial($client->id) ?> to <?php echo MainAcontroller::getToDateForTrial($client->id) ?></label> </a>

                        </td>
                        @endif

                        @if($client->per_to != null || $client->per_to != '' )
                        <td>
                            <a hidden>{{ $client->per_to }}</a>
                            @if( GeneralController::daysleft($client->per_to) == 'Date is Expired' )
                            <a href="{{ route('web.assignedAppPermissions',[ Crypt::encrypt($client->id) , Crypt::encrypt($client->userid)] )}}">
                                <label class="btn btn-danger"> <?php echo GeneralController::daysleft(MainAcontroller::getToDateForTrial($client->id)) ?> </label>
                            </a>
                            @else

                            @if($client->IsLive == 1)
                            <a href="{{ route('web.assignedAppPermissions',[ Crypt::encrypt($client->id) , Crypt::encrypt($client->userid)] )}}">
                                <label class="btn btn-success"> <?php echo GeneralController::daysleft(MainAcontroller::getToDateForTrial($client->id)) ?> </label>
                            </a>
                            @elseif($client->IsLive == 0)
                            <a href="{{ route('web.assignedAppPermissions',[ Crypt::encrypt($client->id) , Crypt::encrypt($client->userid)] )}}">
                                <label class="btn btn-info"> <?php echo GeneralController::daysleft(MainAcontroller::getToDateForTrial($client->id)) ?> </label>
                            </a>
                            @endif

                            @endif
                        </td>
                        @else
                        <td> <label class="text-danger">Not Found</label> </td>
                        @endif




                        <td>

                            @if( $client->IsUser == 1 || $client->IsShop == 1 || $client->IsStaff == 1 || $client->Admin == 1 )

                            <div class="col">
                                <div class="dropdown">
                                    <button class="btn btn-primary dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">Actions</button>
                                    <ul class="dropdown-menu">
                                        
                                         <li><a class="dropdown-item text-danger" href="{{ route('web.deleteusersfromdb',Crypt::encrypt($client->id)) }}">Delete User</a>
                                        </li>

                                        @if($client->Active == 1)
                                        <li><a class="dropdown-item text-danger" href="{{ route('web.updateAppLoginStatus',Crypt::encrypt($client->id)) }}">Disable App Login</a>
                                        </li>
                                        @else
                                        <li><a class="dropdown-item text-success" href=" {{ route('web.updateAppLoginStatus',Crypt::encrypt($client->id)) }}">Enable App Login</a>
                                        </li>
                                        @endif

                                        @if($client->isWebLogin == 1)
                                        <li><a class="dropdown-item text-danger" href="{{ route('web.updatewebpermissionstatus',Crypt::encrypt($client->id))}}">Disable Web Login</a>
                                        </li>
                                        @else
                                        <li><a class="dropdown-item text-success" href="{{ route('web.updatewebpermissionstatus',Crypt::encrypt($client->id))}}">Enable Web Login</a>
                                        </li>
                                        @endif

                                        <!-- <li><a class="dropdown-item" href="{{ route('web.manageUserPermissions',[ Crypt::encrypt($client->id) , Crypt::encrypt($client->userid)] )}}">Permissions</a>
                                        </li> -->

                                        <!-- <li><a class="dropdown-item" href="{{ route('web.assignUserPermission',[ Crypt::encrypt($client->id) , Crypt::encrypt($client->userid)] )}}">Permissions</a>
                                        </li> -->

                                        @if($client->isPrimary == 0 && $client->IsShop == 1)

                                        <li><a class="dropdown-item" href="{{ route('web.makeasprimaryaccount', Crypt::encrypt($client->id) )}}"> Make as Primary </a>
                                        </li>

                                        @endif

                                        @if($client->isPrimary == 1)

                                        <li>
                                            <a class="dropdown-item" href="{{ route('web.managesubusers', Crypt::encrypt($client->userid) )}}"> Create Sub Users </a>
                                        </li>

                                        <li>
                                            <a style="background: transparent;" data-max="{{ $client->max_connections }}" data-id="{{$client->userid}}" data-uid="{{ $client->id }}" class="dropdown-item manageMaxConnections" title=""> Manage Max Connections </a>
                                        </li>

                                        @endif

                                        <li><a class="dropdown-item" href="{{ route('web.assignedAppPermissions',[ Crypt::encrypt($client->id) , Crypt::encrypt($client->userid)] )}}">App Permissions</a>
                                        </li>

                                        <li><a class="dropdown-item text-success" href="{{ route('web.resetpasswordtodefault',Crypt::encrypt($client->id))}}">Reset Password to Default</a>
                                        </li>

                                        <li><a class="dropdown-item" href="{{ route('web.viewPrivilageHistory',Crypt::encrypt($client->id))}}">Privilage History</a>
                                        </li>

                                        <li><a data-id="{{ $client->id }}" data-name="{{ $client->Name }}" data-email="{{ $client->UserName }}" data-mobile="{{ $client->Mobile }}" class="dropdown-item UpdateUserDetailsModel">Update User Details</a>
                                        </li>

                                        <li><a class="dropdown-item" href="{{ route('web.enableForceLogout',Crypt::encrypt($client->id))}}">Force Logout</a>
                                        </li>
                                        
                                               <li><a href="{{ route('web.updateassignedshoplist',[ Crypt::encrypt($client->id) , Crypt::encrypt($client->userid)] )}}" class="dropdown-item">Update Assigned Shops</a>
                                        </li>


                                    </ul>
                                </div>
                            </div>

                            @endif




                        </td>
                    </tr>
                    <?php $num++; ?>
                    @endforeach

                </tbody>
            </table>
        </div>
    </div>
</div>

<script>
    $(document).ready(function() {


        $(".clickToView").click(function() {
            $('#modalClientDetails').modal('show');
        });

        $(".UpdateUserDetailsModel").on('click', function() {

            var id = $(this).data("id");
            var Name = $(this).data("name");
            var Email = $(this).data("email");
            var Mobile = $(this).data("mobile");

            document.getElementById("updateID").value = id;
            document.getElementById("updateName").value = Name;
            document.getElementById("updateEmail").value = Email;
            document.getElementById("updateMobile").value = Mobile;

            $('#UpdateUserDetailsModelView').modal('show');

        });

        $(".manageMaxConnections").click(function() {

            var clientid = $(this).data("id");
            var userid = $(this).data("uid");
            var max = $(this).data("max");

            document.getElementById("maxConn").value = max;
            document.getElementById("maxclientid").value = clientid;
            document.getElementById("maxuserid").value = userid;

            $('#modalManageMaxConnection').modal('show');

        });
    });
</script>
@endsection