@extends('Admin.Layouts.master')

@section('content')

<div class="card">
    <div class="card-body">

        @if ($message = Session::get('success'))
        <div class="alert border-0 bg-light-success alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-success"><i class="bi bi-check-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-success">{{ $message }}</div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        @if ($message = Session::get('fail'))
        <div class="alert border-0 bg-light-danger alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-danger"><i class="bi bi-x-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-danger">
                        {{$message}}
                    </div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="ps-3">
                <h6 class="mb-0 text-uppercase">Manage Sub Users</h6>
            </div>
            <div class="ms-auto">
                <div class="btn-group">
                    <a class="btn btn-primary createSubUser"> <i class="fadeIn animated bx bx-image-add"></i> Create User </a>
                </div>
            </div>
        </div>

        <hr />

        <div class="table-responsive mt-3">
            <table class="table align-middle">
                <thead class="table-secondary">
                    <tr>
                        <th>#</th>
                        <th>Name</th>
                        <th>Username</th>
                        <th>Package</th>
                        <th>Status</th>
                        <th>Created Date</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $cnt = 1; ?>
                    @foreach($users as $pack)
                    <tr>
                        <td> {{ $cnt }} </td>
                        <td>{{ $pack->Name }}</td>
                        <td>{{ $pack->UserName }}</td>
                        <td>{{ $pack->Pack_Name }}</td>


                        @if($pack->Active == 1)
                        <td> <label class="text-success"> Active </label> </td>
                        @else
                        <td> <label class="text-danger"> Inactive </label> </td>
                        @endif

                        <td>{{ $pack->Reg_stamp }}</td>

                        <td>
                            <div class="table-actions d-flex align-items-center gap-3 fs-6">

                                <!-- <a href="{{ route('web.updateUserActionStatus', Crypt::encrypt($pack->id) ) }}" class="text-warning" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Edit Action"><i class="bi bi-pencil-fill"></i></a> -->

                                <a href="{{ route('web.updateUserActionStatus', Crypt::encrypt($pack->id) ) }}" class="text-warning" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Update status"><i class="bi bi-pencil-fill"></i></a>

                                <a data-aid="{{ $pack->id }}" data-id="{{ $pack->id }}" value="{{ $pack->id }}" class="text-success showPriceChange" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Change price"> <i class="fadeIn animated bx bx-rupee"></i> </a>

                                <a onclick="return confirm('Are you sure want to delete this action ?')" href="{{ route('web.deletePackageAction', Crypt::encrypt($pack->id) ) }}" class="text-danger" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete"><i class="bi bi-trash-fill"></i></a>

                            </div>
                        </td>
                    </tr>
                    <?php $cnt++; ?>
                    @endforeach


                </tbody>
            </table>
        </div>

    </div>
</div>

<div class="modal fade" id="modalDeleteClientFromDB" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="{{ route('web.createSubUser') }}" method="post">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Create User</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">

                    <div hidden class="col-12">
                        <label class="form-label">Client ID</label>
                        <input value="{{ $clientid }}" required name="clientid" type="text" class="form-control">
                    </div>

                    <div class="col-12">
                        <label class="form-label">Name</label>
                        <input required name="name" type="text" class="form-control">
                    </div>

                    <div class="col-12">
                        <label class="form-label">Username</label>
                        <input required name="username" type="email" class="form-control">
                    </div>
                    
                    <div class="col-12">
                        <label class="form-label">Password</label>
                        <input required name="password" type="password" class="form-control">
                    </div>
                    
                    <div class="col-12">
                        <label class="form-label">Package</label>
                        <input required name="package" type="text" class="form-control">
                    </div>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Create</button>
                </div>
            </form>
        </div>
    </div>
</div>



<script>
    $(".createSubUser").on('click', function(event) {

        $('#modalDeleteClientFromDB').modal('show');


    });
</script>
@endsection