@extends('Admin.Layouts.master')
<?php

use App\Http\Controllers\GeneralController;
use App\Http\Controllers\MainAcontroller;
?>
@section('content')

<div class="card">
    <div class="card-body" id="photo">

        @if($supplier != '')
        <h6 class="mb-0 text-uppercase text-center"><label class="text-danger">{{ $supplier }}</label> </h6>
        @endif

        <h6 class="mb-0 text-uppercase text-center"><label class="text-primary">{{ $clientname[0] }}</label> </h6>

        <p class="text-center"> {{ $location[0] }} , {{ $area[0] }} </p>

        <h6 class="mb-0 text-uppercase text-center">PURCHASE REPORT FROM <?php echo (MainAcontroller::convertDate($from)) ?> TO <?php echo (MainAcontroller::convertDate($to)) ?></h6>
        <hr>


        <div class="row row-cols-1 row-cols-sm-2 row-cols-md-3 row-cols-xl-4 row-cols-xxl-4">

            <div class="col">
                <div class="card radius-10">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="">
                                <p class="mb-1">Total Purchase</p>
                                <h4 class="mb-0 text-info"> Rs. {{ number_format((float) $totalPurchase[0]['total'],2) }} </h4>
                            </div>
                            <div class="ms-auto fs-2 text-info">
                                <i class="fadeIn animated bx bx-store"></i>
                            </div>
                        </div>
                        <!-- <hr class="my-2"> -->
                        <!-- <small class="mb-0"><i class="bi bi-arrow-up"></i> <span></span></small> -->
                    </div>
                </div>
            </div>

        </div>

        <div class="row row-cols-1 row-cols-sm-2 row-cols-md-3 row-cols-xl-4 row-cols-xxl-4">


            <div style="display: none;" class="col">
                <div class="card radius-10 border-0 border-start border-tiffany border-3">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="">
                                <p class="mb-1">Cash</p>
                                <h4 class="mb-0 text-tiffany"> Rs. {{ number_format((float) $cashsale[0]['cashsale'],2) }}</h4>
                            </div>
                            <div class="ms-auto widget-icon bg-tiffany text-white">
                                <i class="fadeIn animated bx bx-money"></i>
                            </div>
                        </div>

                    </div>
                </div>
            </div>



            <div style="display: none;" class="col">
                <div class="card radius-10 border-0 border-start border-success border-3">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="">
                                <p class="mb-1">Credit</p>
                                @if( is_null($creditsale) )
                                <h4 class="mb-0 text-success"> Rs. {{ number_format((float) $creditsale[0]['creditsale'],2) }}</h4>
                                @else
                                <h4 class="mb-0 text-success"> Rs. 0.00</h4>
                                @endif
                            </div>
                            <div class="ms-auto widget-icon bg-success text-white">
                                <i class="fadeIn animated bx bx-book-alt"></i>
                            </div>
                        </div>

                    </div>
                </div>
            </div>

        </div>


        <div class="row row-cols-1 row-cols-sm-2 row-cols-md-3 row-cols-xl-4 row-cols-xxl-4">
            <div class="col">
                <div class="card radius-10">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="">
                                <p class="mb-1">Total</p>
                                <h4 class="mb-0 text-pink"> Rs. {{ number_format((float) $totalPurchase[0]['total'],2) }} </h4>
                            </div>
                            <div class="ms-auto fs-2 text-pink">
                                <i class="fadeIn animated bx bx-repeat"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <div class="col">
                <div class="card radius-10">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="">
                                <p class="mb-1">Adjustment</p>
                                <h4 class="mb-0 text-info"> Rs. {{ number_format((float) $adjustment[0]['adjustment'],2) }} </h4>
                            </div>
                            <div class="ms-auto fs-2 text-info">
                                <i class="fadeIn animated bx bx-book-open"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <div class="col">
                <div class="card radius-10">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="">
                                <p class="mb-1">Net Balance</p>
                                <h4 class="mb-0 text-purple"> Rs. {{ number_format((float) $NetBalance[0]['NetBalance'],2) }} </h4>
                            </div>
                            <div class="ms-auto fs-2 text-purple">
                                <i class="fadeIn animated bx bx-book-open"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>

        @if($supplier == '')
        <a href="{{ route('web.viewPurchaseReportTwo',[$from,$to,$client,$supplier]) }}" style="float: center;" class="btn btn-primary">View Details</a>
        @else
        <a href="{{ route('web.viewPurchaseReportTwo',[$from,$to,$client,$supplier]) }}" style="float: center;" class="btn btn-primary">View Details</a>
        @endif

    </div>
</div>


@endsection