@extends('Admin.Layouts.master')
@section('content')

<div class="card">
    <div class="card-body">

        @if ($message = Session::get('success'))
        <div class="alert border-0 bg-light-success alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-success"><i class="bi bi-check-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-success">{{ $message }}</div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        @if ($message = Session::get('fail'))
        <div class="alert border-0 bg-light-danger alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-danger"><i class="bi bi-x-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-danger">
                        {{$message}}
                    </div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        <h6 class="mb-0 text-uppercase"> {{ $reportName[0] }} FOR {{ $clientName[0] }}</h6>
        <hr />

        <div id="renderTable" class="table-responsive">


            <table data-page-length='20' id="example2"  class="table table-striped table-bordered">
                <thead class="table-secondary">
                    <tr>
                        <th>Sl No</th>
                        <th>ROw Name</th>
                        <th>Row Key</th>
                        <th>Mode</th>
                        <th>Mode Management</th>

                        <!-- <th>Column Permissions</th> -->
                    </tr>
                </thead>

                <tbody>
                    <?php $num = 1; ?>

                    @foreach($rows as $rpt)
                    <tr>
                        <td>{{ $num }}</td>
                        <td> {{ $rpt->row_name }} </td>
                        <td> {{ $rpt->row_key }} </td>

                        <td>

                            <?php echo ($rpt->row_status == 1 ? '<label class="text-success">Enabled</label>' : '<label class="text-danger">Disabled</label>'); ?>
                        </td>

                        <td>
                            @if($rpt->row_status == 0)
                            <form action="{{ route('web.updateRowPermissions') }}" method="post" id="toggleForm">
                                @csrf
                                <div class="form-check form-switch">
                                    <input hidden name="rowid" type="text" value="{{ $rpt->id}}">

                                    <input onchange="this.form.submit()" type="checkbox" data-id="{{ $rpt->id }}" name="status" class="js-switch" {{ $rpt->row_status == 1 ? 'checked' : '' }}>

                                    <label class="form-check-label text-success" for="flexSwitchCheckChecked">ENABLE</label>

                                </div>
                            </form>
                            @else
                            <form action="{{ route('web.updateRowPermissions') }}" method="post" id="toggleForm">
                                @csrf
                                <div class="form-check form-switch">
                                    <input hidden name="rowid" type="text" value="{{ $rpt->id}}">

                                    <input onchange="this.form.submit()" type="checkbox" data-id="{{ $rpt->id }}" name="status" class="js-switch" {{ $rpt->row_status == 1 ? 'checked' : '' }}>

                                    <label class="form-check-label text-danger" for="flexSwitchCheckChecked">DISABLE</label>

                                </div>
                            </form>
                            @endif
                        </td>


         

                    </tr>

                    <?php $num++; ?>

                    @endforeach
                </tbody>
            </table>


        </div>


    </div>
</div>

@endsection