@extends('Admin.Layouts.master')
<meta name="csrf-token" content="{{ csrf_token() }}" />


<title> <?php echo $clientname[0] . "\n" . $area[0] . "," . $location[0] . "\n" . "SALE REPORT FROM " . $from . " to " . $to  ?> </title>
<?php

use App\Http\Controllers\MainAcontroller; ?>
@section('content')

<div class="card">
    <div class="card-body">

        @if ($message = Session::get('success'))
        <div class="alert border-0 bg-light-success alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-success"><i class="bi bi-check-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-success">{{ $message }}</div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        @if ($message = Session::get('fail'))
        <div class="alert border-0 bg-light-danger alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-danger"><i class="bi bi-x-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-danger">
                        {{$message}}
                    </div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        <h6 class="mb-0 text-uppercase text-center text-danger"> {{ $clientname[0] }} </h6>
        <p class="text-center"> {{ $location[0] }} , {{ $area[0]}}</p>
        <p class="text-center">SALE REPORT FROM <?php echo ((MainAcontroller::convertDate($from))) ?> to <?php echo ((MainAcontroller::convertDate($to))) ?></p>
        <hr />


        @if(session('LoggedUser')['userRole'] == "shop")

        <div class="row row-cols-1 row-cols-sm-2 row-cols-md-3 row-cols-xl-4 row-cols-xxl-4 ">

            @if($permissions[0]['s3_isCashVisible'] != 0)
            <div class="col">
                <div class="card radius-10 border-0 border-start border-tiffany border-3">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="">
                                <p class="mb-1">Cash</p>
                                <h4 class="mb-0 text-tiffany">Rs. {{ number_format($cashsale[0]['totalcashsale'],2) }}</h4>
                            </div>
                            <div class="ms-auto widget-icon bg-tiffany text-white">
                                <i class="fadeIn animated bx bx-money"></i>
                            </div>
                        </div>
                        <!-- @if($permissions[0]['s3_isCashClick'] != 0)
                        <hr class="my-2">
                        <a href="{{ route('web.saleviewThreeTypeDetails',[$from,$to,'cash',$client]) }}"><small class="mb-0"><i class="bi bi-arrow-right"></i> <span>View details</span></small></a>
                        @else
                        <hr class="my-2">
                        <a onclick="showWarning()"><small class="mb-0"><i class="bi bi-arrow-right"></i> <span>View details</span></small></a>
                        @endif -->
                    </div>
                </div>
            </div>
            @else
            <div style="opacity: 0.5;" onclick="showWarning()" class="col">
                <div class="card radius-10 border-0 border-start border-tiffany border-3">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="">
                                <p class="mb-1">Cash</p>
                                <h4 class="mb-0 text-tiffany">Rs. ----------</h4>
                            </div>
                            <div class="ms-auto widget-icon bg-tiffany text-white">
                                <i class="fadeIn animated bx bx-money"></i>
                            </div>
                        </div>

                        <hr class="my-2">
                        <a><small class="mb-0"><i class="bi bi-arrow-right"></i> <span>View details</span></small></a>

                    </div>
                </div>
            </div>
            @endif

            @if($permissions[0]['s3_isCreditVisible'] != 0)
            <div class="col">
                <div class="card radius-10 border-0 border-start border-success border-3">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="">
                                <p class="mb-1">Credit</p>
                                <h4 class="mb-0 text-success">Rs. {{ number_format($creditsale[0]['totalcreditsale'],2) }}</h4>
                            </div>
                            <div class="ms-auto widget-icon bg-success text-white">
                                <i class="fadeIn animated bx bx-book-alt"></i>
                            </div>
                        </div>
                        <!-- @if($permissions[0]['s3_isCreditClick'] != 0)
                        <hr class="my-2">
                        <a href="{{ route('web.saleviewThreeTypeDetails',[$from,$to,'credit',$client]) }}"><small class="mb-0"><i class="bi bi-arrow-right"></i> <span>View details</span></small></a>
                        @else
                        <hr class="my-2">
                        <a onclick="showWarning()"><small class="mb-0"><i class="bi bi-arrow-right"></i> <span>View details</span></small></a>
                        @endif -->
                    </div>
                </div>
            </div>
            @else
            <div style="opacity: 0.5;" onclick="showWarning()" class="col">
                <div class="card radius-10 border-0 border-start border-success border-3">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="">
                                <p class="mb-1">Credit</p>
                                <h4 class="mb-0 text-success">Rs. ---------- </h4>
                            </div>
                            <div class="ms-auto widget-icon bg-success text-white">
                                <i class="fadeIn animated bx bx-book-alt"></i>
                            </div>
                        </div>

                        <hr class="my-2">
                        <a><small class="mb-0"><i class="bi bi-arrow-right"></i> <span>View details</span></small></a>

                    </div>
                </div>
            </div>
            @endif

            @if($permissions[0]['s3_isCardVisible'] != 0)
            <div class="col">
                <div class="card radius-10 border-0 border-start border-pink border-3">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="">
                                <p class="mb-1">Card</p>
                                @if($cardsale[0]['amount'] == null )
                                <h4 class="mb-0 text-pink">Rs. 0.00</h4>
                                @else
                                <h4 class="mb-0 text-pink">Rs. {{ number_format($cashsale[0]['totalcashsale'],2) }}</h4>
                                @endif

                            </div>
                            <div class="ms-auto widget-icon bg-pink text-white">
                                <i class="fadeIn animated bx bx-wallet-alt"></i>
                            </div>
                        </div>
                        <!-- @if($permissions[0]['s3_isCardClick'] != 0)
                        <hr class="my-2">
                        <a href="{{ route('web.saleviewThreeTypeDetails',[$from,$to,'card',$client]) }}"><small class="mb-0"><i class="bi bi-arrow-right"></i> <span>View details</span></small></a>
                        @else
                        <hr class="my-2">
                        <a onclick="showWarning()"><small class="mb-0"><i class="bi bi-arrow-right"></i> <span>View details</span></small></a>

                        @endif -->

                    </div>
                </div>
            </div>

            @else
            <div style="opacity: 0.5;" onclick="showWarning()" class="col">
                <div class="card radius-10 border-0 border-start border-pink border-3">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="">
                                <p class="mb-1">Card</p>
                                @if($cardsale[0]['amount'] == null )
                                <h4 class="mb-0 text-pink">Rs. 0.00</h4>
                                @else
                                <h4 class="mb-0 text-pink">Rs. ----------- </h4>
                                @endif
                            </div>
                            <div class="ms-auto widget-icon bg-pink text-white">
                                <i class="fadeIn animated bx bx-wallet-alt"></i>
                            </div>
                        </div>
                        @if($permissions[0]['s3_isCardClick'] != 0)
                        <hr class="my-2">
                        <a><small class="mb-0"><i class="bi bi-arrow-right"></i> <span>View details</span></small></a>
                        @endif
                    </div>
                </div>
            </div>
            @endif


            <div class="col">
                <div>
                    @if($permissions[0]['s3_isBillCount'] != 0)
                    <h6>Total Bill Count : {{ $billCount[0]['billCount'] }}</h6>
                    @else
                    <h6 onclick="showWarning()">Total Bill Count : ---------- </h6>
                    @endif

                    @if($permissions[0]['s3_isStartBill'] != 0)
                    <h6>Start Bill : {{ $startBill[0]['startBill'] }}</h6>
                    @else
                    <h6 onclick="showWarning()">Start Bill : ---------- </h6>
                    @endif

                    @if($permissions[0]['s3_isEndBill'] != 0)
                    <h6>End Bill : {{ $endBill[0]['endBill'] }}</h6>
                    @else
                    <h6 onclick="showWarning()">End Bill : ---------- </h6>
                    @endif
                </div>
            </div>


        </div>

        <div id="" class="table-responsive">

            <table data-page-length='30' id="exampleONE" class="table table-striped table-bordered">
                <thead class="table-secondary">
                    <tr>
                        <th style="text-align: center;">Sl No</th>
                        <th style="text-align: center;">Sale Type</th>
                        <th style="text-align: center;">Bill No</th>
                        <th style="text-align: right;">Amount</th>
                        <th>Action</th>
                    </tr>
                </thead>

                <tbody>
                    <?php $num = 1; ?>

                    @foreach($allsales as $sale)
                    <tr>
                        <td style="text-align: center;">{{ $num }}</td>
                        <td style="text-align: center;"> {{ $sale->flg }} </td>
                        <td style="text-align: center;"> {{ $sale->bill_no }} </td>
                        <td style="text-align: right;"> {{ number_format($sale->amount, 2) }} </td>
                        <td style="text-align: right;"> <a href="https://api.digitronicsindia.com/aswas/public/api/getClosing/<?php echo $sale->bill_no ?>/354" class="btn btn-primary"> Download </a> </td>
                    </tr>

                    <?php $num++; ?>

                    @endforeach
                </tbody>
            </table>


        </div>
        @else




        <div class="row row-cols-1 row-cols-sm-2 row-cols-md-3 row-cols-xl-4 row-cols-xxl-4 ">

            <div class="col">
                <div class="card radius-10 border-0 border-start border-tiffany border-3">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="">
                                <p class="mb-1">Cash</p>
                                <h4 class="mb-0 text-tiffany">Rs. {{ number_format($cashsale[0]['totalcashsale'],2) }}</h4>
                            </div>
                            <div class="ms-auto widget-icon bg-tiffany text-white">
                                <i class="fadeIn animated bx bx-money"></i>
                            </div>
                        </div>
                        <!-- @if($permissions[0]['s3_isCashClick'] != 0)
                        <hr class="my-2">
                        <a href="{{ route('web.saleviewThreeTypeDetails',[$from,$to,'cash',$client]) }}"><small class="mb-0"><i class="bi bi-arrow-right"></i> <span>View details</span></small></a>
                        @endif -->
                    </div>
                </div>
            </div>

            <div class="col">
                <div class="card radius-10 border-0 border-start border-success border-3">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="">
                                <p class="mb-1">Credit</p>
                                <h4 class="mb-0 text-success">Rs. {{ number_format($creditsale[0]['totalcreditsale'],2) }}</h4>
                            </div>
                            <div class="ms-auto widget-icon bg-success text-white">
                                <i class="fadeIn animated bx bx-book-alt"></i>
                            </div>
                        </div>
                        <!-- @if($permissions[0]['s3_isCreditClick'] != 0)
                        <hr class="my-2">
                        <a href="{{ route('web.saleviewThreeTypeDetails',[$from,$to,'credit',$client]) }}"><small class="mb-0"><i class="bi bi-arrow-right"></i> <span>View details</span></small></a> 
                        @endif -->
                    </div>
                </div>
            </div>

            <div class="col">
                <div class="card radius-10 border-0 border-start border-pink border-3">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="">
                                <p class="mb-1">Card</p>
                                @if($cardsale[0]['amount'] == null )
                                <h4 class="mb-0 text-pink">Rs. 0.00</h4>
                                @else
                                <h4 class="mb-0 text-pink">Rs. {{ number_format($cashsale[0]['totalcashsale'],2) }}</h4>
                                @endif

                            </div>
                            <div class="ms-auto widget-icon bg-pink text-white">
                                <i class="fadeIn animated bx bx-wallet-alt"></i>
                            </div>
                        </div>
                        <!-- @if($permissions[0]['s3_isCardClick'] != 0)
                        <hr class="my-2">
                        <a href="{{ route('web.saleviewThreeTypeDetails',[$from,$to,'card',$client]) }}"><small class="mb-0"><i class="bi bi-arrow-right"></i> <span>View details</span></small></a>
                        @endif -->

                    </div>
                </div>
            </div>


            <div class="col">
                <div>
                    <h6>Total Bill Count : {{ $billCount[0]['billCount'] }}</h6>

                    <h6>Start Bill : {{ $startBill[0]['startBill'] }}</h6>

                    <h6>End Bill : {{ $endBill[0]['endBill'] }}</h6>
                </div>
            </div>


        </div>

        <div id="" class="table-responsive">

            <table data-page-length='30' id="exampleONE" class="table table-striped table-bordered">
                <thead class="table-secondary">
                    <tr>
                        <th style="text-align: center;">Sl No</th>
                        <th style="text-align: center;">Sale Type</th>
                        <th style="text-align: center;">Bill No</th>
                        <th style="text-align: right;">Amount</th>
                        <th >Action</th>
                    </tr>
                </thead>

                <tbody>
                    <?php $num = 1; ?>

                    @foreach($allsales as $sale)
                    <tr>
                        <td style="text-align: center;">{{ $num }}</td>
                        <td style="text-align: center;"> {{ $sale->flg }} </td>
                        <td style="text-align: center;"> {{ $sale->bill_no }} </td>
                        <td style="text-align: right;"> {{ number_format($sale->amount, 2) }} </td>
                        <td style="text-align: right;"> <a href="https://api.digitronicsindia.com/aswas/public/api/getClosing/<?php echo $sale->bill_no ?>/354" class="btn btn-primary"> Download </a> </td>
                    </tr>

                    <?php $num++; ?>

                    @endforeach
                </tbody>
            </table>


        </div>

        @endif

    </div>
</div>


<script>
    // let status = 0;
    $(document).ready(function() {

        $('#exampleONE').DataTable({
            dom: 'Bfrtip',

            buttons: [{

                extend: 'pdf',
                customize: function(doc) {

                    doc.styles.message.alignment = "center";

                    doc.content[1].table.widths = ['25%', '25%', '25%', '25%'];

                    var rowCount = doc.content[1].table.body.length;

                    doc.content[1].table.body[0][3].alignment = 'right';

                    for (i = 1; i < rowCount; i++) {

                        doc.content[1].table.body[i][0].alignment = 'center';
                        doc.content[1].table.body[i][1].alignment = 'center';
                        doc.content[1].table.body[i][2].alignment = 'center';
                        doc.content[1].table.body[i][3].alignment = 'right';
                        // doc.content[1].table.body[i][3].alignment = 'right';
                        // doc.content[1].table.body[i][3].text += ' €';
                    };

                }
            }, {
                extend: 'excel',
                text: 'Excel',
                exportOptions: {

                    modifier: {
                        page: 'all'
                    }
                }
            }]
        });
    });
</script>

@endsection