




<?php $__env->startSection('content'); ?>

<div class="card">
    <div class="card-body">

        <?php if($message = Session::get('success')): ?>
        <div class="alert border-0 bg-light-success alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-success"><i class="bi bi-check-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-success"><?php echo e($message); ?></div>
                    <script>
                        hidePleaseWait();
                    </script>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        <?php endif; ?>

        <?php if($message = Session::get('fail')): ?>
        <div class="alert border-0 bg-light-danger alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-danger"><i class="bi bi-x-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-danger">
                        <?php echo e($message); ?>

                    </div>
                    <script>
                        hidePleaseWait();
                    </script>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        <?php endif; ?>

        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">Manage Clients</div>

            <div>
                <select id="filterSelect" class="form-control filterSelect">
                    <option <?php echo e($type == 'A' ? 'selected' : ''); ?> value="A">All</option>
                    <option <?php echo e($type == 'S' ? 'selected' : ''); ?> value="S">Single Users</option>
                    <option <?php echo e($type == 'M' ? 'selected' : ''); ?> value="M">Multi Users</option>
                    <option <?php echo e($type == 'SM' ? 'selected' : ''); ?> value="SM">Single and Multi Users</option>
                </select>
            </div>

            <!-- <div class="ms-auto">
                <div class="col">
                    <div>
                        <button type="button" class="btn btn-primary grantForAll">Grant Privilege For All Clients</button>
                    </div>
                </div>
            </div> -->



        </div>


        <hr />

        <div id="pasteTableHear" class="table-responsive">

            <!-- width="100%" data-page-length='10' id="example2" class="table table-striped table-bordered" -->
            <table id="example" class="display" style="width:100%">
                <thead class="table-secondary">
                    <tr>
                        <th width="5%">SL NO</th>
                        <th width="25%">Client Name</th>
                        <th width="15%">Billing Count</th>
                        <th width="15%">Package Count</th>
                        <!-- <th width="10%"> Privilege </th> -->
                        <th width="10%">Managed Shops & User Count</th>
                        <th width="10%">Privilege Date</th>


                        <th width="5%">Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php

                    use App\Http\Controllers\GeneralController;
                    use App\Http\Controllers\MainAcontroller;

                    $num = 1; ?>
                    <?php $__currentLoopData = $clients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $client): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                    <tr>

                        <td>  </td>

                        <td>
                        <span hidden><?php echo e($client->ClientName); ?></span>    
                        <label class="text-danger"> <?php echo e($client->ClientID); ?> </label> <br> <?php echo e($client->ClientName); ?> <br> <?php echo e($client->Area); ?> <br> <?php echo e($client->Location); ?>

                            <br>
                            <?php if($client->Type == "R"): ?>
                            <label style="color: green;">Retail</label>
                            <?php else: ?>
                            <label style="color: red;">Wholesale</label>
                            <?php endif; ?>

                            <label > <?php echo MainAcontroller::convertDateandTime(GeneralController::getLastUpdatedTime($client->ClientID)) ?> </label>
                        </td>

                        <td> 
                            <?php if($client->YearlyTypeCount > 0): ?>
                            <label class="text-danger"> Yearly Billing : <?php echo e($client->YearlyTypeCount); ?> </label>
                            <?php else: ?>
                            <label > Yearly Billing : <?php echo e($client->YearlyTypeCount); ?> </label>
                            <?php endif; ?>

                            <br> 

                            <?php if($client->MonthlyTypeCount > 0): ?>
                            <label class="text-danger"> Monthly Billing : <?php echo e($client->MonthlyTypeCount); ?> </label>
                            <?php else: ?>
                            <label > Monthly Billing : <?php echo e($client->MonthlyTypeCount); ?> </label>
                            <?php endif; ?>
                        </td>
                        
                         <td>
                            <?php if($client->platinumcnt != 0): ?>
                            <label>Platinum Users : <?php echo e($client->platinumcnt); ?></label>
                            <?php endif; ?>

                            <?php if($client->goldcnt != 0): ?>
                            <label>Gold Users : <?php echo e($client->goldcnt); ?></label>
                            <?php endif; ?>

                            <?php if($client->silvercnt != 0): ?>
                            <label>Silver Users : <?php echo e($client->silvercnt); ?></label>
                            <?php endif; ?>
                        </td>

                        <td>
                            <select class="form-control">
                                <?php $__currentLoopData = GeneralController::managedShopListByclientID($client->ClientID); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($value->Managed_ClientID); ?>"> <?php echo e($value->Managed_ClientID); ?> : <?php echo e($value->ClientName); ?> - <?php echo e($value->Area); ?> - <?php echo e($value->Location); ?> </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <br>

                            <?php if($client->is_MultiUser == 1): ?>
                            <a href="<?php echo e(route('web.manageAssignedShopList', Crypt::encrypt($client->ClientID) )); ?>"> <span> Assigned Shop Count : <?php echo GeneralController::managedShopListCountByclientID($client->ClientID) ?> </span> </a>
                            <?php endif; ?>

                            <?php if($client->is_SingleUser == 1): ?>
                            <a href="<?php echo e(route('web.manageUsersByClient', Crypt::encrypt($client->ClientID) )); ?>"> <span> Users Count : <?php echo GeneralController::shopCountByShopID($client->ClientID) ?> </span> </a>
                            <?php endif; ?>

                            <br>

                            <!-- <span class="badge bg-success"> Admin : <?php echo GeneralController::adminCountByShopID($client->ClientID) ?></span> -->
                            <!-- <a href="<?php echo e(route('web.manageUsersByClient', Crypt::encrypt($client->ClientID) )); ?>"> <span class="badge bg-warning"> User : <?php echo GeneralController::shopCountByShopID($client->ClientID) ?></span> </a> -->
                            <a href="<?php echo e(route('web.manageCustomerUsersByClient', Crypt::encrypt($client->ClientID) )); ?>"> <span> Customer App : <?php echo GeneralController::userCountByShopID($client->ClientID) ?></span> </a>
                            <br>
                        </td>



                        <?php
                        if ( $client->enddt == '') {

                        ?> <td> User not allowed </td> <?php
                                            } 
                                            else if($client->enddt == '1900-01-01')
                                            {
                                                ?> <td class="text-danger"> 01-01-1900 </td> <?php
                                            }
                                            else {


                                                if( GeneralController::daysleftDateOnly( $client->enddt ) > 10 )
                                                {
                                                    ?>
                                                    <td>
                                                        
                                <a hidden><?php echo  MainAcontroller::convertDateYYMMDD($client->enddt)  ?></a>
                                <span class="text-success">
                                    <?php echo  MainAcontroller::convertDate($client->enddt)  ?>
                                </span>
                            </td>
                                                    <?php
                                                }
                                                else
                                                {
                                                    ?>
                                                    <td>
                                <a hidden><?php echo  MainAcontroller::convertDateYYMMDD($client->enddt)  ?></a>
                                <span class="text-danger">
                                    <?php echo  MainAcontroller::convertDate($client->enddt)  ?>
                                </span>
                            </td>
                                                    <?php
                                                }


                                                ?>
                            
                        <?php
                                            }
                        ?>



                        <td>


                            <div class="col">
                                <div class="dropdown">
                                    <button class="btn btn-primary dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">Actions</button>
                                    <ul class="dropdown-menu">
                                        <li>
                                            <a href="<?php echo e(route('web.clientDetails',Crypt::encrypt($client->ClientID))); ?>" class="dropdown-item" data-bs-toggle="tooltip" data-bs-placement="bottom" title="view details"><i class="bi bi-eye-fill"></i> View Details </a>
                                        </li>

                                        <li>
                                            <a href="<?php echo e(route('web.managePermissions',Crypt::encrypt($client->ClientID))); ?>" style="background: transparent;" type="submit" class="dropdown-item" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Manage Permissions"><i class="bi bi-pencil-fill"></i> Manage Permissions</a>
                                        </li>

                                        <li>
                                            <a style="background: transparent;" class="dropdown-item deleteClient" data-id="<?php echo e($client->ClientID); ?>" title="Delete"> <i class="fadeIn animated bx bx-trash"></i> Delete Client </a>
                                        </li>

                                        <li>
                                            <a style="background: transparent;" data-id="<?php echo e($client->ClientID); ?>" class="dropdown-item deleteClientDatabase" title="Delete From Database"> <i class="fadeIn animated bx bx-trash"></i> Delete Client From DB</a>
                                        </li>

                                        <?php if($client->pay_qr_status == 1): ?>
                                        <li>
                                            <a href="<?php echo e(route('web.updateQRUploadStatus',Crypt::encrypt($client->ClientID))); ?>" class="dropdown-item" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Change QR Update Status"><i class="fadeIn animated bx bx-upload"></i> Update QR Upload Status</a>
                                        </li>
                                        <?php endif; ?>

                                        <!-- <li>
                                            <a style="background: transparent;" data-id="<?php echo e($client->ClientID); ?>" class="dropdown-item manageMaxConnections" title="Delete From Database"> <i class="fadeIn animated bx bx-trash"></i> Delete Client From DB</a>
                                        </li> -->

                                    </ul>
                                </div>
                            </div>


                        </td>
                    </tr>

                    <?php $num++; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </tbody>
            </table><!--  -->


        </div>




    </div>
</div>

<!-- grant for all model  -->
<div class="modal fade" id="grantForAllModel" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Grant Privilege For All Clients</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form method="POST" action="<?php echo e(route('web.grantPrivilegeForAll')); ?>">
                <?php echo csrf_field(); ?>
                <div class="modal-body">

                    <div class="col-12">
                        <label class="form-label">From Date</label>
                        <input id="dateFrom" required name="from" type="date" class="form-control">
                    </div>

                    <div class="col-12">
                        <label class="form-label">To Date</label>
                        <input id="dateFrom" required name="to" type="date" class="form-control">
                    </div>

                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Save</button>
                </div>

            </form>
        </div>
    </div>
</div>
<!-- grant for all model close -->

<script>
    function showPleaseWait() {
        if (document.querySelector("#pleaseWaitDialog") == null) {
            var modalLoading = '<div class="modal" id="pleaseWaitDialog" data-backdrop="static" data-keyboard="false" role="dialog">\
            <div class="modal-dialog">\
                <div class="modal-content">\
                    <div class="modal-header">\
                        <h4 class="modal-title">Please wait data is processing...</h4>\
                    </div>\
                    <div class="modal-body">\
                        <div class="progress">\
                          <div class="progress-bar progress-bar-success progress-bar-striped active" role="progressbar"\
                          aria-valuenow="100" aria-valuemin="0" aria-valuemax="100" style="width:100%; height: 40px">\
                          </div>\
                        </div>\
                    </div>\
                </div>\
            </div>\
        </div>';
            $(document.body).append(modalLoading);
        }

        $("#pleaseWaitDialog").modal("show");
    }

    function hidePleaseWait() {
        $("#pleaseWaitDialog").modal("hide");
    }


    $(document).ready(function() {

      


        // showPleaseWait();
        // const box = document.getElementById('pasteTableHear');

        // var e = document.getElementById("filterSelect");
        // var strUser = e.options[e.selectedIndex].value;

        // $.ajax({
        //     type: 'GET',
        //     url: "https://api.digitronicsindia.com/aswas/public/manageClientsAjax/" + strUser,

        //     success: function(data) {

        //         // alert(data);
        //         box.innerHTML = '';
        //         box.innerHTML = data;
        //         hidePleaseWait();

        //     }
        // });


        $(".grantForAll").click(function() {
            $('#grantForAllModel').modal('show');

        });

        $(".clickToView").click(function() {
            $('#modalClientDetails').modal('show');

        });

        $(".deleteClient").click(function() {

            var id = $(this).data('id');

            document.getElementById("deleteClientID").value = id;

            $('#modalDeleteClient').modal('show');

        });

        $(".deleteClientDatabase").click(function() {

            var id = $(this).data('id');
            document.getElementById("DBdeleteClientID").value = id;
            $('#modalDeleteClientFromDB').modal('show');

        });

        $('.filterSelect').on('change', function() {
            // const box = document.getElementById('pasteTableHear');

            // showPleaseWait();

            // $.ajax({
            //     type: 'GET',
            //     url: "https://api.digitronicsindia.com/aswas/public/manageClientsAjax/" + this.value,

            //     success: function(data) {

            //         hidePleaseWait();
            //         box.innerHTML = '';
            //         box.innerHTML = data;

            //     }
            // });

            window.location.href = "https://api.digitronicsindia.com/aswas/public/manageClientsNew/" + this.value;




        });


    });
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('Admin.Layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/digitronicsindia/public_html/aswas/resources/views/Admin/manageclients.blade.php ENDPATH**/ ?>