<!DOCTYPE html>
<html>

<head>
    <style>
        .table {
            font-family: arial, sans-serif;
            border-collapse: collapse;
            width: 100%;
            font-size: 8px;
        }

        .nobdtable {
            font-family: arial, sans-serif;
            border-collapse: collapse;
            width: 100%;
            font-size: 8px;
        }

        .td,
        .th {
            border: .5px solid black;
            text-align: left;
            padding: 8px;
            font-size: 8px;
        }

        .notd {
            border-top: .5px solid white;
            border-bottom: .5px solid black;
            text-align: left;
            padding: 8px;
            font-size: 8px;
        }

        .box {
            overflow-y: auto;
            height: 800px;
        }

        #watermark {
            position: fixed;
            bottom: 9px;
            right: 9px;
            opacity: 0.4;
            color: black;
            background-color: rgba(131, 50, 185, 0.5);
            height: 40px;
            width: 100px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        #myid {
            background-color: azure;
            height: 125px;
        }

        .alignleft {
            float: left;
            font-size: 8px;
        }

        .alignright {
            float: right;
        }

        .alncenter {
            text-align: center;
        }

        .alnleft {
            text-align: right;
        }

        .alnright {
            text-align: right;
        }

        /* .table td {
            font-size: .8em;
        }

        .table th {
            font-size: .8em;
        } */



        /* label { 
            font-size: .8em
        }  */
    </style>
</head>

<body>


    <?php

    use App\Http\Controllers\MainAcontroller;
    use App\Http\Controllers\ProductController; ?>
    <div class="card">
        <div class="card-body">
            <div class="table-responsive box">






                <?php


                $shopdet = MainAcontroller::getShopNameByClientID($clientid);
                $shopArea = MainAcontroller::getShopAreaLocationByClientID($clientid);

                ?>

                <?php if($demo == 1 ): ?>
                <h3 style="text-align: center;"> DEMO </h3>
                <p style="text-align: center;"> AREA , LOCATION </p>
                <?php else: ?>
                <center><span class="alncenter"> <?php echo strtoupper($shopdet) ?> </span></center>
                
                <center><span style="text-align: center;"> <?php echo strtoupper($shopArea) ?> </span></center>
                <?php endif; ?>

                <br>
                
                <?php if($type == 1): ?>
                <center><span style="text-align: center;"> EXPIRY REPORT - <span style="color: red;"> <?php if($suppliername != 0 ): ?> <?php echo e($suppliername); ?> <?php else: ?> <?php endif; ?> </span> upto <?php echo MainAcontroller::convertDatetoExpiry($to) ?> </span></center>
                <?php elseif($type == 2): ?>
                <center> <span style="text-align: center;"> EXPIRY REPORT - <span style="color: red;"> <?php if($suppliername != 0 ): ?> <?php echo e($suppliername); ?> <?php else: ?> <?php endif; ?> </span> upto <?php echo MainAcontroller::convertDatetoExpiry($to) ?> </span>
                </center> <?php elseif($type == 3): ?>
                <center> <span style="text-align: center;"> EXPIRY REPORT - All Suppliers upto <?php echo MainAcontroller::convertDatetoExpiry($to) ?></span>
                </center> <?php elseif($type == 4): ?>
                <center> <span style="text-align: center;"> EXPIRY REPORT - All Suppliers upto <?php echo MainAcontroller::convertDatetoExpiry($to) ?> </span>
                </center> <?php endif; ?>

               

                <center> <span class="alncenter">Report generated on : <?php echo date('d-m-Y'); ?></span></center>

                <hr>
                <?php
                $count = 1;

                $totalCost = ProductController::getExpiredProductsSUMByClientID($suppliername, $from, $to, $clientid);


                ?>

                <?php $__currentLoopData = $supplier; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sup): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                <p style="color: red;" class="alignleft"> <?php echo e($count); ?> . <?php echo e($sup->supplier_name); ?> - ( <?php echo e($sup->cnt); ?> Nos )</p>
                <!-- <p class="alignright">P Amount : <?php echo e($sup->TotPAmnt); ?> , S Amount : <?php echo e($sup->TotSAmnt); ?> </p> -->
                <br>

                <!-- <h3 > </h3> -->


                <?php

                $num = 1;
                $productList = ProductController::getExpiredProductsBySupplierwithDate($sup->supplier_name, $from, $to, $clientid); ?>

                <table class="table">
                    <tr>
                        <td class="td" width="5%">SL</td>
                        <td class="td" width="35%">Product Name</td>
                        <td class="td" width="10%">Company</td>
                        <td class="td" width="10%">Batch</td>
                        <td class="td" width="10%">Exp. Dt.</td>
                        <td class="td" width="10%">Pack</td>
                        <td class="td" width="10%">MRP</td>
                        <td class="td" width="10%">Qty</td>
                        <td class="td" width="10%">P. Value</td>
                        <td class="td" width="10%">MRP Value</td>
                    </tr>
                    <?php $__currentLoopData = $productList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $client): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td class="td"><?php echo e($num); ?></td>

                        <td class="td" align="left"><?php echo e($client->product_name); ?> </td>

                        <td class="td" align="left"><?php echo e($client->company_name); ?></td>

                        <td class="td" align="center"><?php echo e($client->batch); ?></td>
                        <td class="td" align="center"> <?php echo MainAcontroller::convertDatetoExpiry($client->expiry) ?> </td>

                        <td class="td" align="center"><?php echo e($client->pack); ?></td>
                        <td class="td" align="center"> <?php echo number_format((float)$client->MRPPack, 2, '.', '') ?> </td>

                        <td class="td" align="center"><?php echo e($client->stkqty); ?></td>
                        <!-- <td class="alnright"> <?php echo e($client->PAmt); ?> </td> -->
                        <td class="alnright td"> <?php echo number_format((float)$client->PAmt, 2, '.', '') ?> </td>
                        <td class="alnright td"> <?php echo number_format((float)$client->MRPAmt, 2, '.', '') ?> </td>
                        <!-- <td class="alnright"> <?php echo e($client->SAmt); ?> </td> -->
                    </tr>

                    <?php $num++; ?>

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <tr>

                        <td colspan="8" class="alnleft td"> <strong>Total</strong> </td>
                        <td colspan="" class="alnright td"> <strong> <?php echo number_format((float)$sup->TotPAmnt, 2, '.', '') ?> </strong> </td>
                        <td colspan="" class="alnright td"> <strong> <?php echo number_format((float)$sup->TotMRPAmnt, 2, '.', '') ?> </strong> </td>
                    </tr>
                </table>

                <?php $count++; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                <table class="nobdtable">
                    <tr>
                        <td class="notd" width="5%"></td>
                        <td class="notd" width="35%"></td>
                        <td class="notd" width="10%"></td>
                        <td class="notd" width="10%"></td>
                        <td class="notd" width="10%"></td>
                        <td class="notd" width="10%"></td>
                        <td class="notd" width="10%"></td>
                        <td class="notd" width="10%"></td>
                        <td class="notd" width="10%"></td>
                        <td class="notd" width="10%"></td>
                    </tr>
                    
                    <?php $__currentLoopData = $totalCost; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tot): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td colspan="8" class="alnleft td"> Total Purchase Amount and MRP Amount </td>
                        <td class="alnright td"> <strong> <?php echo number_format((float)$tot->pCost, 2, '.', '') ?> </strong> </td>
                        <td class="alnright td"> <strong> <?php echo number_format((float)$tot->MRPCost, 2, '.', '') ?> </strong> </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </table>






            </div>
        </div>
    </div>

    <footer>
        <label style="text-align: center;">Powered by <span style="color:#295aa6">MEDISOFT</span> &#169; 2023</label>
    </footer>

</body>

</html><?php /**PATH /home/digitronicsindia/public_html/aswas/resources/views/Admin/ViewExpiryReport.blade.php ENDPATH**/ ?>