<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class BillRenderController extends Controller
{


    public static function formatAmount($amount)
    {
        return number_format($amount, 2);
    }


    public static function discountPercentage($mrp, $salerate)
    {
        $discount = (($mrp - $salerate) * 100) / $mrp;

        return number_format($discount, 0);
    }

    public static function sgstAmount($tax1, $tax2, $total)
    {
        if ($tax1 == 0) {
            return 0;
        } else {

            $taxable = number_format(BillRenderController::taxableAmountOne($total,$tax1,$tax2),2);

            // $sgst = ($total - $taxable) / 2 ;
            $sgst = number_format(( $taxable * $tax1 ) / 100,3);

            // $sgstAmount =  (($total - ( ($total * 100) /  (100 + $tax) )) / 2) /2   ;

            return number_format($sgst, 2);
        }
    }

    public static function cgstAmount($tax1, $tax2, $total)
    {
        if ($tax1 == 0) {
            return 0;
        } else {
            $taxable = number_format(BillRenderController::taxableAmountOne($total,$tax1,$tax2),2);

            // $cgst = ($total - $taxable) / 2 ;
            $cgst = number_format(( $taxable * $tax1 ) / 100,3);

            // $sgstAmount =  (($total - ( ($total * 100) /  (100 + $tax) )) / 2) /2   ;

            return number_format($cgst, 2);
        }
    }

    public static function igstAmount($tax, $salerate)
    {
        if ($tax == 0) {
            return 0;
        } else {
            $igstAmount =  ($salerate * 100) / (100 + $tax);

            return number_format($igstAmount, 2);
        }
    }

    public static function savedAmount($mrpTotal, $grandTotal)
    {
        $savedAmount =  $mrpTotal - $grandTotal;

        return number_format($savedAmount, 2);
    }

    // public static function taxableAmount($mrp, $qty, $tax1, $tax2)
    // {
    //     $taxableAmount =  ($mrp * $qty * 100) / (100 + $tax1 + $tax2);

    //     return number_format($taxableAmount, 2);
    // }

    public static function taxableAmountOne($amount, $tax1, $tax2)
    {
        // $taxableAmount =  ($rate * $qty * 100) / (100 + $tax1 + $tax2);
        $taxableAmount =  (($amount * 100) / (100 + $tax1 + $tax2)) ;

        return number_format($taxableAmount, 2);
    }
}
