<?php

namespace App\Http\Controllers;

use App\Models\ActivityPermission;
use App\Models\Clients;
use App\Models\User;
use App\Models\Users;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\DB;

class PermissionMethodController extends Controller
{

    public static function sale1CashIsVisible($id)
    {
        $per = ActivityPermission::where('client_id', '=', $id)
            ->where('slug_url', '=', 'SALERPT')
            ->where('user_id', '=', session('LoggedUser')['id'])
            ->get();
        return $per[0];
    }

    function assignUserPermission($Uid, $Cid)
    {

        $package = Users::where('id', '=', Crypt::decrypt($Uid))
            ->where('userid', '=', Crypt::decrypt($Cid))
            ->pluck('Package_ID')
            ->first();



        $data = [
            'username' => Users::where('id', '=', Crypt::decrypt($Uid))->pluck('Name')->first(),
            'ClientName' => Clients::where('ClientID', '=', Crypt::decrypt($Cid))->pluck('ClientName')->first(),
            'Area' => Clients::where('ClientID', '=', Crypt::decrypt($Cid))->pluck('Area')->first(),
            'Location' => Clients::where('ClientID', '=', Crypt::decrypt($Cid))->pluck('Location')->first(),

            'assigned' => DB::select(" SELECT 
            tbl_userpermissions.id as pid,
            tbl_permissionActions.act_slug, 
            tbl_permissionActions.act_desc as action,
            tbl_userpermissions.status as status,
            tbl_userpermissions.per_from as fromdate,
            tbl_userpermissions.per_to as todate
            
            from tbl_userpermissions
            
            JOIN tbl_permissionActions on tbl_userpermissions.userper_slug = tbl_permissionActions.act_slug
            where tbl_userpermissions.Package_ID = 1 and tbl_userpermissions.Client_ID = '354' and tbl_userpermissions.User_ID = 3 ")


        ];

        // return $data;
        return view('Admin.assignPermissionForUser', $data);
    }
}
