@extends('Admin.Layouts.master')

@section('content')
<div class="card">
    <div class="card-body">

        @if ($message = Session::get('success'))
        <div class="alert border-0 bg-light-success alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-success"><i class="bi bi-check-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-success">{{ $message }}</div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        @if ($message = Session::get('fail'))
        <div class="alert border-0 bg-light-danger alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-danger"><i class="bi bi-x-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-danger">
                        {{$message}}
                    </div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        <div class="border p-4 rounded">
            <div class="card-title d-flex align-items-center">
                <h5 class="mb-0">Create Package</h5>
            </div>
            <hr />

            <form method="post" action="{{ route('managePackages.store') }}" enctype="multipart/form-data">
                @csrf

                <div class="row mb-3">
                    <label for="inputEnterYourName" class="col-sm-3 col-form-label">Package Name</label>
                    <div class="col-sm-9">
                        <input name="Pack_Name" type="text"  class="form-control" id="inputEnterYourName" value="{{ old('Pack_Name') }}">

                        <span class="text-danger"> @error('Pack_Name') {{ $message }}  @enderror  </span>
                    </div>
                </div>

                <div class="row mb-3">
                    <label for="inputEnterYourName" class="col-sm-3 col-form-label">Package Slug</label>
                    <div class="col-sm-9">
                        <input name="Pack_Slug" type="text"  class="form-control" id="inputEnterYourName" value="{{ old('Pack_Slug') }}">

                        <span class="text-danger"> @error('Pack_Slug') {{ $message }}  @enderror  </span>

                    </div>
                </div>

                <div class="row mb-3">
                    <label for="inputPhoneNo2" class="col-sm-3 col-form-label">Package Status </label>
                    <div class="col-sm-9">
                        <select name="Pack_Status" type="text" class="form-control" id="inputPhoneNo2" placeholder="">
                            <option value=""> Choose one </option>
                            <option value="1"> Active </option>
                            <option value="0"> Inactive </option>
                        </select>

                        <span class="text-danger"> @error('Pack_Status') {{ $message }}  @enderror  </span>

                    </div>
                </div>

                
                <div class="row">
                    <label class="col-sm-3 col-form-label"></label>
                    <div class="col-sm-9">
                        <button type="submit" class="btn btn-primary px-5">Create</button>
                    </div>
                </div>


            </form>

        </div>





    </div>
</div>

@endsection