@extends('Admin.Layouts.master')

@section('content')

<div class="card">
    <div class="card-body">

        @if ($message = Session::get('success'))
        <div class="alert border-0 bg-light-success alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-success"><i class="bi bi-check-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-success">{{ $message }}</div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        @if ($message = Session::get('fail'))
        <div class="alert border-0 bg-light-danger alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-danger"><i class="bi bi-x-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-danger">
                        {{$message}}
                    </div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        <h6 class="mb-0 text-uppercase">Customer App Users</h6>
        <hr />

        <div class="table-responsive">
        <!-- data-page-length='10' id="example2" class="table table-striped table-bordered" -->
            <table id="example" class="display" style="width:100%"  >
                <thead class="table-secondary">
                    <tr>
                        <th>Sl No</th>
                        <th>Name</th>
                        <th>Username</th>
                        <th>Shop</th>
                        <!--<th>Package Status</th>-->
                        <th>Account Type</th>
                        <th>App Status</th>
                        <!--<th>Web Status</th>-->

                    </tr>
                </thead>
                <tbody>
                    <?php $num = 1; ?>
                    @foreach($users as $client)
                    <tr>
                        <td>{{ $num }}</td>

                        <td>{{ $client->Name }} </td>
                        <td>{{ $client->UserName }}</td>

                        <td>{{ $client->ClientName }} <p> {{ $client->Area }} </p>  <p> {{ $client->Location }}</p></td>

                        <!-- <td>{{ $client->Mobile }}</td> -->

                       


                        <td> <label style="color: green;">USER</label> </td>
                        

                        @if($client->Active == 1)
                        <td> <label style="color: green;">Active</label> </td>
                        @else
                        <td> <label style="color: red;">Inactive</label> </td>
                        @endif

                        

                        
                    </tr>
                    <?php $num++; ?>
                    @endforeach

                </tbody>
            </table>
        </div>
    </div>
</div>

<script>
    $(document).ready(function() {
        $(".clickToView").click(function() {


            $('#modalClientDetails').modal('show');

        });
    });
</script>
@endsection