@extends('Admin.Layouts.master')

<meta name="csrf-token" content="{{ csrf_token() }}" />

@section('content')

<div class="card">
    <div class="card-body">

        @if ($message = Session::get('success'))
        <div class="alert border-0 bg-light-success alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-success"><i class="bi bi-check-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-success">{{ $message }}</div>
                    <script>
                        hidePleaseWait();
                    </script>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        @if ($message = Session::get('fail'))
        <div class="alert border-0 bg-light-danger alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-danger"><i class="bi bi-x-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-danger">
                        {{$message}}
                    </div>
                    <script>
                        hidePleaseWait();
                    </script>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">Delete History</div>
        </div>


        <hr />
        <div class="table-responsive">
        <!-- width="100%" data-page-length='10' id="example2" class="table table-striped table-bordered" -->
            <table id="example" class="display" style="width:100%"  >
                <thead class="table-secondary">
                    <tr>
                        <th>Sl No</th>
                        <th>Client Name / ID </th>
                        <th> Address </th>
                        <th>Reason</th>
                        <th>Done By </th>
                        <th>Deleted Date</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $num = 1; ?>

                    @foreach($report as $client)
                    <tr>
                        <td>{{ $num }}</td>

                        <td> {{ $client->del_name }} / <label class="text-danger">  {{ $client->del_client }} </label> </td>
                        <td>{{ $client->del_address }}</td>
                        <td>{{ $client->del_reason }}</td>
                        <td>{{ $client->Name }}</td>
                        <td>{{ $client->del_date }}</td>

                    </tr>
                    <?php $num++; ?>
                    @endforeach

                </tbody>
            </table>
        </div>
    </div>
</div>


@endsection