@extends('Admin.Layouts.master')

@section('content')

<?php

use App\Http\Controllers\MainAcontroller; ?>

<div class="card">
    <div class="card-body">

        @if ($message = Session::get('success'))
        <div class="alert border-0 bg-light-success alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-success"><i class="bi bi-check-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-success">{{ $message }}</div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        @if ($message = Session::get('fail'))
        <div class="alert border-0 bg-light-danger alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-danger"><i class="bi bi-x-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-danger">
                        {{$message}}
                    </div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        <h6 class="mb-0 text-uppercase text-center"> {{ $data['clientname'][0] }} <br>
            {{ $data['area'][0] }} , {{ $data['location'][0] }} <br> Bill NO : {{ $data['billno'] }}
        </h6>
        <hr />


        <!-- accortion test -->
        <div class="row col-12">

            <div class="col-3">
                <h6>sl no</h6>
            </div>

            <div class="col-3">
                <h6> Bill NO </h6>
            </div>

            <div class="col-3">
                <h6>Edit By</h6>
            </div>

            <div class="col-3">
                <h6>Edit Date </h6>
            </div>

        </div>


        <div class="accordion" id="accordionExample">


            <?php echo $content; ?>


        </div>

        <br>
        <br>

        <hr/>
        <h6 class="mb-0 text-uppercase text-center"> Current sale Total : 
        
            @foreach($finalsaleTotal as $toatl)
            {{ $toatl->sumAmnt }}
            @endforeach
            
        </h6>

        <h6 class="mb-0 text-uppercase text-center"> Billed By : 
        
        @foreach($billed_by as $toatl)
        {{ $toatl->LoginID }}
        @endforeach
        
    </h6>

        

        <hr/>


        <table id="" class="table table-striped table-bordered" style="width:100%">
            <thead>
                <tr>
                    <th>Sl No</th>
                    <th>Item</th>
                    <th>Batch</th>
                    <th>Quantity</th>
                    <th>Rate</th>
                    <th>Amount</th>
                </tr>
            </thead>
            <tbody>
                <?php $seq = 1; ?>
                @foreach($finalsale as $fin)
                <tr>
                    <td>{{ $seq }}</td>
                    <td>{{ $fin->item_description }}</td>
                    <td>{{ $fin->batch }}</td>
                    <td>{{ $fin->quantity }}</td>
                    <td>{{ $fin->rate }}</td>
                    <td>{{ $fin->amount }}</td>

                </tr>
                <?php $seq++; ?>
                @endforeach
            </tbody>
        </table>


        <!-- accortion test close -->


    </div>
</div>

<script>
    $(document).ready(function() {




        $.ajax({
            type: "get",
            url: "editReportsaleDetailAjax/50/36531",

            success: function(data) {

                alert("data");
                // $('#accordionExample').html(data);
            }

        });


    });
</script>

@endsection