@extends('Admin.Layouts.master')

@section('content')

<div class="card">
    <div class="card-body">

        @if ($message = Session::get('success'))
        <div class="alert border-0 bg-light-success alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-success"><i class="bi bi-check-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-success">{{ $message }}</div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        @if ($message = Session::get('fail'))
        <div class="alert border-0 bg-light-danger alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-danger"><i class="bi bi-x-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-danger">
                        {{$message}}
                    </div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif



        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="ps-3">
                <h6 class="mb-0 text-uppercase">Manage Packages</h6>
            </div>
        </div>

        <div class="col-12 row">

            <form method="post" action="{{ route('web.addUserAction') }}">
                @csrf

                <div class="col-12 row">

                    <div class="col-2">
                        <select name="actp_id" required type="text" class="form-control">
                            <option value="{{ $packageid }}"> {{ $package }} </option>
                        </select>
                    </div>

                    <div class="col-3">
                        <input name="act_des" required placeholder="action description" type="text" class="form-control">
                    </div>

                    <div class="col-1">
                        <input name="slug_url" required placeholder="slug url" type="text" class="form-control">
                    </div>

                    <div class="col-2">
                        <select name="status" required type="text" class="form-control">
                            <option value=""> Choose one </option>
                            <option value="1"> Active </option>
                            <option value="0"> Inactive </option>
                        </select>
                    </div>

                    <div class="col-1">
                        <input name="act_amount" required placeholder="action payment" type="number" class="form-control">
                    </div>

                    <div class="col-3">
                        <button type="submit" class="btn btn-primary"> Create </button>
                    </div>

                </div>

            </form>

        </div>


        <hr />

        <div class="table-responsive mt-3">
            <table class="table align-middle">
                <thead class="table-secondary">
                    <tr>
                        <th>#</th>
                        <th>Package Name</th>
                        <th>Action Description</th>
                        <th>Slug URL</th>
                        <th>Status</th>
                        <th>Payment</th>
                        <th>Created Date</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $cnt = 1; ?>
                    @foreach($userActions as $pack)
                    <tr>
                        <td> {{ $cnt }} </td>
                        <td>{{ $pack->Pack_Name }}</td>
                        <td>{{ $pack->act_desc }}</td>
                        <td>{{ $pack->act_slug }}</td>


                        @if($pack->act_status == 1)
                        <td> <label class="text-success"> Active </label> </td>
                        @else
                        <td> <label class="text-danger"> Inactive </label> </td>
                        @endif

                        <td>{{ $pack->act_payment }}</td>
                        <td>{{ $pack->act_created }}</td>

                        <td>
                            <div class="table-actions d-flex align-items-center gap-3 fs-6">

                                <!-- <a href="{{ route('web.updateUserActionStatus', Crypt::encrypt($pack->id) ) }}" class="text-warning" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Edit Action"><i class="bi bi-pencil-fill"></i></a> -->

                                <a href="{{ route('web.updateUserActionStatus', Crypt::encrypt($pack->id) ) }}" class="text-warning" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Update status"><i class="bi bi-pencil-fill"></i></a>

                                <a data-aid="{{ $pack->id }}" data-id="{{ $pack->act_payment }}" value="{{ $pack->ack_payment }}" class="text-success showPriceChange" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Change price"> <i class="fadeIn animated bx bx-rupee"></i> </a>

                                <a onclick="return confirm('Are you sure want to delete this action ?')" href="{{ route('web.deletePackageAction', Crypt::encrypt($pack->id) ) }}" class="text-danger" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete"><i class="bi bi-trash-fill"></i></a>

                            </div>
                        </td>
                    </tr>
                    <?php $cnt++; ?>
                    @endforeach


                </tbody>
            </table>
        </div>

    </div>
</div>


<div class="modal fade" id="modalChangePrice" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"> Change Price </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form method="post" action="{{ route('web.updateActionPrice')}}" class="row g-3">
                @csrf
                <div class="modal-body">
                    <label class="form-label">Price</label>
                    <input hidden required name="actid" id="actid" class="form-control mb-3" aria-label="Default select example">
                    <input type="number" pattern="[0-9]" required name="price" id="price" class="form-control mb-3" aria-label="Default select example">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Update</button>

                </div>
            </form>
        </div>
    </div>
</div>


<script>

    $(document).ready(function() {

        $(".showImageLarge").click(function() {

            var id = $(this).data('path');
            document.getElementById("bannerLargeImage").src = id;
            $('#exampleLargeBanner').modal('show');

        });

        $(".showPriceChange").click(function() {

        
            var myBookId = $(this).attr('data-id');
            var aID = $(this).attr('data-aid');

            // alert(myBookId);
            document.getElementById("actid").value = aID;
            document.getElementById("price").value = myBookId;
            $('#modalChangePrice').modal('show');

        });

    });
</script>
@endsection