<!-- viewCustomerAppUsers.blade.php -->

@extends('Admin.Layouts.master')

@section('content')

<div class="card">
    <div class="card-body">

        @if ($message = Session::get('success'))
        <div class="alert border-0 bg-light-success alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-success"><i class="bi bi-check-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-success">{{ $message }}</div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        @if ($message = Session::get('fail'))
        <div class="alert border-0 bg-light-danger alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-danger"><i class="bi bi-x-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-danger">
                        {{$message}}
                    </div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        <hr />

        <h5 class="text-center">{{ $clientname }}</h5>

        <div class="table-responsive">
            <table data-page-length='10' id="example2" class="table table-striped table-bordered">
                <thead class="table-secondary">
                    <tr>
                        <th>Sl No</th>
                        <th>Name</th>
                        <th>Username</th>
                        <th>Shop</th>
                        <th>Reg. Date</th>
                        <th>Account Type</th>
                    </tr>
                </thead>
                <tbody>
                    <?php

                    use App\Http\Controllers\GeneralController;
                    use App\Http\Controllers\MainAcontroller;

                    $num = 1; ?>
                    @foreach($users as $client)
                    <tr>
                        <td>{{ $num }}</td>

                        <td>{{ $client->Name }} </td>

                        <td>{{ $client->UserName }}</td>

                        <td>
                            <p>{{ $client->userid }}</p>
                            <p>{{ $client->ClientName }}</p>
                            <p> {{ $client->Area }} </p>
                            <p> {{ $client->Location }}</p>
                        </td>

                        <td> <label class="text-danger"> <?php echo MainAcontroller::convertDate($client->Reg_stamp); ?> </label></td>

                        <!-- <td>{{ $client->Mobile }}</td> -->

                       

                        @if($client->IsUser == 1)
                        <td> <label style="color: green;">USER</label> </td>
                        @elseif( $client->IsShop == 1 )
                        <td> <label style="color: green;">SHOP</label> </td>
                        @else
                        <td> <label style="color: green;">ADMIN</label> </td>
                        @endif

                       

                       
                    </tr>
                    <?php $num++; ?>
                    @endforeach

                </tbody>
            </table>
        </div>
    </div>
</div>

<script>
    $(document).ready(function() {
        $(".clickToView").click(function() {


            $('#modalClientDetails').modal('show');

        });

        $(".manageMaxConnections").click(function() {

            var clientid = $(this).data("id");
            var userid = $(this).data("uid");
            var max = $(this).data("max");

            document.getElementById("maxConn").value = max;
            document.getElementById("maxclientid").value = clientid;
            document.getElementById("maxuserid").value = userid;

            $('#modalManageMaxConnection').modal('show');

        });
    });
</script>
@endsection