<?php

use App\Http\Controllers\CashClosingController;
use App\Http\Controllers\ClientController;
use App\Http\Controllers\DeleteController;
use App\Http\Controllers\EditController;
use App\Http\Controllers\MainAcontroller;
use App\Http\Controllers\PermissionController;
use App\Http\Controllers\PurchaseReportController;
use App\Http\Controllers\DenominationController;
use App\Http\Controllers\LoginReportController;
use App\Http\Controllers\SaleController;
use App\Http\Controllers\StockController;
use App\Http\Controllers\PackageController;
use App\Http\Controllers\BannerController;
use App\Http\Controllers\PermissionMethodController;
use App\Http\Controllers\UploadQRController;
use App\Http\Controllers\StockTransferController;
use App\Http\Controllers\AppPermissionController;
use App\Http\Controllers\PricingController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\PurchaseOrderController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Route::get('/', function () {
//     return view('welcome');
// });

Route::get('/', [MainAcontroller::class, 'login'])->name('web.login');

Route::get('/privacy-policy', [MainAcontroller::class, 'privacypolicy'])->name('web.privacypolicy');

Route::get('/main-privacy-policy', [MainAcontroller::class, 'mainprivacypolicy'])->name('web.mainprivacypolicy');

Route::get('/terms-and-conditions', [MainAcontroller::class, 'terms'])->name('web.terms');

Route::post('/validateLogin', [MainAcontroller::class, 'validateLogin'])->name('web.validateLogin');

Route::get('/logout', [MainAcontroller::class, 'logout'])->name('web.logout');




Route::group(['middleware' => ['AuthCheck']], function () {


    Route::get('/customerappusers', [ClientController::class, 'customerappusers'])->name('web.customerappusers');
    
        Route::post('/updateAssignedShop', [ClientController::class, 'updateAssignedShop'])->name('web.updateAssignedShop');


        Route::get('/updateassignedshoplist/{id}/{client}', [ClientController::class, 'updateassignedshoplist'])->name('web.updateassignedshoplist');

    
    Route::get('/enableForceLogout/{userid}', [MainAcontroller::class, 'enableForceLogout'])->name('web.enableForceLogout');
    
    Route::post('/updateUserDetails', [MainAcontroller::class, 'updateUserDetails'])->name('web.updateUserDetails');
    
    Route::post('/viewUserReport', [MainAcontroller::class, 'viewUserReport'])->name('web.viewUserReport');
    
    Route::post('/getExistingPrivilageDateByUser', [MainAcontroller::class, 'getExistingPrivilageDateByUser'])->name('web.getExistingPrivilageDateByUser');
    
    Route::post('/getUserDetailsByID', [MainAcontroller::class, 'getUserDetailsByID'])->name('web.getUserDetailsByID');
    
    Route::post('/grantprivilegeforuser', [AppPermissionController::class, 'grantprivilegeforuser'])->name('web.grantprivilegeforuser');
    
    Route::post('/getPreviousRemarks', [MainAcontroller::class, 'getPreviousRemarks'])->name('web.getPreviousRemarks');

    // for search
    
    Route::post('/getSimilarClients', [MainAcontroller::class, 'getSimilarClients'])->name('web.getSimilarClients');

    // for search close
    
        Route::get('/deleteusersfromdb/{id}', [ClientController::class, 'deleteusersfromdb'])->name('web.deleteusersfromdb');


    
    Route::get('/viewPrivilageHistory/{userid}', [AppPermissionController::class, 'viewPrivilageHistory'])->name('web.viewPrivilageHistory');

    Route::get('/viewExpiryReport', [ProductController::class, 'viewExpiryReport'])->name('web.viewExpiryReport');
    
    
    
    
    
    Route::post('/grantPrivilegeForAll', [AppPermissionController::class, 'grantPrivilegeForAll'])->name('web.grantPrivilegeForAll');
    
    Route::get('/resetpasswordtodefault/{userid}', [MainAcontroller::class, 'resetpasswordtodefault'])->name('web.resetpasswordtodefault');
    
    Route::get('/managesubusers/{userid}', [MainAcontroller::class, 'managesubusers'])->name('web.managesubusers');
    
    Route::post('/createSubUser', [MainAcontroller::class, 'createSubUser'])->name('web.createSubUser');

    // payment 
    Route::post('/getBillingInfoByClientID', [ClientController::class, 'getBillingInfoByClientID'])->name('web.getBillingInfoByClientID');

    Route::post('/getPackageDetails', [PackageController::class, 'getPackageDetails'])->name('web.getPackageDetails');
    // ---------------------------------------------------------------------------------------------------------  

    Route::post('/extendtrialpackage', [PackageController::class, 'extendtrialpackage'])->name('web.extendtrialpackage');
    
    Route::post('/getuserpackagehistory', [PackageController::class, 'getuserpackagehistory'])->name('web.getuserpackagehistory');
    
    
    
    Route::get('/createnewuser/{id}', [MainAcontroller::class, 'createnewuser'])->name('web.createnewuser');
    
    Route::get('/viewpurchaseorders', [PurchaseOrderController::class, 'viewpurchaseorders'])->name('web.viewpurchaseorders');

    Route::post('/savenewuser', [MainAcontroller::class, 'savenewuser'])->name('web.savenewuser');

    Route::get('/purchaseordersettings', [PurchaseOrderController::class, 'purchaseordersettings'])->name('web.purchaseordersettings');
    
    Route::post('/saveDeletePurchaseOrderPermission', [PurchaseOrderController::class, 'saveDeletePurchaseOrderPermission'])->name('web.saveDeletePurchaseOrderPermission');





    // --------------------------------------------------------------------------------------------------------

    Route::get('/paymentSuccess/{client}', [PaymentController::class, 'paymentSuccess'])->name('web.paymentSuccess');

    
    Route::post('/readytopay', [PaymentController::class, 'readytopay'])->name('web.readytopay');
    
    Route::post('/readytopaycopy', [PaymentController::class, 'readytopaycopy'])->name('web.readytopaycopy');

    Route::get('/paymentResponse', [PaymentController::class, 'paymentResponse'])->name('web.paymentResponse');

    Route::get('/redirectback', [PaymentController::class, 'redirectback'])->name('web.redirectback');

    Route::get('/', [MainAcontroller::class, 'login'])->name('web.login');

    Route::get('/updatewebpermissionstatus/{id}', [PermissionController::class, 'updatewebpermissionstatus'])->name('web.updatewebpermissionstatus');

    Route::get('/updateAppLoginStatus/{id}', [PermissionController::class, 'updateAppLoginStatus'])->name('web.updateAppLoginStatus');


    Route::get('/getpurchaseorderpdf/{ordernumber}/{clientid}', [ClientController::class, 'getpurchaseorderpdf'])->name('web.getpurchaseorderpdf');


    Route::get('/makeasprimaryaccount/{userid}', [ClientController::class, 'makeasprimaryaccount'])->name('web.makeasprimaryaccount');
    
        Route::get('/deletehistory', [DeleteController::class, 'deletehistory'])->name('web.deletehistory');


    Route::get('/paymenthistory', [PaymentController::class, 'paymenthistory'])->name('web.paymenthistory');
    
    Route::get('/dashboard', [MainAcontroller::class, 'dashboard'])->name('web.dashboard');

    Route::get('/updateMaxUserCOunt', [ClientController::class, 'updateMaxUserCOunt'])->name('web.updateMaxUserCOunt');
    
    Route::get('/manageClients', [ClientController::class, 'manageClients'])->name('web.manageClients');

    Route::get('/manageClientsNew/{type}', [ClientController::class, 'manageClientsNew'])->name('web.manageClientsNew');
    
    Route::get('/manageClientsAjax/{type}', [ClientController::class, 'manageClientsAjax'])->name('web.manageClientsAjax');
    
    Route::get('/manageAssignedShopList/{id}', [ClientController::class, 'manageAssignedShopList'])->name('web.manageAssignedShopList');

    Route::get('/manageUsers', [ClientController::class, 'manageUsers'])->name('web.manageUsers');
    
    Route::get('/manageUsersByClient/{id}', [ClientController::class, 'manageShopUsersByClient'])->name('web.manageUsersByClient');
    
    Route::get('/manageCustomerUsersByClient/{id}', [ClientController::class, 'manageCustomerUsersByClient'])->name('web.manageCustomerUsersByClient');

    Route::get('/manageLogginedUsers', [ClientController::class, 'manageLogginedUsers'])->name('web.manageLogginedUsers');
    
    Route::get('/showusersbyPackage/{pack}', [ClientController::class, 'showusersbyPackage'])->name('web.showusersbyPackage');

    Route::get('/clientDetails/{hash}', [ClientController::class, 'clientDetails'])->name('web.clientDetails');

    Route::get('/managePermissions/{hash}', [PermissionController::class, 'managePermissions'])->name('web.managePermissions');

    // Route::get('/viewStockReport', [PermissionController::class, 'viewStockReport'])->name('web.viewStockReport');

    Route::get('/status/updat', [PermissionController::class, 'updateReportPermissionStatus'])->name('users.update.status');

    Route::get('/managePermissionsajax', [PermissionController::class, 'managePermissionsajax'])->name('web.managePermissionsajax');

    Route::post('/updatepermissions', [PermissionController::class, 'updatepermissions'])->name('web.updatepermissions');

    Route::post('/updateColumnPermissions', [PermissionController::class, 'updateColumnPermissions'])->name('web.updateColumnPermissions');

    Route::get('/managecolumnpermissions/{slug}/{hash}', [PermissionController::class, 'managecolumnpermissions'])->name('web.managecolumnpermissions');

    Route::get('/getAllClientsForStockReport', [ClientController::class, 'getAllClientsForStockReport'])->name('web.getAllClientsForStockReport');

    Route::get('/getAllClients', [ClientController::class, 'getAllClients'])->name('web.getAllClients');


    Route::get('/viewStockReport', [StockController::class, 'viewStockReport'])->name('web.viewStockReport');


    Route::get('/managerowpermissions/{slug}/{hash}', [PermissionController::class, 'managerowpermissions'])->name('web.managerowpermissions');

    Route::post('/updateRowPermissions', [PermissionController::class, 'updateRowPermissions'])->name('web.updateRowPermissions');

    Route::get('/getAllClientsForSaleReport', [ClientController::class, 'getAllClientsForSaleReport'])->name('web.getAllClientsForSaleReport');

    // sale report

    Route::post('/viewSaleReport', [SaleController::class, 'viewSaleReport'])->name('web.viewSaleReport');

    Route::get('/viewSaleReportdetail/{from}/{to}/{client}', [SaleController::class, 'viewSaleReportTwo'])->name('web.viewSaleReportTwo');

    Route::get('/viewSaleReportmoredetail/{from}/{to}/{client}', [SaleController::class, 'viewSaleReportThree'])->name('web.viewSaleReportThree');

    Route::get('/viewTypeDetails/{from}/{to}/{type}/{client}', [SaleController::class, 'viewTypeDetails'])->name('web.viewTypeDetails');

    Route::get('/saleviewThreeTypeDetails/{from}/{to}/{type}/{client}', [SaleController::class, 'saleviewThreeTypeDetails'])->name('web.saleviewThreeTypeDetails');

    // sale report close

    // purchase report starts

    Route::get('/getAllClientsForPurchaseReport', [ClientController::class, 'getAllClientsForPurchaseReport'])->name('web.getAllClientsForPurchaseReport');

    Route::post('/viewPurchaseReport', [PurchaseReportController::class, 'viewPurchaseReport'])->name('web.viewPurchaseReport');

    Route::get('/viewPurchaseReportDetail/{from}/{to}/{client}/{supplier}', [PurchaseReportController::class, 'viewPurchaseReportTwo'])->name('web.viewPurchaseReportTwo');

    Route::get('/viewPurchaseReportMoreDetail/{from}/{to}/{client}/{supplier}', [PurchaseReportController::class, 'viewPurchaseReportThree'])->name('web.viewPurchaseReportThree');

    // purchase report close

    // edit report starts

    Route::post('/viewEditReport', [EditController::class, 'viewEditReport'])->name('web.viewEditReport');

    Route::get('/editReportsaleDetail/{client}/{bill}', [EditController::class, 'editReportsaleDetail'])->name('web.editReportsaleDetail');

    Route::get('/editReportsaleDetailAjax/{client}/{bill}', [EditController::class, 'editReportsaleDetailAjax'])->name('web.editReportsaleDetailAjax');

    Route::get('/editReportViewItemUsingedit/{client}/{editid}/{bill}', [EditController::class, 'editReportViewItemUsingedit'])->name('web.editReportViewItemUsingedit');

    // edit report close

    // denomination report

    Route::post('/viewCashClosingReport', [CashClosingController::class, 'cashClosing'])->name('web.viewCashClosingReport');

    // denomination report close

    // login report 
    Route::post('/loginReport', [LoginReportController::class, 'loginReport'])->name('web.loginReport');

    Route::get('/loginReportDetail/{client}/{from}', [LoginReportController::class, 'loginReportDetail'])->name('web.loginReportDetail');

    // login report close


    Route::post('/deleteFromDatabase', [DeleteController::class, 'deleteFromDatabase'])->name('web.deleteFromDatabase');

    // delete client
    Route::post('/deleteclient', [ClientController::class, 'deleteclient'])->name('web.deleteclient');

    Route::post('/getSupplierByClient', [ClientController::class, 'getSupplierByClient'])->name('web.getSupplierByClient');
    
    Route::get('/getAllSuppliers', [ClientController::class, 'getAllSuppliers'])->name('web.getAllSuppliers');

    Route::post('/getUserListByClient', [ClientController::class, 'getUserListByClient'])->name('web.getUserListByClient');



    Route::get('/generateBill', [ClientController::class, 'generateBill'])->name('web.generateBill');

    Route::get('/generateCashClosingBill', [ClientController::class, 'generateCashClosingBill'])->name('web.generateCashClosingBill');

    Route::get('/manageUserPermissions/{userid}/{clientid}', [PermissionController::class, 'manageUserPermissions'])->name('web.manageUserPermissions');


    Route::post('/updateUserPermission', [PermissionController::class, 'updateUserPermission'])->name('web.updateUserPermission');

    Route::post('/updateUserPurchasePermission', [PermissionController::class, 'updateUserPurchasePermission'])->name('web.updateUserPurchasePermission');

    Route::post('/createSalePermissionsForUser', [PermissionController::class, 'createSalePermissionsForUser'])->name('web.createSalePermissionsForUser');

    Route::post('/createPurchasePermissionsForUser', [PermissionController::class, 'createPurchasePermissionsForUser'])->name('web.createPurchasePermissionsForUser');

    Route::post('/createPrivilageForReports', [PermissionController::class, 'createPrivilageForReports'])->name('web.createPrivilageForReports');


    // manage ad banner
    Route::get('/manageAdBanner', [BannerController::class, 'manageAdBanner'])->name('web.manageAdBanner');

    Route::get('/createBanner', [BannerController::class, 'createBanner'])->name('web.createBanner');

    Route::post('/uploadBanner', [BannerController::class, 'uploadBanner'])->name('web.uploadBanner');

    Route::get('/updateBannerStatus/{id}', [BannerController::class, 'updateBannerStatus'])->name('web.updateBannerStatus');

    Route::get('/deleteBanner/{id}', [BannerController::class, 'deleteBanner'])->name('web.deleteBanner');


    Route::post('/getMultiInvoiceBySupplier', [PurchaseReportController::class, 'getMultiInvoiceBySupplier'])->name('web.getMultiInvoiceBySupplier');

    Route::post('/getMultiInvoiceAdjustment', [PurchaseReportController::class, 'getMultiInvoiceAdjustment'])->name('web.getMultiInvoiceAdjustment');



    // permission routes
    Route::resource('managePackages', PackageController::class, [
        'names' => [
            'index' => 'web.managePackages',
            'create' => 'managePackages.create',
            'store' => 'managePackages.store',

            'edit' => 'managePackages.edit',
            'update' => 'managePackages.update'
        ]
    ]);

    Route::get('/status/{id}', [PackageController::class, 'status'])->name('managePackages.status');
    Route::get('/deletePackage/{id}', [PackageController::class, 'deletePackage'])->name('managePackages.deletePackage');

    Route::get('/seeUserActions/{id}', [PackageController::class, 'seeUserActions'])->name('web.seeUserActions');

    Route::post('/updateActionPrice', [PackageController::class, 'updateActionPrice'])->name('web.updateActionPrice');

    Route::post('/updatePackagePrice', [PackageController::class, 'updatePackagePrice'])->name('web.updatePackagePrice');

    Route::post('/addUserAction', [PackageController::class, 'addUserAction'])->name('web.addUserAction');

    Route::get('/assignUserPermission/{Uid}/{Cid}', [PermissionMethodController::class, 'assignUserPermission'])->name('web.assignUserPermission');


    // sale report ajax

    Route::post('/getSaleActivityOne', [SaleController::class, 'getSaleActivityOne'])->name('web.getSaleActivityOne');

    Route::get('/searchPage/{type}', [SaleController::class, 'searchPage'])->name('web.searchPage');

    Route::get('/viewpricing', [PricingController::class, 'viewpricing'])->name('web.viewpricing');

    Route::post('/changeSessionClientID', [MainAcontroller::class, 'changeSessionClientID'])->name('web.changeSessionClientID');

    Route::get('/uploadPayQR', [UploadQRController::class, 'uploadPayQR'])->name('web.uploadPayQR');

    Route::post('/uploadQRImage', [UploadQRController::class, 'uploadQRImage'])->name('web.uploadQRImage');

    Route::get('/updateQRUploadStatus/{client}', [UploadQRController::class, 'updateQRUploadStatus'])->name('web.updateQRUploadStatus');

    Route::post('/editStockTransferReport', [StockTransferController::class, 'editStockTransferReport'])->name('web.editStockTransferReport');

    Route::get('/deletePackageAction/{id}', [PackageController::class, 'deletePackageAction'])->name('web.deletePackageAction');

    Route::get('/updateUserActionStatus/{id}', [PackageController::class, 'updateUserActionStatus'])->name('web.updateUserActionStatus');

    Route::get('/assignedAppPermissions/{user}/{client}', [AppPermissionController::class, 'assignedAppPermissions'])->name('web.assignedAppPermissions');

    Route::post('/allotPackagePermission', [AppPermissionController::class, 'allotPackagePermission'])->name('web.allotPackagePermission');

    Route::post('/updatePermissionStatus', [AppPermissionController::class, 'updatePermissionStatus'])->name('web.updatePermissionStatus');
    
    Route::get('/updatepermissionstatusbyid/{id}', [AppPermissionController::class, 'updatepermissionstatusbyid'])->name('web.updatepermissionstatusbyid');

    Route::post('/updatePermissionStatusWithFromTo', [AppPermissionController::class, 'updatePermissionStatusWithFromTo'])->name('web.updatePermissionStatusWithFromTo');

    Route::post('/getAllPermissionUsers', [AppPermissionController::class, 'getAllPermissionUsers'])->name('web.getAllPermissionUsers');

    Route::post('/copyUserPermission', [AppPermissionController::class, 'copyUserPermission'])->name('web.copyUserPermission');
});
