<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>" />


<?php

use App\Http\Controllers\PermissionMethodController;
use App\Http\Controllers\GeneralController;
use App\Http\Controllers\MainAcontroller;
?>
<?php $__env->startSection('content'); ?>

<div class="card">
    <div class="card-body" id="photo">

        <?php if($message = Session::get('success')): ?>
        <div class="alert border-0 bg-light-success alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-success"><i class="bi bi-check-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-success"><?php echo e($message); ?></div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        <?php endif; ?>

        <?php if($message = Session::get('fail')): ?>
        <div class="alert border-0 bg-light-danger alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-danger"><i class="bi bi-x-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-danger">
                        <?php echo e($message); ?>

                    </div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        <?php endif; ?>

        <h6 class="mb-0 text-uppercase text-center">
            <label id="saleOneClient" class="text-danger"> </label>
        </h6>

        <p class="text-center" id="saleOneAreaLoc"> </p>

        <div id="saleSearchForm" class="border p-4 rounded">

            <div class="card-header py-3">
                <div class="row g-3 align-items-center">

                    <div class="col-12 col-lg-4 col-md-6 me-auto">
                        <h5 class="mb-0 "><?php echo e($clientname); ?> , <?php echo e($clientarea); ?> , <?php echo e($clientlocation); ?> </h5>
                        <!-- <img src="" width="20px" height="20px"> -->
                    </div>

                    <div class="col-12 col-lg-3 col-6 col-md-3 mt-2">
                        <button hidden type="button" class="btn btn-primary showUserHistory ">History</button>

                        <!-- extend trial extendUserTrial -->
                        <?php if( $isLive == 0 ): ?>
                        <button data-method="extend" type="button" class="btn btn-secondary grantPrivilege"> Extend Trial </button>
                        <?php endif; ?>
                        <!-- extend trial close -->


                        <!-- make pack active upgradePermissionToActive-->
                        <?php if( count($userPermissions) != 0 && $isLive == 0 ): ?>
                        <button data-method="makeactive" type="button" class="btn btn-primary grantPrivilege"> Make Active Pack </button>
                        <?php endif; ?>
                        <!-- make pack active close -->



                        <!-- extend active pack afetr expiry  grantPrivilege-->
                        <?php if( count($userPermissions) != 0 && $isLive == 1 ): ?>
                        <button data-method="renewactive" type="button" class="btn btn-primary grantPrivilege"> Renew Pack </button>
                        <?php endif; ?>
                        <!-- extend active pack afetr expiry close -->

                        <?php $__currentLoopData = $userPermissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $per): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                        <?php if($per->act_slug == 'trial'): ?>
                        <input hidden value="<?php echo e($per->per_from); ?>" class="form-control" id="trialSlugFrom" name="trialID[]">
                        <input hidden value="<?php echo e($per->per_to); ?>" class="form-control" id="trialSlugTo" name="trialID[]">
                        <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                </div>

                <div class="mt-2">
                    <p>User : <?php echo e($username); ?> , Package : <?php echo e($packagename); ?></p>
                    <?php if($permissions != 0): ?>
                    <p class="text-danger">From : <?php echo MainAcontroller::convertDate($fromdate) ?> to <?php echo MainAcontroller::convertDate($todate) ?> </p>
                    <?php endif; ?>
                    <?php $billing_type = MainAcontroller::getBillingTypeForUser($userID) ?>

                    <?php if($billing_type != '' && $billing_type == 'M'): ?>
                    <label class="text-danger">Monthly Billing</label>
                    <?php else: ?>
                    <label class="text-danger">Yearly Billing</label>
                    <?php endif; ?>

                </div>
            </div>


            <!-- <button class="btn btn-primary">  allotPermissions , copyPermissions  grantPrivilege </button> -->
            <?php if($permissions == 0): ?>
            <a data-method="allotpermission" class="btn btn-primary grantPrivilege"> Allot Permission </a>
            <!-- <a data-method="copypermission" data-bs-toggle="modal" class="btn btn-primary grantPrivilege"> Copy Permission </a> -->
            <?php endif; ?>



            <div hidden class="row">

                <label> SILVER </label>
                <br>

                <?php $__currentLoopData = $userPermissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $per): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($per->Package_ID == 1): ?>

                <?php if($per->act_slug == 'trial'): ?>
                <input hidden value="<?php echo e($per->id); ?>" class="form-control" id="trialID" name="trialID[]">
                <?php endif; ?>

                <div class="col-4">
                    <div data-bs-toggle="tooltip" data-bs-placement="top" title=" Valid upto : <?php echo e($per->per_to); ?>" class="form-check">
                        <input title="" data-id="<?php echo e($per->id); ?>" class="form-check-input userActions" type="checkbox" value="" id="<?php echo e($per->act_slug); ?>" <?php echo e($per->status == 1 ? 'checked' : ''); ?>>
                        <label class="form-check-label" for="<?php echo e($per->act_slug); ?>"><?php echo e($per->act_desc); ?></label>
                    </div>
                </div>
                <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <br>

                <label> GOLD </label>
                <br>
                <?php $__currentLoopData = $userPermissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $per): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($per->Package_ID == 2): ?>

                <?php if($per->act_slug == 'trial'): ?>
                <input hidden value="<?php echo e($per->id); ?>" class="form-control" id="trialID" name="trialID[]">
                <?php endif; ?>

                <div class="col-4">
                    <div data-bs-toggle="tooltip" data-bs-placement="top" title=" Valid upto : <?php echo e($per->per_to); ?>" class="form-check">
                        <input title="" data-id="<?php echo e($per->id); ?>" class="form-check-input userActions" type="checkbox" value="" id="<?php echo e($per->act_slug); ?>" <?php echo e($per->status == 1 ? 'checked' : ''); ?>>
                        <label class="form-check-label" for="<?php echo e($per->act_slug); ?>"><?php echo e($per->act_desc); ?></label>
                    </div>
                </div>
                <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <br>

                <label> PLATINUM </label>
                <br>
                <?php $__currentLoopData = $userPermissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $per): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($per->Package_ID == 3): ?>

                <?php if($per->act_slug == 'trial'): ?>
                <input hidden value="<?php echo e($per->id); ?>" class="form-control" id="trialID" name="trialID[]">
                <?php endif; ?>


                <div class="col-4">
                    <div data-bs-toggle="tooltip" data-bs-placement="top" title=" Valid upto : <?php echo e($per->per_to); ?>" class="form-check">
                        <input title="" data-id="<?php echo e($per->id); ?>" class="form-check-input userActions" type="checkbox" value="" id="<?php echo e($per->act_slug); ?>" <?php echo e($per->status == 1 ? 'checked' : ''); ?>>
                        <label class="form-check-label" for="<?php echo e($per->act_slug); ?>"><?php echo e($per->act_desc); ?></label>
                    </div>
                </div>
                <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <?php $__currentLoopData = $userPermissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $per): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($per->Package_ID == 4): ?>

                <?php if($per->act_slug == 'trial'): ?>
                <input hidden value="<?php echo e($per->id); ?>" class="form-control" id="trialID" name="trialID[]">
                <?php endif; ?>


                <div class="col-4">
                    <div data-bs-toggle="tooltip" data-bs-placement="top" title=" Valid upto : <?php echo e($per->per_to); ?>" class="form-check">
                        <input title="" data-id="<?php echo e($per->id); ?>" class="form-check-input userActions" type="checkbox" value="" id="<?php echo e($per->act_slug); ?>" <?php echo e($per->status == 1 ? 'checked' : ''); ?>>
                        <label class="form-check-label" for="<?php echo e($per->act_slug); ?>"><?php echo e($per->act_desc); ?></label>
                    </div>
                </div>
                <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </div>



            <div class="table-responsive mt-5">
                <table data-page-length='10' id="" class="table table-striped table-bordered">
                    <thead class="table-secondary">
                        <tr>
                            <!-- <th>#</th> -->
                            <th>Sl No</th>
                            <th>Permission Name</th>
                            <th>Package</th>
                            <th>Amount</th>
                            <th>From Date</th>
                            <th>To Date</th>
                            <th>Days Left</th>
                            <th>Status</th>

                            <!-- <th>Action</th> -->
                        </tr>
                    </thead>

                    <tbody>
                        <?php $num = 1; ?>
                        <?php $__currentLoopData = $userPermissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $per): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>

                            <!-- <td> <input type="checkbox" name="permissions[]" id="permissionCheck"> </td> -->
                            <td> <?php echo e($num); ?> </td>
                            <td> <?php echo e($per->act_desc); ?> </td>

                            <?php if($per->Pack_Name == 'SILVER'): ?>
                            <td> <label style="color: #C0C0C0;"> <?php echo e($per->Pack_Name); ?> </label> </td>
                            <?php elseif($per->Pack_Name == 'GOLD'): ?>
                            <td> <label style="color: #FFD700;"> <?php echo e($per->Pack_Name); ?> </label> </td>
                            <?php elseif($per->Pack_Name == 'PLATINUM'): ?>
                            <td> <label style="color: #E5E4E2;"> <?php echo e($per->Pack_Name); ?> </label> </td>
                            <?php endif; ?>


                            <td> Rs <?php echo number_format($per->act_payment, 2) ?> </td>
                            <td> <?php echo MainAcontroller::convertDate($per->per_from) ?> </td>
                            <td> <?php echo MainAcontroller::convertDate($per->per_to) ?> </td>

                            <?php $daysLeft =  GeneralController::daysleft($per->per_to) ?>

                            <?php if( $daysLeft == 'Date is Expired' ): ?>
                            <td> <label class="text-danger"> <?php echo e($daysLeft); ?> </label> </td>
                            <?php else: ?>
                            <td> <label class="text-success"> <?php echo e($daysLeft); ?> </label> </td>
                            <?php endif; ?>

                            <?php if($per->status == 1): ?>
                            <td> <a href="<?php echo e(route('web.updatepermissionstatusbyid',$per->id)); ?>" class="btn btn-primary"> Active </a> </td>
                            <?php else: ?>
                            <td> <a href="<?php echo e(route('web.updatepermissionstatusbyid',$per->id)); ?>" class="btn btn-danger"> Inactive </a> </td>
                            <?php endif; ?>
                            <!-- <td> Action </td> -->

                        </tr>
                        <?php $num++; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                    </tbody>
                </table>
            </div>




        </div>


    </div>
</div>



<!-- popup dialogue for from and to -->
<div class="modal fade" id="modelEnablePermission" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Copy Permission</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <!-- updatePermissionStatusWithFromTo -->

            <form method="post" action="<?php echo e(route('web.readytopaycopy')); ?>" class="row g-3">
                <?php echo csrf_field(); ?>
                <div class="modal-body">

                    <div class="modal-body">

                        <input hidden id="copytid" required name="tid" type="text" class="form-control">
                        <input hidden value=" " id="copymarchantid" required name="merchant_id" type="text" class="form-control">
                        <input hidden value=" " id="copyorderid" required name="order_id" type="text" class="form-control">
                        <input hidden value="INR" id="currency" required name="currency" type="text" class="form-control">
                        <input hidden value="https://api.digitronicsindia.com/aswas/public/uploads/ccavResponseHandler.blade.php" id="redirect_url" required name="redirect_url" type="text" class="form-control">
                        <input hidden value="https://api.digitronicsindia.com/aswas/public" id="cancel_url" required name="cancel_url" type="text" class="form-control">
                        <input hidden value="EN" id="language" required name="language" type="text" class="form-control">

                        <label>Billing Address</label>

                        <div class="row col-12">
                            <div class="col-6">
                                <input class="form-control" id="copybilling_name" type="text" name="billing_name" value=" " />
                            </div>
                            <div class="col-6">
                                <input class="form-control" id="copybilling_address" type="text" name="billing_address" value=" " />
                            </div>
                        </div>

                        <br>

                        <div class="row col-12">
                            <div class="col-6">
                                <input class="form-control" id="copybilling_city" type="text" name="billing_city" value=" " />
                            </div>
                            <div class="col-6">
                                <input class="form-control" id="copybilling_state" type="text" name="billing_state" value="KERALA" />
                            </div>
                        </div>
                        <br>

                        <div class="row col-12">
                            <div class="col-6">
                                <input class="form-control" id="copybilling_zip" type="text" name="billing_zip" value=" " />
                            </div>
                            <div class="col-6">
                                <input class="form-control" type="text" name="billing_country" value="India" />
                            </div>
                        </div>

                        <br>
                        <div class="row col-12">
                            <div class="col-6">
                                <input class="form-control" id="copybilling_tel" type="text" name="billing_tel" value=" " />
                            </div>
                            <div class="col-6">
                                <input class="form-control" id="copybilling_email" type="text" name="billing_email" value=" " />
                            </div>
                        </div>

                        <br>

                        <div class="row col-12">

                            <div class="col-6">
                                <label class="form-label">Amount</label>
                                <input id="copyamount" readonly required name="amount" type="text" class="form-control">
                            </div>

                            <div class="col-6">
                                <label class="form-label">Amount (Adjustment + or - ) </label>
                                <input id="copyamount" name="adjustment" type="number" pattern="{0-9}[5]" class="form-control">
                            </div>

                        </div>

                        <br>

                        <div class="row col-12">
                            <div class="col-6">
                                <label class="form-label">Client</label>
                                <input readonly id="copym1" required name="merchant_param1" type="text" class="form-control">
                            </div>

                            <div class="col-6">
                                <label class="form-label">User ID</label>
                                <select id="copym2" required name="merchant_param2" class="form-control">
                                </select>
                            </div>
                        </div>

                        <br>

                        <div class="row col-12">
                            <div class="col-4">
                                <label class="form-label">From Date</label>
                                <input min="<?php echo date('Y-m-d'); ?>" id="copym3" required name="merchant_param3" type="date" class="form-control">
                            </div>

                            <div class="col-4">
                                <label class="form-label">No Of Days</label>
                                <input id="daysCount" required name="daysCount" type="number" class="form-control daysCount">
                            </div>

                            <div class="col-4">
                                <label class="form-label">To Date</label>
                                <input min="<?php echo date('Y-m-d'); ?>" id="copym4" required name="merchant_param4" type="date" class="form-control">
                            </div>
                        </div>


                        <div hidden class="col-12">
                            <label class="form-label">Type</label>
                            <input id="copym5" required name="merchant_param5" value="copy" type="text" class="form-control">
                        </div>

                        <br>


                        <div class="col-12">
                            <input id="cistrial" name="cistrial" type="checkbox">
                            <label class="form-label">Trial Version</label>
                        </div>


                        <div class="col-12">
                            <input checked id="cisActive" name="cisActive" type="checkbox">
                            <label for="isActive" class="form-label">Skip the payment and make the pack active</label>
                        </div>

                    </div>



                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Add Permission</button>

                    </div>

                </div>
            </form>

        </div>
    </div>
</div>

<!-- <div class="modal fade" id="modelEnablePermission" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Enable Permission</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>

            <form method="post" action="<?php echo e(route('web.updatePermissionStatusWithFromTo')); ?>" class="row g-3">
                <?php echo csrf_field(); ?>
                <div class="modal-body">

                    <div hidden class="col-12">
                        <label class="form-label">rowid</label>
                        <input id="perRowID" required name="perRowID" type="text" class="form-control">
                    </div>

                    <div class="col-12">
                        <label class="form-label">From Date</label>
                        <input id="dateFrom" required name="from" type="date" class="form-control">
                    </div>

                    <div class="col-12">
                        <label class="form-label">To Date</label>
                        <input id="dateTo" required name="to" type="date" class="form-control">
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Add Permission</button>

                    </div>

                </div>
            </form>

        </div>
    </div>
</div> -->
<!-- popup dialogue for from and to close -->




<script>
    $(document).ready(function() {

        // clientUsageMode
        $(".clientUsageMode").change(function() {
            // const clientBillingType = document.getElementById('clientBillingType').value;
            var temp = "";
            const billingType = document.getElementById('clientBillingType');

            if (this.value == 'T') {
                // alert(this.value)
                $("#clientBillingType").val(temp);
                $('#clientBillingType').prop('disabled', true);

                document.getElementById("clientAmount").value = 0;

                document.getElementById("clientAmount").readOnly = true;
                document.getElementById("clientAdjustment").readOnly = true;
                // document.getElementById('clientBillingType').attr("disabled", "disabled");
            } else {
                $('#clientBillingType').prop('disabled', false);
                billingType.setAttribute('required', '');
                document.getElementById("clientAmount").readOnly = false;
                document.getElementById("clientAdjustment").readOnly = false;
            }

        });

        $(".clientBillingType").change(function() {
            // const clientBillingType = document.getElementById('clientBillingType').value;
            var packageid = "<?php echo e($packageID); ?>";
            var bType = this.value;

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                type: 'POST',
                url: "<?php echo e(route('web.getPackageDetails')); ?>",
                data: {
                    packageid: packageid
                },
                success: function(data) {

                    if (bType == 'M') {
                        data.forEach(function(number) {

                            var amount = number['advance'].replace(/,/g, '');;
                            var afterGst = ((parseFloat(amount) * 18) / 100) + parseFloat(amount);

                            var monthAmount = number['emi'].replace(/,/g, '');;
                            var monthAfterGst = ((parseFloat(monthAmount) * 18) / 100) + parseFloat(monthAmount);

                            document.getElementById("clientAmount").value = afterGst;

                            document.getElementById("clientAmountLabel").innerText = " Collecting Rs." + afterGst + " as first advance inc. GST , Monthly installment is : Rs." + monthAfterGst;


                        });
                    } else {
                        data.forEach(function(number) {

                            var amount = number['Pack_payment'].replace(/,/g, '');;
                            var afterGst = ((parseFloat(amount) * 18) / 100) + parseFloat(amount);

                            document.getElementById("clientAmount").value = afterGst;
                            document.getElementById("clientAmountLabel").innerText = "";

                        });
                    }

                }
            });

        });


        $(".daysCount").change(function() {

            const start = new Date(document.getElementById('copym3').value);

            if (start != '') {
                const count = document.getElementById('daysCount').value;
                // alert(start);
                start.setDate(start.getDate() + parseInt(count));
                // alert(start.toLocaleDateString());
                document.getElementById('copym4').value = start.toISOString().slice(0, 10);
            } else {
                alert('Select from date first');
            }

        });

        $(".grantPrivilege").on('click', function(event) {



            var client = "<?php echo e($clientID); ?>";
            var user = "<?php echo e($userID); ?>";
            var packageid = "<?php echo e($packageID); ?>";

            var merchant = "<?php echo e($merchant); ?>";
            var accesskey = "<?php echo e($accesskey); ?>";
            var workingkey = "<?php echo e($workingkey); ?>";

            var sessionuser = "<?php echo e($sessionuser); ?>";

            var method = $(this).data("method");

            if (method == 'extend') {

                document.getElementById("clientUsageMode").setAttribute("disabled", "disabled");
                document.getElementById("clientBillingType").setAttribute("disabled", "disabled");

                document.getElementById("clientAmount").readOnly = true;
                document.getElementById("clientAdjustment").readOnly = true;

                //  get from to date 
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });

                $.ajax({
                    type: 'POST',
                    url: "<?php echo e(route('web.getExistingPrivilageDateByUser')); ?>",
                    data: {
                        user: user
                    },
                    success: function(data) {

                        data.forEach(function(number) {

                            const start = new Date(number['per_from']);
                            const end = new Date(number['per_to']);

                            document.getElementById('clientPerFrom').value = start.toISOString().slice(0, 10);
                            document.getElementById('clientPerTo').value = end.toISOString().slice(0, 10);


                        });

                    }
                });

            }

            if (method == 'makeactive') {

                $("#clientUsageMode option[value='T']").remove();

                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });

                $.ajax({
                    type: 'POST',
                    url: "<?php echo e(route('web.getExistingPrivilageDateByUser')); ?>",
                    data: {
                        user: user
                    },
                    success: function(data) {

                        data.forEach(function(number) {

                            const start = new Date(number['per_from']);
                            const end = new Date(number['per_to']);

                            document.getElementById('clientPerFrom').value = start.toISOString().slice(0, 10);
                            document.getElementById('clientPerTo').value = end.toISOString().slice(0, 10);


                        });

                    }
                });

            }

            if(method == 'renewactive')
            {
                $("#clientUsageMode option[value='T']").remove();

                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });

                $.ajax({
                    type: 'POST',
                    url: "<?php echo e(route('web.getExistingPrivilageDateByUser')); ?>",
                    data: {
                        user: user
                    },
                    success: function(data) {

                        data.forEach(function(number) {

                            const start = new Date(number['per_from']);
                            const end = new Date(number['per_to']);

                            document.getElementById('clientPerFrom').value = start.toISOString().slice(0, 10);
                            document.getElementById('clientPerTo').value = end.toISOString().slice(0, 10);


                        });

                    }
                });
            }

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                type: 'POST',
                url: "<?php echo e(route('web.getBillingInfoByClientID')); ?>",
                data: {
                    client: client
                },
                success: function(data) {

                    data.forEach(function(number) {

                        billing_name = number['ClientName'];
                        billing_address = number['Address1'];
                        billing_city = number['Location'];
                        billing_state = number['Address2'];
                        billing_zip = number['PinCode'];

                        document.getElementById("clientName").value = billing_name == '' ? 0 : billing_name;
                        document.getElementById("clientAddress").value = billing_address == '' ? 0 : billing_address;
                        document.getElementById("clientCity").value = billing_city == '' ? 0 : billing_city;
                        document.getElementById("clientState").value = billing_state == '' ? 0 : billing_state;
                        document.getElementById("clientPinCode").value = billing_zip == '' ? 0 : billing_zip;



                    });

                }
            });

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                type: 'POST',
                url: "<?php echo e(route('web.getUserDetailsByID')); ?>",
                data: {
                    userid: user
                },
                success: function(data) {

                    data.forEach(function(number) {

                        var Mobile = number['Mobile'];
                        var UserName = number['UserName'];

                        document.getElementById("clientMobile").value = Mobile == '' ? 0 : Mobile;
                        document.getElementById("clientEmail").value = UserName == '' ? 0 : UserName;

                    });

                }
            });

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                type: 'POST',
                url: "<?php echo e(route('web.getPackageDetails')); ?>",
                data: {
                    packageid: packageid
                },
                success: function(data) {

                    data.forEach(function(number) {

                        var amount = number['Pack_payment'].replace(/,/g, '');;
                        var afterGst = ((parseFloat(amount) * 18) / 100) + parseFloat(amount);

                        document.getElementById("clientAmount").value = afterGst;

                    });

                }
            });

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                type: 'POST',
                url: "<?php echo e(route('web.getPreviousRemarks')); ?>",
                data: {
                    userid: user
                },
                success: function(data) {

                    data.forEach(function(number) {

                        var Type = number['Type'];
                        var From_Date = number['From_Date'];
                        var To_Date = number['To_Date'];
                        var AllottedDate = number['AllottedDate'];

                        document.getElementById("clientPreRemarks").value = "User package is " + Type + " From - " + From_Date + " to " + To_Date;

                    });

                }
            });

            document.getElementById("clientClientUserID").value = client + '/' + user;
            document.getElementById("clientPackageSessionID").value = packageid + '/' + sessionuser;

            document.getElementById("clientMethod").value = method;

            $('#modalGrantPrivilege').modal('show');

        });

        $(".showUserHistory").on('click', function(event) {

            var client = "<?php echo e($clientID); ?>"
            var user = "<?php echo e($userID); ?>"
            showUserPackHistory(client, user);

        });

        $(".extendUserTrial").on('click', function(event) {

            var client = "<?php echo e($clientID); ?>"
            var user = "<?php echo e($userID); ?>"
            var from = "<?php echo e($fromdate); ?>"
            var to = "<?php echo e($todate); ?>"
            // var trialID = document.getElementById('trialID').value ;

            var values = $("input[name='trialID[]']")
                .map(function() {
                    return $(this).val();
                }).get();

            //   alert(values);
            var trialID = values;

            extendTrialPack(client, user, from, to, trialID);

        });


        $(".allotPermissions").on('click', function(event) {


            var client = "<?php echo e($clientID); ?>"
            var user = "<?php echo e($userID); ?>"
            var packageid = "<?php echo e($packageID); ?>"

            var merchant = "<?php echo e($merchant); ?>"
            var accesskey = "<?php echo e($accesskey); ?>"
            var workingkey = "<?php echo e($workingkey); ?>"

            var sessionuser = "<?php echo e($sessionuser); ?>"

            var tid = Math.floor((Math.random() * 10000) + 1);
            var order_id = client + Math.floor((Math.random() * 10000) + 1);

            var billing_name = 0;
            var billing_address = 0;
            var billing_city = 0;
            var billing_state = 0;
            var billing_zip = 0;
            var billing_tel = '+919562719658';
            var billing_email = 'manojelayath1@gmail.com';
            var amount = 0;

            document.getElementById("allotm1").value = client + "/" + user;
            document.getElementById("allotm2").value = packageid + "/" + sessionuser;

            // alert(workingkey);
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                type: 'POST',
                url: "<?php echo e(route('web.getBillingInfoByClientID')); ?>",
                data: {
                    client: client
                },
                success: function(data) {

                    data.forEach(function(number) {

                        billing_name = number['ClientName'];
                        billing_address = number['Address1'];
                        billing_city = number['Location'];
                        billing_state = number['Address2'];
                        billing_zip = number['PinCode'];
                        billing_tel = '+919562719658';
                        billing_email = 'manojelayath1@gmail.com';

                        document.getElementById("allotbilling_name").value = billing_name == '' ? 0 : billing_name;
                        document.getElementById("allotbilling_address").value = billing_address == '' ? 0 : billing_address;
                        document.getElementById("allotbilling_city").value = billing_city == '' ? 0 : billing_city;
                        // document.getElementById("allotbilling_state").value = billing_state == '' ? 0 : billing_state;
                        document.getElementById("allotbilling_zip").value = billing_zip == '' ? 0 : billing_zip;
                        document.getElementById("allotbilling_tel").value = billing_tel == '' ? 0 : billing_tel;
                        document.getElementById("allotbilling_email").value = billing_email == '' ? 0 : billing_email;

                    });

                }
            });


            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                type: 'POST',
                url: "<?php echo e(route('web.getPackageDetails')); ?>",
                data: {
                    packageid: packageid
                },
                success: function(data) {

                    data.forEach(function(number) {

                        var amount = number['Pack_payment'].replace(/,/g, '');;
                        var afterGst = ((parseFloat(amount) * 18) / 100) + parseFloat(amount);
                        document.getElementById("allotamount").value = afterGst;

                    });

                }
            });


            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                type: 'POST',
                url: "<?php echo e(route('web.getPreviousRemarks')); ?>",
                data: {
                    userid: user
                },
                success: function(data) {

                    data.forEach(function(number) {

                        var Type = number['Type'];
                        var From_Date = number['From_Date'];
                        var To_Date = number['To_Date'];
                        var AllottedDate = number['AllottedDate'];

                        document.getElementById("allotPreRemarks").value = "User package is " + Type + " From - " + From_Date + " to " + To_Date;

                    });

                }
            });

            document.getElementById("allottid").value = tid == '' ? 0 : tid;
            document.getElementById("allotorderid").value = order_id == '' ? 0 : order_id;
            document.getElementById("allotmarchantid").value = merchant;

            $('#modalAllotExistPackagePermission').modal('show');

        });

        // upgrade to active 
        $(".upgradePermissionToActive").on('click', function(event) {


            var client = "<?php echo e($clientID); ?>"
            var user = "<?php echo e($userID); ?>"
            var packageid = "<?php echo e($packageID); ?>"

            var merchant = "<?php echo e($merchant); ?>"
            var accesskey = "<?php echo e($accesskey); ?>"
            var workingkey = "<?php echo e($workingkey); ?>"

            var sessionuser = "<?php echo e($sessionuser); ?>"

            var tid = Math.floor((Math.random() * 10000) + 1);
            var order_id = client + Math.floor((Math.random() * 10000) + 1);

            var billing_name = 0;
            var billing_address = 0;
            var billing_city = 0;
            var billing_state = 0;
            var billing_zip = 0;
            var billing_tel = '+919562719658';
            var billing_email = 'manojelayath1@gmail.com';
            var amount = 0;

            document.getElementById("allotm1").value = client + "/" + user;
            document.getElementById("allotm2").value = packageid + "/" + sessionuser;

            // alert(workingkey);
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                type: 'POST',
                url: "<?php echo e(route('web.getBillingInfoByClientID')); ?>",
                data: {
                    client: client
                },
                success: function(data) {

                    data.forEach(function(number) {

                        billing_name = number['ClientName'];
                        billing_address = number['Address1'];
                        billing_city = number['Location'];
                        billing_state = number['Address2'];
                        billing_zip = number['PinCode'];
                        billing_tel = '+919562719658';
                        billing_email = 'manojelayath1@gmail.com';

                        document.getElementById("allotbilling_name").value = billing_name == '' ? 0 : billing_name;
                        document.getElementById("allotbilling_address").value = billing_address == '' ? 0 : billing_address;
                        document.getElementById("allotbilling_city").value = billing_city == '' ? 0 : billing_city;
                        // document.getElementById("allotbilling_state").value = billing_state == '' ? 0 : billing_state;
                        document.getElementById("allotbilling_zip").value = billing_zip == '' ? 0 : billing_zip;
                        document.getElementById("allotbilling_tel").value = billing_tel == '' ? 0 : billing_tel;
                        document.getElementById("allotbilling_email").value = billing_email == '' ? 0 : billing_email;

                    });

                }
            });


            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                type: 'POST',
                url: "<?php echo e(route('web.getPackageDetails')); ?>",
                data: {
                    packageid: packageid
                },
                success: function(data) {

                    data.forEach(function(number) {

                        var amount = number['Pack_payment'].replace(/,/g, '');
                        var afterGst = ((parseFloat(amount) * 18) / 100) + parseFloat(amount);
                        document.getElementById("allotamount").value = afterGst;

                    });

                }
            });


            document.getElementById("allottid").value = tid == '' ? 0 : tid;
            document.getElementById("allotorderid").value = order_id == '' ? 0 : order_id;
            document.getElementById("allotmarchantid").value = merchant;

            document.getElementById("allotTrialDiv").hidden = true;

            const startDate = new Date(document.getElementById("trialSlugFrom").value);
            const endDate = new Date(document.getElementById("trialSlugTo").value);

            document.getElementById('merchant_param3').value = startDate.toISOString().slice(0, 10);
            document.getElementById('merchant_param4').value = endDate.toISOString().slice(0, 10);

            // 
            // 



            $('#modalAllotExistPackagePermission').modal('show');

        });
        // upgrade to active close

        $(".copyPermissions").on('click', function(event) {

            // alert('clicked');

            var client = "<?php echo e($clientID); ?>"
            var user = "<?php echo e($userID); ?>"
            var packageid = "<?php echo e($packageID); ?>"

            var merchant = "<?php echo e($merchant); ?>"
            var accesskey = "<?php echo e($accesskey); ?>"
            var workingkey = "<?php echo e($workingkey); ?>"

            var sessionuser = "<?php echo e($sessionuser); ?>"

            var tid = Math.floor((Math.random() * 10000) + 1);
            var order_id = client + Math.floor((Math.random() * 10000) + 1);

            var billing_name = 0;
            var billing_address = 0;
            var billing_city = 0;
            var billing_state = 0;
            var billing_zip = 0;
            var billing_tel = '+919562719658';
            var billing_email = 'm@gmail.com';
            var amount = 0;

            // alert( client + " / " + user + " / " + packageid + " / " + merchant + " / " + accesskey + " / " + workingkey + " / " + sessionuser + " / " + tid + " / " + order_id) ;


            document.getElementById("copym1").value = user + "/" + client + "/" + packageid + "/" + sessionuser;
            // document.getElementById("toClientID").value = client;
            // document.getElementById("toPackageID").value = packageid;

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                type: 'POST',
                url: "<?php echo e(route('web.getAllPermissionUsers')); ?>",
                data: {
                    package: packageid
                },
                success: function(data) {

                    $("#copym2").empty();

                    $('#copym2')
                        .append($("<option></option>")
                            .attr("value", "")
                            .text("Choose one"));

                    $.each(data, function(index, value) {

                        $('#copym2')
                            .append($("<option></option>")
                                .attr("value", value.id + ',' + value.userid)
                                .text(value.Name));

                    });

                }
            });

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                type: 'POST',
                url: "<?php echo e(route('web.getBillingInfoByClientID')); ?>",
                data: {
                    client: client
                },
                success: function(data) {

                    data.forEach(function(number) {

                        billing_name = number['ClientName'];
                        billing_address = number['Address1'];
                        billing_city = number['Location'];
                        billing_state = number['Address2'];
                        billing_zip = number['PinCode'];
                        billing_tel = '+919562719658';
                        billing_email = 'manojelayath1@gmail.com';

                        // alert( billing_name + " / " + billing_address + " / " + billing_city + " / " + billing_state + " / " + billing_zip + " / " + billing_tel + " / "  + billing_email );

                        document.getElementById("copybilling_name").value = billing_name == '' ? 0 : billing_name;
                        document.getElementById("copybilling_address").value = billing_address == '' ? 0 : billing_address;
                        document.getElementById("copybilling_city").value = billing_city == '' ? 0 : billing_city;
                        // document.getElementById("copybilling_state").value = billing_state == '' ? 0 : billing_state;
                        document.getElementById("copybilling_zip").value = billing_zip == '' ? 0 : billing_zip;
                        document.getElementById("copybilling_tel").value = billing_tel == '' ? 0 : billing_tel;
                        document.getElementById("copybilling_email").value = billing_email == '' ? 0 : billing_email;

                    });

                }
            });


            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                type: 'POST',
                url: "<?php echo e(route('web.getPackageDetails')); ?>",
                data: {
                    packageid: packageid
                },
                success: function(data) {

                    data.forEach(function(number) {

                        var amount = number['Pack_payment'];
                        var afterGst = ((amount * 18) / 100) + amount;
                        document.getElementById("copyamount").value = afterGst;

                    });

                }
            });


            document.getElementById("copytid").value = tid == '' ? 0 : tid;
            document.getElementById("copyorderid").value = order_id == '' ? 0 : order_id;
            document.getElementById("copymarchantid").value = merchant;

            $('#modelEnablePermission').modal('show');
            // $('#modalCopyPermission').modal('show');

        });





        $(".userActions").on('click', function(event) {

            if ($(this).prop("checked") == true) {

                var checkedValue = $(this).data("id");
                let status = 1;

                document.getElementById("perRowID").value = checkedValue;

                $('#modelEnablePermission').modal('show');


                // $.ajaxSetup({
                //     headers: {
                //         'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                //     }
                // });

                // $.ajax({
                //     type: 'POST',
                //     url: "<?php echo e(route('web.updatePermissionStatus')); ?>",
                //     data: {
                //         rowid: checkedValue,
                //         status: status
                //     },
                //     success: function(data) {

                //         if (data.success) {
                //             iziToast.success({
                //                 title: 'Success',
                //                 position: 'topRight',
                //                 message: data.message,
                //             });
                //         }

                //         if (data.fail) {
                //             iziToast.error({
                //                 title: 'Failed',
                //                 position: 'topRight',
                //                 message: data.message,
                //             });
                //         }

                //     }
                // });


            } else if ($(this).prop("checked") == false) {

                var checkedValue = $(this).data("id");
                let status = 1;

                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });

                $.ajax({
                    type: 'POST',
                    url: "<?php echo e(route('web.updatePermissionStatus')); ?>",
                    data: {
                        rowid: checkedValue,
                        status: status
                    },
                    success: function(data) {

                        if (data.success) {
                            iziToast.success({
                                title: 'Success',
                                position: 'topRight',
                                message: data.message,
                            });
                        }

                        if (data.fail) {
                            iziToast.error({
                                title: 'Failed',
                                position: 'topRight',
                                message: data.message,
                            });
                        }

                    }
                });

            }

        });

    });
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('Admin.Layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/digitronicsindia/public_html/aswas/resources/views/Admin/appPermissions.blade.php ENDPATH**/ ?>