<?php

namespace App\Http\Controllers;

use App\Models\FreeTrail;
use App\Models\Packages;
use App\Models\PermissionActions;
use App\Models\UserPermissions;
use App\Models\Users;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\DB;

class PackageController extends Controller
{
    function extendtrialpackage(Request $request)
    {

        $extClient = $request->extClient;
        $extUser = $request->extUser;
        $extFromDate = $request->extFromDate;
        $extToDate = $request->extToDate;
        $trialRowID = $request->trialRowID;

        $rowIdS = explode(",", $trialRowID);

        for ($i = 0; $i < count($rowIdS); $i++) {
            $uper = UserPermissions::find($rowIdS[$i]);

            $uper->per_from = $extFromDate;
            $uper->per_to = $extToDate;

            $save = $uper->save();
        }

        UserPermissions::where('User_ID', '=', $extUser)
            ->where('Client_ID', '=', $extClient)
            ->update([
                'per_from' => $extFromDate,
                'per_to' => $extToDate

            ]);

        return back()->with('success', 'Trial package extended successfully');

        //    $user = 

        //     return response()->json($allUsers);
    }

    function getuserpackagehistory(Request $request)
    {

        $client = $request->client;
        $user = $request->user;

        $allUsers = FreeTrail::where('User_ID', '=', $user)
            ->where('Client_ID', '=', $client)
            ->get();

        return response()->json($allUsers);
    }

    function getPackageDetails(Request $request)
    {
        $allUsers = Packages::where('id', '=', $request->packageid)->get();
        return response()->json($allUsers);
    }

    function index()
    {
        $data = [
            'packages' => Packages::all()
        ];

        return view('Admin.managePackage', $data);
    }

    function create()
    {
        return view('Admin.createPackage');
    }

    function store(Request $request)
    {
        $request->validate([
            'Pack_Name' => 'required|unique:tbl_packages',
            'Pack_Slug' => 'required|unique:tbl_packages',
            'Pack_Status' => 'required'
        ]);

        $package = Packages::create([
            'Pack_Name' => $request->Pack_Name,
            'Pack_Slug' => $request->Pack_Slug,
            'Pack_Status' => $request->Pack_Status
        ]);

        if ($package) {
            return back()->with('success', 'Package created successfully');
        } else {
            return back()->with('fail', 'Something went wrong');
        }
    }

    function updatePackagePrice(Request $request)
    {
        $pack = Packages::find($request->packid);

        $pack->Pack_payment = $request->amount;

        $save = $pack->save();

        if ($save) {
            return back()->with('success', 'Package pricing changed successfully');
        } else {
            return back()->with('fail', 'Soemthing went wrong');
        }
    }

    function updateActionPrice(Request $request)
    {
        $pack = PermissionActions::find($request->actid);

        $pack->act_payment = $request->price;

        $save = $pack->save();

        if ($save) {
            return back()->with('success', 'Package status changed successfully');
        } else {
            return back()->with('fail', 'Soemthing went wrong');
        }
    }

    function status($id)
    {
        $pack = Packages::where('id', Crypt::decrypt($id))->first();

        if ($pack->Pack_Status == 1) {
            $pack->update([
                'Pack_Status' => 0
            ]);
        } else {
            $pack->update([
                'Pack_Status' => 1
            ]);
        }
        return back()->with('success', 'Package status changed successfully');
    }

    function deletePackage($id)
    {
        $pack = Packages::where('id', Crypt::decrypt($id))->delete();

        return back()->with('success', 'Package deleted successfully');
    }

    function seeUserActions($id)
    {
        $dat = $id;
        $packid = Packages::where('Pack_Slug', '=', $dat)->pluck('id')->first();
        // $dat = Crypt::decrypt($id);

        $data = [

            'package' => Packages::where('Pack_Slug', '=', $dat)->pluck('Pack_Name')->first(),
            'packageid' => $packid,
            'userActions' => PermissionActions::select('tbl_permissionActions.*', 'tbl_packages.Pack_Name')
                ->join('tbl_packages', 'tbl_permissionActions.act_package', '=', 'tbl_packages.id')
                ->where('act_package', '=', $packid)
                ->get()
        ];
        return view('Admin.seeUserAction', $data);
        // return $data;
    }



    // user actions
    function addUserAction(Request $request)
    {

                $exist = PermissionActions::where('act_slug', '=', $request->slug_url)->where('act_package', '=', $request->actp_id)->first();


        if (!$exist) {

            $action = new PermissionActions();

            $action->act_package = $request->actp_id;
            $action->act_desc = $request->act_des;
            $action->act_status = $request->status;
            $action->act_slug = $request->slug_url;
            $action->act_payment = $request->act_amount;

            $updated =  $action->save();

            if ($updated) {

                $lastid = $action->id;

                $users = UserPermissions::select("*")
                    ->groupBy("User_ID")->get();

                foreach ($users as $usr) {
                    if ($usr->Package_ID == $request->actp_id) {
                        $uPer = new UserPermissions();

                        $uPer->Client_ID = $usr->Client_ID;
                        $uPer->User_ID = $usr->User_ID;
                        $uPer->Package_ID = $usr->Package_ID;
                        $uPer->per_act = $lastid;
                        $uPer->per_from = $usr->per_from;
                        $uPer->per_to = $usr->per_to;
                        $uPer->status = $request->status;
                        $uPer->userper_slug = $request->slug_url;

                        $uPer->save();
                    }
                }

                return back()->with('success', 'Action created successfully');
            }

            // $actions = PermissionActions::create([
            //     'act_package' => $request->actp_id,
            //     'act_desc' => $request->act_des,
            //     'act_status' => $request->status,
            //     'act_slug' => $request->slug_url,
            //     'act_payment' => $request->act_amount
            // ]);



        } else {
            return back()->with('fail', 'Already exist');
        }


    }

    function deletePackageAction($id)
    {

        $aId = Crypt::decrypt($id);

        $action = PermissionActions::find($aId);

        $action->delete();

        return back()->with('success', 'Action deleted successfully');
    }

    function updateUserActionStatus($id)
    {

        $uaID = Crypt::decrypt($id);

        $userAction = PermissionActions::find($uaID);

        if ($userAction->act_status == 0) {
            $userAction->act_status = 1;
        } else {
            $userAction->act_status = 0;
        }

        $userAction->save();

        return back()->with('success', 'User Action Status updated successfully');
    }
}
