<?php

namespace App\Http\Controllers;

use App\Models\DeletePurchasePermission;
use App\Models\DeleteSettings;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class PurchaseOrderController extends Controller
{
    function viewpurchaseorders()
    {
        $data = [
            'orders' => DB::select(" SELECT * FROM `received_orders1` WHERE `ClientID` = 354 group by OrderNo; ")
        ];

        return view('Admin.ViewPurchaseOrders', $data);
    }

    function purchaseordersettings()
    {
        $client_id = session('LoggedUser')['ClientID'];
        $user_id = session('LoggedUser')['id'];

        $data = [
            'settings' => DeleteSettings::where('status', '=', 1)->get(),

            'existing' => DeletePurchasePermission::select("po_deletepermissions.*", "po_deletesettings.settings")
                ->join('po_deletesettings', 'po_deletepermissions.po_settings', '=', 'po_deletesettings.id')
                ->where('po_deletepermissions.client_id', '=', $client_id)
                ->where('po_deletepermissions.user_id', '=', $user_id)
                ->get(),

            'cartdate' =>  DeletePurchasePermission::select("po_deletepermissions.*", "po_deletesettings.settings")
            ->join('po_deletesettings', 'po_deletepermissions.po_settings', '=', 'po_deletesettings.id')
            ->where('po_deletepermissions.client_id', '=', $client_id)
            ->where('po_deletepermissions.user_id', '=', $user_id)
            ->where('po_deletepermissions.slug', '=', 'cart')
            ->pluck('po_days')->first()  ,

            'senddate' =>  DeletePurchasePermission::select("po_deletepermissions.*", "po_deletesettings.settings")
            ->join('po_deletesettings', 'po_deletepermissions.po_settings', '=', 'po_deletesettings.id')
            ->where('po_deletepermissions.client_id', '=', $client_id)
            ->where('po_deletepermissions.user_id', '=', $user_id)
            ->where('po_deletepermissions.slug', '=', 'order')
            ->pluck('po_days')->first()  ,

            'deleteddate' =>  DeletePurchasePermission::select("po_deletepermissions.*", "po_deletesettings.settings")
            ->join('po_deletesettings', 'po_deletepermissions.po_settings', '=', 'po_deletesettings.id')
            ->where('po_deletepermissions.client_id', '=', $client_id)
            ->where('po_deletepermissions.user_id', '=', $user_id)
            ->where('po_deletepermissions.slug', '=', 'deleted')
            ->pluck('po_days')->first()  
        ];

        // return $data;
        return view('Admin.POSettings', $data);
    }

    function saveDeletePurchaseOrderPermission(Request $request)
    {
        // slug url
        $cart = 'cart';
        $order = 'order';
        $deleted = 'deleted';
        // slug url close

        $cartBoolean = false;
        $orderBoolean = false;
        $deletedBoolean = false;

        $cartsettings = $request->cartsettings;
        $ordersettings = $request->ordersettings;
        $deletedsettings = $request->deletedsettings;

        $cartsettingsID = DeleteSettings::where('days', '=', $cartsettings)->pluck('id')->first();
        $ordersettingsID = DeleteSettings::where('days', '=', $ordersettings)->pluck('id')->first();
        $deletedsettingsID = DeleteSettings::where('days', '=', $deletedsettings)->pluck('id')->first();

        $client_id = session('LoggedUser')['ClientID'];
        $user_id = session('LoggedUser')['id'];

        $cartexist = DeletePurchasePermission::where('client_id', '=', $client_id)
            ->where('user_id', '=', $user_id)
            ->where('slug', '=', $cart)
            ->first();

        $orderexist = DeletePurchasePermission::where('client_id', '=', $client_id)
            ->where('user_id', '=', $user_id)
            ->where('slug', '=', $order)
            ->first();

        $deletedexist = DeletePurchasePermission::where('client_id', '=', $client_id)
            ->where('user_id', '=', $user_id)
            ->where('slug', '=', $deleted)
            ->first();

        // cart settings :
        if ($cartexist) {

            $PoSetID = DeletePurchasePermission::where('client_id', '=', $client_id)
                ->where('user_id', '=', $user_id)
                ->where('slug', '=', $cart)
                ->pluck('id')->first();

            $poSettings = DeletePurchasePermission::find($PoSetID);

            $poSettings->po_settings = $cartsettingsID;
            $poSettings->po_days = $cartsettings;
            $poSettings->slug = $cart;
            $poSettings->client_id = $client_id;
            $poSettings->user_id = $user_id;

            $save = $poSettings->save();

            $cartBoolean = true;

            // if ($save) {

            //     return back()->with('success', 'Delete settings updated successfully');

            // } else 
            // {
            //     return back()->with('fail', 'Something went wrong');
            // }
        } else {
            $PoSet = new DeletePurchasePermission();

            $PoSet->po_settings = $cartsettingsID;
            $PoSet->po_days = $cartsettings;
            $PoSet->slug = $cart;
            $PoSet->client_id = $client_id;
            $PoSet->user_id = $user_id;

            $save = $PoSet->save();

            $cartBoolean = true;

            // if ($save) {

            //     return back()->with('success', 'Delete settings created successfully');

            // } else 
            // {
            //     return back()->with('fail', 'Something went wrong');
            // }
        }


        // order exist
        if ($orderexist) {
            $PoSetID = DeletePurchasePermission::where('client_id', '=', $client_id)
                ->where('user_id', '=', $user_id)
                ->where('slug', '=', $order)
                ->pluck('id')->first();

            $poSettings = DeletePurchasePermission::find($PoSetID);

            $poSettings->po_settings = $ordersettingsID;
            $poSettings->po_days = $ordersettings;
            $poSettings->slug = $order;
            $poSettings->client_id = $client_id;
            $poSettings->user_id = $user_id;

            $save = $poSettings->save();

            $orderBoolean = true;

            // if ($save) {

            //     return back()->with('success', 'Delete settings updated successfully');

            // } else 
            // {
            //     return back()->with('fail', 'Something went wrong');
            // }
        } else {
            $PoSet = new DeletePurchasePermission();

            $PoSet->po_settings = $ordersettingsID;
            $PoSet->po_days = $ordersettings;
            $PoSet->slug = $order;
            $PoSet->client_id = $client_id;
            $PoSet->user_id = $user_id;

            $save = $PoSet->save();

            $orderBoolean = true;

            // if ($save) {

            //     return back()->with('success', 'Delete settings created successfully');

            // } else 
            // {
            //     return back()->with('fail', 'Something went wrong');
            // }
        }

        // deleted :

        if ($deletedexist) {
            $PoSetID = DeletePurchasePermission::where('client_id', '=', $client_id)
                ->where('user_id', '=', $user_id)
                ->where('slug', '=', $deleted)
                ->pluck('id')->first();

            $poSettings = DeletePurchasePermission::find($PoSetID);

            $poSettings->po_settings = $deletedsettingsID;
            $poSettings->po_days = $deletedsettings;
            $poSettings->slug = $deleted;
            $poSettings->client_id = $client_id;
            $poSettings->user_id = $user_id;

            $save = $poSettings->save();

            $deletedBoolean = true;

            // if ($save) {

            //     return back()->with('success', 'Delete settings updated successfully');

            // } else 
            // {
            //     return back()->with('fail', 'Something went wrong');
            // }
        } else {
            $PoSet = new DeletePurchasePermission();

            $PoSet->po_settings = $deletedsettingsID;
            $PoSet->po_days = $deletedsettings;
            $PoSet->slug = $deleted;
            $PoSet->client_id = $client_id;
            $PoSet->user_id = $user_id;

            $save = $PoSet->save();

            $deletedBoolean = true;

            // if ($save) {

            //     return back()->with('success', 'Delete settings created successfully');

            // } else 
            // {
            //     return back()->with('fail', 'Something went wrong');
            // }
        }

        if ($cartBoolean && $orderBoolean && $deletedBoolean) {

            return back()->with('success', 'Delete settings created successfully');

        } else {

            return back()->with('fail', 'Something went wrong');

        }
    }
}
