<?php

namespace App\Http\Controllers;

use App\Models\ActivityPermission;
use App\Models\ActivityPurchasePermission;
use App\Models\Clients;
use App\Models\PurchaseOne;
use App\Models\SalesOne;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use PHPUnit\Framework\Constraint\Count;

class PurchaseReportController extends Controller
{

    function getMultiInvoiceBySupplier(Request $request)
    {

        $client = session('LoggedUser')['userid'];
        // $client = $request->client;
        $from = $request->datez;
        $supplier = $request->supplier;

        $multiInvoice = PurchaseOne::select(
            'purchase1.ClientID',
            'purchase_date',
            'purchase1.supplier_name',
            'supplier_name',
            'invoice_date',
            'invoice_no',

            DB::raw("ROUND(SUM(grand_total),2) as tot"),
        )
            ->where('purchase1.ClientID', '=', $client)
            ->where('supplier_name', '=', $supplier)
            ->whereBetween('purchase_date', [$from, $from])
            ->groupBy('ClientID')
            ->groupBy('purchase_date')
            ->groupBy('supplier_name')
            ->groupBy('invoice_no')
            ->groupBy('invoice_date')
            ->get();

        return $multiInvoice;

        // return json_encode($multiInvoice);

    }

    function getMultiInvoiceAdjustment(Request $request)
    {

        // $client = $request->client;
        $client = session('LoggedUser')['userid'];
        $from = $request->datez;
        $supplier = $request->supplier;

        $adjustments = PurchaseOne::select(

            'clientid',
            'purchase_date',
            'supplier_name',
            'invoice_no',

            DB::raw("ROUND(SUM(grand_total+adjustment),2) as total"),
            DB::raw("ROUND(SUM(adjustment),2) as adjustment"),
            DB::raw("ROUND(SUM(grand_total+adjustment),2) as NetBalance"),
        )
            ->where('purchase1.ClientID', '=', $client)
            ->where('supplier_name', '=', $supplier)
            ->whereBetween('purchase_date', [$from, $from])
            ->groupBy('ClientID')
            ->groupBy('purchase_date')
            ->groupBy('supplier_name')
            ->get();

        return $adjustments;

        // return json_encode($multiInvoice);

    }

    function viewPurchaseReportThree($from, $to, $client,$supplier)
    {
        if($supplier == 'null')
        {
            $data = [

                'clientname' => Clients::where('ClientID', '=', $client)->pluck('ClientName'),
    
                'area' => Clients::where('ClientID', '=', $client)->pluck('Area'),
                'location' => Clients::where('ClientID', '=', $client)->pluck('Location'),
    
                'from' => $from,
                'to' => $to,
                // 'client' => $client,
                'client' => session('LoggedUser')['userid'],
    
    
                'totalPurchase' => PurchaseOne::select(
                    'purchase1.ClientID',
                    'purchase_date',
                    'purchase1.supplier_name',
                    'Mobile',
                    'Phone1',
                    'invoice_no',
    
                    DB::raw("ROUND(SUM(grand_total),2) as tot"),
                    DB::raw("ROUND(sum(adjustment),2) as adjustment"),
                    DB::raw("ROUND(SUM(grand_total + adjustment),2) as NetBalance")
                )
                    ->join('supplier', 'supplier.supplier_name', '=', 'purchase1.supplier_name')
                    ->where('purchase1.ClientID', '=', $client)
                    ->whereBetween('purchase_date', [$from, $to])
                    ->groupBy('ClientID')
                    ->groupBy('purchase_date')
                    ->groupBy('supplier_name')
                    ->get(),
            ];
    
            foreach ($data['totalPurchase'] as $pur) {
    
                $myArr[] = PurchaseOne::select(
                    'purchase1.ClientID',
                    'purchase_date',
                    'purchase1.supplier_name',
                    'invoice_date',
                    'invoice_no',
    
                    DB::raw("ROUND(SUM(grand_total + adjustment),2) as tot"),
                )
                    ->where('purchase1.supplier_name', '=', $pur->supplier_name)
                    ->where('purchase1.ClientID', '=', $client)
                    ->whereBetween('purchase_date', [$from, $to])
                    ->get();
            }
    
            $loadcontent = '';
            // $multiInvoices = '';
            $num = 1;
    
            for ($i = 0; $i < Count($data['totalPurchase']); $i++) {
    
                // $loadcontent .= $data['totalPurchase'][$i]['supplier_name'] . '----' . $myArr[$i][0]['tot'];
    
                $multiInvoices[] = PurchaseOne::select(
    
                    'purchase_date',
                    'supplier_name',
    
                    'invoice_date',
    
                    'invoice_no',
    
                    DB::raw("ROUND(SUM(grand_total),2) as tot"),
                )
                    ->where('purchase1.supplier_name', '=', $data['totalPurchase'][$i]['supplier_name'])
                    ->where('purchase1.ClientID', '=', $client)
                    ->whereBetween('purchase_date', [$from, $to])
                    ->groupBy('ClientID')
                    ->groupBy('purchase_date')
                    ->groupBy('supplier_name')
                    ->groupBy('invoice_no')
                    ->groupBy('invoice_date')
                    ->get();
    
                $loadcontent .= '<div class="accordion-item">
                <h2 class="accordion-header" id="headingOne">
    
                    <button 
                    
                    data-tableid="multiInvoiceSupplier' . $num . '"
                    data-supplier=" ' . $data['totalPurchase'][$i]['supplier_name'] . ' "
                    data-date=" ' . $data['from'] . ' "
                    data-client=" ' . $data['client'] . ' "
    
                    class="accordion-button collapsed accSupplierExp" type="button" data-bs-toggle="collapse" 
                    data-bs-target="#collapse' . $num . '" aria-expanded="false" aria-controls="collapse' . $num . '">
    
                        <div class="row col-12">
                        
                            <div class="col-3">
                                ' . $num . '
                            </div>
    
                            <div class="col-3">
                                ' . $data['totalPurchase'][$i]['supplier_name'] . ' 
                            </div>
    
    
                            <div class="col-3">
                                ' .  MainAcontroller::convertDate(substr($myArr[$i][0]['purchase_date'], 0, 10)) . '
                            </div>
      
                            <div class="col-3">
                                ₹ ' . $myArr[$i][0]['tot'] . '
                            </div>
      
                        </div>
      
                    </button>
      
                </h2>
    
                <div id="collapse' . $num . '" class="accordion-collapse collapse " aria-labelledby="headingOne">
                    
                    <div id="multiInvoiceSupplier' . $num . '"   class="accordion-body">
      
                    
                                    
                                    
                    
      
                    </div>
                </div>
      
                
            </div>';
    
                $num++;
            }
    
            $myData = [
                'content' => $loadcontent,
    
                'clientname' => Clients::where('ClientID', '=', $client)->pluck('ClientName'),
    
                'area' => Clients::where('ClientID', '=', $client)->pluck('Area'),
                'location' => Clients::where('ClientID', '=', $client)->pluck('Location'),
    
                'from' => $from,
                'to' => $to,
                // 'client' => $client,
                'client' => session('LoggedUser')['userid'],

                'supplier' => '',
    
                'total' => PurchaseOne::select(DB::raw("ROUND(sum(grand_total + adjustment),2) as tot"))
                    ->whereBetween('purchase_date', [$from, $to])
                    ->where('ClientID', '=', $client)
                    ->get()
            ];
        }
        else
        {
            $data = [

                'clientname' => Clients::where('ClientID', '=', $client)->pluck('ClientName'),
    
                'area' => Clients::where('ClientID', '=', $client)->pluck('Area'),
                'location' => Clients::where('ClientID', '=', $client)->pluck('Location'),
    
                'from' => $from,
                'to' => $to,
                // 'client' => $client,
                'client' => session('LoggedUser')['userid'],
    
    
                'totalPurchase' => PurchaseOne::select(
                    'purchase1.ClientID',
                    'purchase_date',
                    'purchase1.supplier_name',
                    'Mobile',
                    'Phone1',
                    'invoice_no',
    
                    DB::raw("ROUND(SUM(grand_total),2) as tot"),
                    DB::raw("ROUND(sum(adjustment),2) as adjustment"),
                    DB::raw("ROUND(SUM(grand_total + adjustment),2) as NetBalance")
                )
                    ->join('supplier', 'supplier.supplier_name', '=', 'purchase1.supplier_name')
                    ->where('purchase1.ClientID', '=', $client)
                    ->where('purchase1.supplier_name', '=', $supplier)
                    ->whereBetween('purchase_date', [$from, $to])
                    ->groupBy('ClientID')
                    ->groupBy('purchase_date')
                    ->groupBy('supplier_name')
                    ->get(),
            ];
    
            foreach ($data['totalPurchase'] as $pur) {
    
                $myArr[] = PurchaseOne::select(
                    'purchase1.ClientID',
                    'purchase_date',
                    'purchase1.supplier_name',
                    'invoice_date',
                    'invoice_no',
    
                    DB::raw("ROUND(SUM(grand_total + adjustment),2) as tot"),
                )
                    ->where('purchase1.supplier_name', '=', $supplier)
                    ->where('purchase1.ClientID', '=', $client)
                    ->whereBetween('purchase_date', [$from, $to])
                    ->get();
            }
    
            $loadcontent = '';
            // $multiInvoices = '';
            $num = 1;
    
            for ($i = 0; $i < Count($data['totalPurchase']); $i++) {
    
                // $loadcontent .= $data['totalPurchase'][$i]['supplier_name'] . '----' . $myArr[$i][0]['tot'];
    
                $multiInvoices[] = PurchaseOne::select(
    
                    'purchase_date',
                    'supplier_name',
    
                    'invoice_date',
    
                    'invoice_no',
    
                    DB::raw("ROUND(SUM(grand_total),2) as tot"),
                )
                    ->where('purchase1.supplier_name', '=', $supplier)
                    ->where('purchase1.ClientID', '=', $client)
                    ->whereBetween('purchase_date', [$from, $to])
                    ->groupBy('ClientID')
                    ->groupBy('purchase_date')
                    ->groupBy('supplier_name')
                    ->groupBy('invoice_no')
                    ->groupBy('invoice_date')
                    ->get();
    
                $loadcontent .= '<div class="accordion-item">
                <h2 class="accordion-header" id="headingOne">
    
                    <button 
                    
                    data-tableid="multiInvoiceSupplier' . $num . '"
                    data-supplier=" ' . $supplier . ' "
                    data-date=" ' . $data['from'] . ' "
                    data-client=" ' . $data['client'] . ' "
    
                    class="accordion-button collapsed accSupplierExp" type="button" data-bs-toggle="collapse" 
                    data-bs-target="#collapse' . $num . '" aria-expanded="false" aria-controls="collapse' . $num . '">
    
                        <div class="row col-12">
                        
                            <div class="col-3">
                                ' . $num . '
                            </div>
    
                            <div class="col-3">
                                ' . $data['totalPurchase'][$i]['supplier_name'] . ' 
                            </div>
    
    
                            <div class="col-3">
                                ' .  MainAcontroller::convertDate(substr($myArr[$i][0]['purchase_date'], 0, 10)) . '
                            </div>
      
                            <div class="col-3">
                                ₹ ' . $myArr[$i][0]['tot'] . '
                            </div>
      
                        </div>
      
                    </button>
      
                </h2>
    
                <div id="collapse' . $num . '" class="accordion-collapse collapse " aria-labelledby="headingOne">
                    
                    <div id="multiInvoiceSupplier' . $num . '"   class="accordion-body">
      
                    
                                    
                                    
                    
      
                    </div>
                </div>
      
                
            </div>';
    
                $num++;
            }
    
            $myData = [
                'content' => $loadcontent,
    
                'clientname' => Clients::where('ClientID', '=', $client)->pluck('ClientName'),
    
                'area' => Clients::where('ClientID', '=', $client)->pluck('Area'),
                'location' => Clients::where('ClientID', '=', $client)->pluck('Location'),
    
                'from' => $from,
                'to' => $to,
                // 'client' => $client,
                'client' => session('LoggedUser')['userid'],

                'supplier' => $supplier,
    
                'total' => PurchaseOne::select(DB::raw("ROUND(sum(grand_total + adjustment),2) as tot"))
                    ->whereBetween('purchase_date', [$from, $to])
                    ->where('ClientID', '=', $client)
                    ->where('supplier_name', '=', $supplier)
                    ->get()
            ];
        }

       

        // return $multiInvoices;

        return view('Admin.purchaseReportThree', $myData);
    }


    function viewPurchaseReportTwo($from, $to, $client, $supplier)
    {

        $cli = session('LoggedUser')['userid'];

        if ($supplier == 'null') {
            $data = [

                'clientname' => Clients::where('ClientID', '=', $cli)->pluck('ClientName'),

                'area' => Clients::where('ClientID', '=', $cli)->pluck('Area'),
                'location' => Clients::where('ClientID', '=', $cli)->pluck('Location'),

                'from' => $from,
                'to' => $to,
                'client' => $client,

                'supplier' => 'null',


                'permissions' => ActivityPurchasePermission::where('client_id', '=', $cli)
                    ->where('slug_url', '=', 'PURRPT')->get(),

                'totalPurchase' => PurchaseOne::select(
                    "purchase_date",
                    DB::raw("ROUND(SUM(grand_total + adjustment),2) as totalPurchase")
                )
                    ->where('ClientID', '=', $cli)
                    ->whereBetween('purchase_date', [$from, $to])
                    ->groupBy('purchase_date')
                    ->get(),

                'overallPurchase' => PurchaseOne::select(
                    DB::raw(" ROUND( (SUM(grand_total)) ,2) as overallPurchase ")
                )
                    ->where('ClientID', '=', $cli)
                    ->whereBetween('purchase_date', [$from, $to])->get(),

                'adjustment' => PurchaseOne::select(
                    DB::raw(" ROUND( (sum(adjustment)) ,2) as adjustment ")
                )
                    ->where('ClientID', '=', $cli)
                    ->whereBetween('purchase_date', [$from, $to])->get(),

                'NetBalance' => PurchaseOne::select(
                    DB::raw(" ROUND( (SUM(grand_total+adjustment)) ,2) as NetBalance ")
                )
                    ->where('ClientID', '=', $cli)
                    ->whereBetween('purchase_date', [$from, $to])->get(),


            ];
        } else {

            $data = [

                'clientname' => Clients::where('ClientID', '=', $client)->pluck('ClientName'),

                'area' => Clients::where('ClientID', '=', $client)->pluck('Area'),
                'location' => Clients::where('ClientID', '=', $client)->pluck('Location'),

                'from' => $from,
                'to' => $to,
                'client' => $client,

                'supplier' => $supplier,

                'permissions' => ActivityPurchasePermission::where('client_id', '=', $client)
                    ->where('slug_url', '=', 'PURRPT')->get(),

                'totalPurchase' => PurchaseOne::select(
                    "purchase_date",
                    DB::raw("ROUND(SUM(grand_total + adjustment),2) as totalPurchase")
                )
                    ->where('ClientID', '=', $client)
                    ->where('supplier_name', '=', $supplier)
                    ->whereBetween('purchase_date', [$from, $to])
                    ->groupBy('purchase_date')
                    ->get(),

                'overallPurchase' => PurchaseOne::select(
                    DB::raw(" ROUND( (SUM(grand_total)) ,2) as overallPurchase ")
                )
                    ->where('ClientID', '=', $client)
                    ->where('supplier_name', '=', $supplier)
                    ->whereBetween('purchase_date', [$from, $to])->get(),

                'adjustment' => PurchaseOne::select(
                    DB::raw(" ROUND( (sum(adjustment)) ,2) as adjustment ")
                )
                    ->where('ClientID', '=', $client)
                    ->where('supplier_name', '=', $supplier)
                    ->whereBetween('purchase_date', [$from, $to])->get(),

                'NetBalance' => PurchaseOne::select(
                    DB::raw(" ROUND( (SUM(grand_total+adjustment)) ,2) as NetBalance ")
                )
                    ->where('ClientID', '=', $client)
                    ->where('supplier_name', '=', $supplier)
                    ->whereBetween('purchase_date', [$from, $to])->get(),


            ];
        }



        // return $data;
        return view('Admin.purchaseReportTwo', $data);
    }

    function viewPurchaseReport(Request $request)
    {
        $client = session('LoggedUser')['userid'];
        $from = $request->from;
        $to = $request->to;
        $supplier = $request->supplier;

        if ($supplier == '') {
            $data = [
                'clientname' => Clients::where('ClientID', '=', $client)->pluck('ClientName'),

                'area' => Clients::where('ClientID', '=', $client)->pluck('Area'),
                'location' => Clients::where('ClientID', '=', $client)->pluck('Location'),

                'permissions' => ActivityPermission::where('client_id', '=', $client)
                    ->where('slug_url', '=', 'PURRPT')->get(),

                'from' => $from,
                'to' => $to,
                'client' => $client,

                'supplier' => 'null',

                'totalPurchase' => PurchaseOne::select(
                    DB::raw(" ROUND( (SUM(grand_total)) ,2) as total ")
                )
                    ->where('ClientID', '=', $client)
                    ->whereBetween('purchase_date', [$from, $to])->get(),


                'cashsale' => PurchaseOne::select(
                    DB::raw(" ROUND( (SUM(grand_total)) ,2) as cashsale")
                )
                    ->where('ClientID', '=', $client)
                    ->where('type', '=', 'd')
                    ->whereBetween('purchase_date', [$from, $to])
                    ->groupBy('ClientID')
                    ->get(),

                'creditsale' => PurchaseOne::select(
                    DB::raw(" ROUND( (SUM(grand_total)) ,2) as creditsale")
                )
                    ->where('ClientID', '=', $client)
                    ->where('type', '!=', 'd')
                    ->whereBetween('purchase_date', [$from, $to])
                    ->groupBy('ClientID')
                    ->get(),


                'adjustment' => PurchaseOne::select(
                    DB::raw(" ROUND( (sum(adjustment)) ,2) as adjustment ")
                )
                    ->where('ClientID', '=', $client)
                    ->whereBetween('purchase_date', [$from, $to])->get(),

                'NetBalance' => PurchaseOne::select(
                    DB::raw(" ROUND( (SUM(grand_total+adjustment)) ,2) as NetBalance ")
                )
                    ->where('ClientID', '=', $client)
                    ->whereBetween('purchase_date', [$from, $to])->get(),

            ];
        } else {

            $data = [
                'clientname' => Clients::where('ClientID', '=', $client)->pluck('ClientName'),

                'area' => Clients::where('ClientID', '=', $client)->pluck('Area'),
                'location' => Clients::where('ClientID', '=', $client)->pluck('Location'),

                'permissions' => ActivityPermission::where('client_id', '=', $client)
                    ->where('slug_url', '=', 'PURRPT')->get(),

                'from' => $from,
                'to' => $to,
                'client' => $client,

                'supplier' => $supplier,

                'totalPurchase' => PurchaseOne::select(
                    DB::raw(" ROUND( (SUM(grand_total)) ,2) as total ")
                )
                    ->where('ClientID', '=', $client)
                    ->where('supplier_name', '=', $supplier)
                    ->whereBetween('purchase_date', [$from, $to])->get(),


                'cashsale' => PurchaseOne::select(
                    DB::raw(" ROUND( (SUM(grand_total)) ,2) as cashsale")
                )
                    ->where('ClientID', '=', $client)
                    ->where('supplier_name', '=', $supplier)
                    ->where('type', '=', 'd')
                    ->whereBetween('purchase_date', [$from, $to])
                    ->groupBy('ClientID')
                    ->get(),

                'creditsale' => PurchaseOne::select(
                    DB::raw(" ROUND( (SUM(grand_total)) ,2) as creditsale")
                )
                    ->where('ClientID', '=', $client)
                    ->where('supplier_name', '=', $supplier)
                    ->where('type', '!=', 'd')
                    ->whereBetween('purchase_date', [$from, $to])
                    ->groupBy('ClientID')
                    ->get(),


                'adjustment' => PurchaseOne::select(
                    DB::raw(" ROUND( (sum(adjustment)) ,2) as adjustment ")
                )
                    ->where('ClientID', '=', $client)
                    ->where('supplier_name', '=', $supplier)
                    ->whereBetween('purchase_date', [$from, $to])->get(),

                'NetBalance' => PurchaseOne::select(
                    DB::raw(" ROUND( (SUM(grand_total+adjustment)) ,2) as NetBalance ")
                )
                    ->where('ClientID', '=', $client)
                    ->where('supplier_name', '=', $supplier)
                    ->whereBetween('purchase_date', [$from, $to])->get(),

            ];

            // return $data;
            // return view('Admin.purchaseReportOne', $data);
        }



        return view('Admin.purchaseReportOne', $data);
        // return  $data['creditsale'];


    }
}
