<?php

namespace App\Http\Controllers;

use App\Models\ActivityPermission;
use App\Models\Clients;
use App\Models\SalesOne;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\DB;
use PDF;

class SaleController extends Controller
{

    function searchPage($type)
    {
        $type1 = Crypt::decrypt($type);

        $data = [
            'type1' => $type1
        ];

        return view('Admin.searchPage', $data);
    }

    function saleviewThreeTypeDetails($from, $to, $type, $client)
    {
        if ($type == 'cash') {
            $data = [

                'clientname' => Clients::where('ClientID', '=', $client)->pluck('ClientName'),

                'billCount' => SalesOne::select(
                    DB::raw("COUNT(bill_no) as billcount")
                )
                    ->where('ClientID', '=', $client)
                    ->where('type', '=', 'D')
                    ->where('CCard', '=', '')
                    ->whereBetween('bill_date', [$from, $to])
                    ->get(),

                'typeSale' => SalesOne::select(
                    DB::raw(" 'cash' flg, bill_no,SUM(paid_amount) as amount ")
                )
                    ->where('ClientID', '=', $client)
                    ->where('type', '=', 'D')
                    ->where('CCard', '=', '')
                    ->whereBetween('bill_date', [$from, $to])
                    ->groupBy('sales1.bill_no')
                    ->get(),

                'totalsale' => SalesOne::select(
                    DB::raw(" ROUND( (SUM(paid_amount)) ,2) as saleamount")
                )
                    ->where('ClientID', '=', $client)
                    ->where('type', '=', 'D')
                    ->where('CCard', '=', '')
                    ->whereBetween('bill_date', [$from, $to])->get(),

                'type' => 'CASH',
                'from' => $from,
                'to' => $to,
            ];

            return view('Admin.saleThreeTypeDetails', $data);
        } else if ($type == 'credit') {
            $data = [

                'clientname' => Clients::where('ClientID', '=', $client)->pluck('ClientName'),

                'billCount' => SalesOne::select(
                    DB::raw("COUNT(bill_no) as billcount")
                )
                    ->where('ClientID', '=', $client)
                    ->where('type', '=', 'c')
                    ->whereBetween('bill_date', [$from, $to])
                    ->get(),

                'typeSale' => SalesOne::select(
                    DB::raw(" 'cash' flg, bill_no,SUM(grand_total) as amount ")
                )
                    ->where('ClientID', '=', $client)
                    ->where('type', '=', 'c')
                    ->whereBetween('bill_date', [$from, $to])
                    ->groupBy('sales1.bill_no')
                    ->get(),

                'totalsale' => SalesOne::select(
                    DB::raw(" ROUND( (SUM(grand_total)) ,2) as saleamount")
                )
                    ->where('ClientID', '=', $client)
                    ->where('type', '=', 'c')
                    ->whereBetween('bill_date', [$from, $to])->get(),

                'type' => 'CREDIT',
                'from' => $from,
                'to' => $to,
            ];

            // return $data;
            return view('Admin.saleThreeTypeDetails', $data);
        } else if ($type == 'card') {
            $data = [

                'clientname' => Clients::where('ClientID', '=', $client)->pluck('ClientName'),

                'billCount' => SalesOne::select(
                    DB::raw("COUNT(bill_no) as billcount")
                )
                    ->where('ClientID', '=', $client)
                    ->where('type', '=', 'D')
                    ->where('CCard', '!=', '')
                    ->whereBetween('bill_date', [$from, $to])
                    ->get(),

                'typeSale' => SalesOne::select(
                    DB::raw(" 'cash' flg, bill_no,SUM(CCardAmount) as amount ")
                )
                    ->where('ClientID', '=', $client)
                    ->where('type', '=', 'D')
                    ->where('CCard', '!=', '')
                    ->whereBetween('bill_date', [$from, $to])
                    ->groupBy('sales1.bill_no')
                    ->get(),

                'totalsale' => SalesOne::select(
                    DB::raw(" ROUND( (SUM(CCardAmount)) ,2) as saleamount")
                )
                    ->where('ClientID', '=', $client)
                    ->where('type', '=', 'D')
                    ->where('CCard', '!=', '')
                    ->whereBetween('bill_date', [$from, $to])->get(),

                'type' => 'CARD',
                'from' => $from,
                'to' => $to,
            ];

            // return $data;
            return view('Admin.saleThreeTypeDetails', $data);
        }
    }



    function viewTypeDetails($from, $to, $type, $client)
    {
        if ($type == 'cash') {
            $data = [

                'clientname' => Clients::where('ClientID', '=', $client)->pluck('ClientName'),

                'billCount' => SalesOne::select(
                    DB::raw("COUNT(bill_no) as billcount")
                )
                    ->where('ClientID', '=', $client)
                    ->where('type', '=', 'D')
                    ->where('CCard', '=', '')
                    ->whereBetween('bill_date', [$from, $to])
                    ->get(),

                'typeSale' => SalesOne::select(
                    DB::raw(" 'cash' flg, bill_no,SUM(paid_amount) as amount ")
                )
                    ->where('ClientID', '=', $client)
                    ->where('type', '=', 'D')
                    ->where('CCard', '=', '')
                    ->whereBetween('bill_date', [$from, $to])
                    ->groupBy('sales1.bill_no')
                    ->get(),

                'type' => 'CASH',
                'from' => $from,
                'to' => $to,
            ];

            // return $data;
            return view('Admin.saleTypeDetails', $data);
        } else if ($type == 'credit') {
            $data = [

                'clientname' => Clients::where('ClientID', '=', $client)->pluck('ClientName'),

                'billCount' => SalesOne::select(
                    DB::raw("COUNT(bill_no) as billcount")
                )
                    ->where('ClientID', '=', $client)
                    ->where('type', '=', 'c')
                    ->whereBetween('bill_date', [$from, $to])
                    ->get(),

                'typeSale' => SalesOne::select(
                    DB::raw(" 'cash' flg, bill_no,SUM(grand_total) as amount ")
                )
                    ->where('ClientID', '=', $client)
                    ->where('type', '=', 'c')
                    ->whereBetween('bill_date', [$from, $to])
                    ->groupBy('sales1.bill_no')
                    ->get(),

                'type' => 'CREDIT',
                'from' => $from,
                'to' => $to,
            ];

            // return $data;
            return view('Admin.saleTypeDetails', $data);
        } else if ($type == 'card') {
            $data = [

                'clientname' => Clients::where('ClientID', '=', $client)->pluck('ClientName'),

                'billCount' => SalesOne::select(
                    DB::raw("COUNT(bill_no) as billcount")
                )
                    ->where('ClientID', '=', $client)
                    ->where('type', '=', 'D')
                    ->where('CCard', '!=', '')
                    ->whereBetween('bill_date', [$from, $to])
                    ->get(),

                'typeSale' => SalesOne::select(
                    DB::raw(" 'cash' flg, bill_no,SUM(CCardAmount) as amount ")
                )
                    ->where('ClientID', '=', $client)
                    ->where('type', '=', 'D')
                    ->where('CCard', '!=', '')
                    ->whereBetween('bill_date', [$from, $to])
                    ->groupBy('sales1.bill_no')
                    ->get(),

                'type' => 'CARD',
                'from' => $from,
                'to' => $to,
            ];

            // return $data;
            return view('Admin.saleTypeDetails', $data);
        }
    }

    function getSaleActivityOne(Request $request)
    {

        $loadContent = '';

        $client = $request->shop;
        $from = $request->from;
        $to = $request->to;

        $noOfRecord = SalesOne::select(
            DB::raw("count(bill_no) as billno"),
            DB::raw("min(bill_no) as minbill"),
            DB::raw("max(bill_no) as maxbill"),
            DB::raw("SUM(grand_total) as tot"),
            DB::raw("SUM(paid_amount) as totnew"),
            "bill_date",
        )
            ->where('ClientID', '=', $client)
            ->whereBetween('bill_date', [$from, $to])
            ->groupBy('bill_date')
            ->get();

        $data = [

            'count' => $noOfRecord->count(),

            'clientname' => Clients::where('ClientID', '=', $client)->pluck('ClientName'),

            'area' => Clients::where('ClientID', '=', $client)->pluck('Area'),
            'location' => Clients::where('ClientID', '=', $client)->pluck('Location'),

            'permissions' => ActivityPermission::where('client_id', '=', $client)
                ->where('slug_url', '=', 'SALERPT')->get(),

            'from' => $from,
            'to' => $to,
            'client' => $client,

            'totalsale' => SalesOne::select(
                DB::raw(" ROUND( (SUM(grand_total)) ,2) as totalsale ")
            )
                ->where('ClientID', '=', $client)
                ->whereBetween('bill_date', [$from, $to])->get(),

            'cashsale' => DB::select("select SUM(paid_amount) as cash from sales1 where 1>0 
            and bill_date >='" . $from . "'
            and bill_date <='" . $to . "'
             and ClientID='" . $client . "' and  COALESCE(type,'')='D' and CCard=''"),

            'creditsale' => DB::select("select SUM(grand_total) as credit from sales1 where 1>0 
            and bill_date >='" . $from . "'
            and bill_date <='" . $to . "'
            and ClientID='" . $client . "' and  COALESCE(type,'')='c'"),

            'cardsale' => DB::select("select 'card' flg,SUM(CCardAmount) as card from sales1 where 1>0 
            and bill_date >='" . $from . "'
            and bill_date <='" . $to . "'
            and ClientID='" . $client . "' and  COALESCE(type,'')='D' and CCard<>''"),


            'splitwiseSale' => DB::select("select 'cash' flg,SUM(paid_amount) as cashtot from sales1 where 1>0 
            and bill_date >='" . $from . "'
            and bill_date <='" . $to . "'
             and ClientID='" . $client . "' and  COALESCE(type,'')='D' and CCard='' 


            UNION
            select 'credit' flg, SUM(grand_total) as credittot from sales1 where 1>0 
            and bill_date >='" . $from . "'
            and bill_date <='" . $to . "'
            and ClientID='" . $client . "' and  COALESCE(type,'')='c' 

            UNION 
            select 'card' flg,SUM(CCardAmount) as cardtot from sales1 where 1>0 
            and bill_date >='" . $from . "'
            and bill_date <='" . $to . "'
            and ClientID='" . $client . "' and  COALESCE(type,'')='D' and CCard<>''"),

            'billCount' => SalesOne::select(
                DB::raw(" COUNT(bill_no) as billCount")
            )
                ->where('ClientID', '=', $client)
                ->whereBetween('bill_date', [$from, $to])->get(),

            'startBill' => SalesOne::select(
                DB::raw(" MIN(bill_no) as startBill")
            )
                ->where('ClientID', '=', $client)
                ->whereBetween('bill_date', [$from, $to])->get(),

            'endBill' => SalesOne::select(
                DB::raw(" MAX(bill_no) as endBill")
            )
                ->where('ClientID', '=', $client)
                ->whereBetween('bill_date', [$from, $to])->get(),

        ];

        return json_encode($data);
    }

    function viewSaleReport(Request $request)
    {
        $client = session('LoggedUser')['userid'];
        $from = $request->from;
        $to = $request->to;

        $from_date = date("d", strtotime('-1 month', strtotime($from)));
        $from_month = date("m", strtotime('-1 month', strtotime($from)));
        $from_year = date("Y", strtotime('-1 month', strtotime($from)));


        $to_month = date("m", strtotime('-1 month', strtotime($to)));
        $to_year = date("Y", strtotime('-1 month', strtotime($to)));

        $d = cal_days_in_month(CAL_GREGORIAN, $to_month, $to_year);

        $new_from_date = $from_year . '-' . $from_month . '-' . $from_date;

        // $new_to_date = $from_year . '-' . $from_month . '-' . $d;
        $new_to_date = date('Y-m-d', strtotime('last day of last month',strtotime($to)));

        $trimedNewDate = substr($new_to_date,0,7);

        $trimmedDayOnly = substr($to,8,10);


        $noOfRecord = SalesOne::select(
            DB::raw("count(bill_no) as billno"),
            DB::raw("min(bill_no) as minbill"),
            DB::raw("max(bill_no) as maxbill"),
            DB::raw("SUM(grand_total) as tot"),
            DB::raw("SUM(paid_amount) as totnew"),
            "bill_date",
        )
            ->where('ClientID', '=', $client)
            ->whereBetween('bill_date', [$from, $to])
            ->groupBy('bill_date')
            ->get();

            // $datasss = [

            //     'from' => $new_from_date,
            //     'to' => $new_to_date,

            //     'noof' => cal_days_in_month(CAL_GREGORIAN, 2, 2016),

            //     'tomonth' => $to_month,

            //     'trimedNewDate' => $trimedNewDate.'-'.$trimmedDayOnly,
                
            // ];

        $data = [

            'count' => $noOfRecord->count(),

            'clientname' => Clients::where('ClientID', '=', $client)->pluck('ClientName'),

            'area' => Clients::where('ClientID', '=', $client)->pluck('Area'),
            'location' => Clients::where('ClientID', '=', $client)->pluck('Location'),

            'permissions' => ActivityPermission::where('client_id', '=', $client)
                ->where('slug_url', '=', 'SALERPT')->get(),

            'from' => $from,
            'to' => $to,
            'client' => $client,

            'totalsale' => SalesOne::select(
                DB::raw(" ROUND( (SUM(grand_total)) ,2) as totalsale ")
            )
                ->where('ClientID', '=', $client)
                ->whereBetween('bill_date', [$from, $to])->get(),

            'cashsale' => DB::select("select SUM(paid_amount) as cash from sales1 where 1>0 
            and bill_date >='" . $from . "'
            and bill_date <='" . $to . "'
             and ClientID='" . $client . "' and  COALESCE(type,'')='D' and CCard=''"),

            'creditsale' => DB::select("select SUM(grand_total) as credit from sales1 where 1>0 
            and bill_date >='" . $from . "'
            and bill_date <='" . $to . "'
            and ClientID='" . $client . "' and  COALESCE(type,'')='c'"),

            'cardsale' => DB::select("select 'card' flg,SUM(CCardAmount) as card from sales1 where 1>0 
            and bill_date >='" . $from . "'
            and bill_date <='" . $to . "'
            and ClientID='" . $client . "' and  COALESCE(type,'')='D' and CCard<>''"),


            'splitwiseSale' => DB::select("select 'cash' flg,SUM(paid_amount) as cashtot from sales1 where 1>0 
            and bill_date >='" . $from . "'
            and bill_date <='" . $to . "'
             and ClientID='" . $client . "' and  COALESCE(type,'')='D' and CCard='' 


            UNION
            select 'credit' flg, SUM(grand_total) as credittot from sales1 where 1>0 
            and bill_date >='" . $from . "'
            and bill_date <='" . $to . "'
            and ClientID='" . $client . "' and  COALESCE(type,'')='c' 

            UNION 
            select 'card' flg,SUM(CCardAmount) as cardtot from sales1 where 1>0 
            and bill_date >='" . $from . "'
            and bill_date <='" . $to . "'
            and ClientID='" . $client . "' and  COALESCE(type,'')='D' and CCard<>''"),

            'billCount' => SalesOne::select(
                DB::raw(" COUNT(bill_no) as billCount")
            )
                ->where('ClientID', '=', $client)
                ->whereBetween('bill_date', [$from, $to])->get(),

            'startBill' => SalesOne::select(
                DB::raw(" MIN(bill_no) as startBill")
            )
                ->where('ClientID', '=', $client)
                ->whereBetween('bill_date', [$from, $to])->get(),

            'endBill' => SalesOne::select(
                DB::raw(" MAX(bill_no) as endBill")
            )
                ->where('ClientID', '=', $client)
                ->whereBetween('bill_date', [$from, $to])->get(),

            'avgsale' => DB::select(" SELECT sum(grand_total)/count(DISTINCT bill_date) as nsum from sales1 
                WHERE bill_date>='" . $new_from_date . "' AND
                bill_date<='" . $new_to_date . "' and ClientID=" . $client . " ")

        ];


        return view('Admin.saleSearchOne', $data);
        // return  $data;
    }


    function viewSaleReportTwo($from, $to, $client)
    {

        $cli = session('LoggedUser')['userid'];
        // $cli = Crypt::decrypt($client);
        $fromdate = Crypt::decrypt($from);
        $todate = Crypt::decrypt($to);

        $noOfRecord = SalesOne::select(
            DB::raw("count(bill_no) as billno"),
            DB::raw("min(bill_no) as minbill"),
            DB::raw("max(bill_no) as maxbill"),
            DB::raw("SUM(grand_total) as tot"),
            DB::raw("SUM(paid_amount) as totnew"),
            "bill_date",
        )
            ->where('ClientID', '=', $cli)
            ->whereBetween('bill_date', [$fromdate, $todate])
            ->groupBy('bill_date')
            ->get();

        $data = [

            'count' => $noOfRecord->count(),

            'clientname' => Clients::where('ClientID', '=', $cli)->pluck('ClientName'),

            'area' => Clients::where('ClientID', '=', $cli)->pluck('Area'),
            'location' => Clients::where('ClientID', '=', $cli)->pluck('Location'),

            'from' => $fromdate,
            'to' => $todate,
            'client' => $cli,

            'permissions' => ActivityPermission::where('client_id', '=', $cli)
                ->where('slug_url', '=', 'SALERPT')->get(),

            'totalsale' => SalesOne::select(
                DB::raw("bill_date ,ROUND(SUM(grand_total),2) as totalSale,
                ROUND(SUM(paid_amount),2) as totnewSale,COUNT(bill_no) as billcount,MIN(bill_no) as first,MAX(bill_no) as last")
            )
                ->where('ClientID', '=', $cli)
                ->whereBetween('bill_date', [$fromdate, $todate])
                ->groupBy('sales1.bill_date')
                ->get(),

            'overallSale' => SalesOne::select(
                DB::raw(" ROUND( (SUM(grand_total)) ,2) as overallSale ")
            )
                ->where('ClientID', '=', $cli)
                ->whereBetween('bill_date', [$fromdate, $todate])->get(),


        ];

        // return $data;
        return view('Admin.saleSearchTwo', $data);
    }

    function viewSaleReportThree($from, $to, $client)
    {

        $clientz = session('LoggedUser')['userid'];

        $cashsale = SalesOne::select(
            DB::raw(" 'cash' flg, bill_no,paid_amount as amount ")
        )
            ->where('ClientID', '=', $clientz)
            ->where('type', '=', 'D')
            ->where('CCard', '=', '')
            ->whereBetween('bill_date', [$from, $to])

            ->get();

        $creitsale = SalesOne::select(
            DB::raw(" 'credit' flg, bill_no,grand_total as amount ")
        )
            ->where('ClientID', '=', $clientz)
            ->where('type', '=', 'c')
            ->whereBetween('bill_date', [$from, $to])

            ->get();

        $cardsale = SalesOne::select(
            DB::raw(" 'card' flg, bill_no,CCardAmount as amount ")
        )

            ->where('ClientID', '=', $clientz)
            ->where('type', '=', 'D')
            ->where('CCard', '!=', '')
            ->whereBetween('bill_date', [$from, $to])

            ->get();

        $allItems = new \Illuminate\Database\Eloquent\Collection;

        $allItems = $allItems->concat($cashsale);
        $allItems = $allItems->concat($creitsale);
        $allItems = $allItems->concat($cardsale);


        $data = [

            'clientname' => Clients::where('ClientID', '=', $clientz)->pluck('ClientName'),

            'area' => Clients::where('ClientID', '=', $clientz)->pluck('Area'),
            'location' => Clients::where('ClientID', '=', $clientz)->pluck('Location'),

            'from' => $from,
            'to' => $to,
            'client' => $clientz,

            'permissions' => ActivityPermission::where('client_id', '=', $clientz)
                ->where('slug_url', '=', 'SALERPT')->get(),

            'allsales' => $allItems,

            // card values  
            'cashsale' => SalesOne::select(
                DB::raw(" ROUND( (SUM(paid_amount)) ,2) as totalcashsale")
            )
                ->where('ClientID', '=', $clientz)
                ->where('type', '=', 'D')
                ->where('CCard', '=', '')
                ->whereBetween('bill_date', [$from, $to])->get(),

            'creditsale' => SalesOne::select(
                DB::raw(" ROUND( (SUM(grand_total)) ,2) as totalcreditsale")
            )
                ->where('ClientID', '=', $clientz)
                ->where('type', '=', 'c')
                ->whereBetween('bill_date', [$from, $to])->get(),

            'cardsale' => SalesOne::select(
                DB::raw(" ROUND( (SUM(CCardAmount)) ,2) as totalcardsale")
            )
                ->where('ClientID', '=', $clientz)
                ->where('type', '=', 'D')
                ->where('CCard', '!=', '')
                ->whereBetween('bill_date', [$from, $to])->get(),

            'billCount' => SalesOne::select(
                DB::raw(" COUNT(bill_no) as billCount")
            )
                ->where('ClientID', '=', $clientz)
                ->whereBetween('bill_date', [$from, $to])->get(),


            'startBill' => SalesOne::select(
                DB::raw(" MIN(bill_no) as startBill")
            )
                ->where('ClientID', '=', $clientz)
                ->whereBetween('bill_date', [$from, $to])->get(),

            'endBill' => SalesOne::select(
                DB::raw(" MAX(bill_no) as endBill")
            )
                ->where('ClientID', '=', $clientz)
                ->whereBetween('bill_date', [$from, $to])->get(),
            // card values close


        ];

        return view('Admin.saleSearchThree', $data);
        // return $data;
    }
}
