<?php

namespace App\Http\Controllers;

use App\Models\Clients;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class StockTransferController extends Controller
{
    function editStockTransferReport(Request $request)
    {
        $clien = session('LoggedUser')['userid'];

        $data = [

            'client' => $clien,
            'clientname' => Clients::where('ClientID', '=', $clien)->pluck('ClientName'),
            'area' => Clients::where('ClientID', '=', $clien)->pluck('Area'),
            'location' => Clients::where('ClientID', '=', $clien)->pluck('Location'),

            'editstock' => DB::select("select edt.Edit_date,edt.transfer_no as edttransfer_no,edt.clientid as edtClientID,Branch as edtbranch,edt.type as edttype,sum((round((sale_rate/pack),3)*quantity)) as edtamount 
            from edit_transfer1 edt 
               left join edit_transfer_item1 edti on edt.transfer_no = edti.transfer_no 
           and edt.Clientid = edti.Clientid and edt.type = edti.type and edt.edit_id = edti.edit_id 
               where edt.ClientID = '182' and edt.Edit_date >= ' ".$request->from." ' and edt.Edit_date <= '  ".$request->to." '
           group by edt.transfer_no,edt.ClientID,Branch,edt.Type"),

        ];

        // return $data;

        $loadcontent = '';

        $num = 1;

        foreach ($data['editstock'] as $cli) {

            $loadcontent .= '<div class="accordion-item">
            <h2 class="accordion-header" id="headingOne">

                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" 
                data-bs-target="#collapse' . $num . '" aria-expanded="false" aria-controls="collapse' . $num . '">

                    <div class="row col-12">
                    
                        <div class="col-2">
                            ' . $num . '
                        </div>

                        <div class="col-2">
                            ' . $cli->edttransfer_no . ' 
                        </div>

  
                        <div class="col-2">
                            ' . $cli->edtbranch . '
                        </div>

                        <div class="col-2">
                        ' . MainAcontroller::convertDate($cli->Edit_date)  . '
                        </div>

                    
                        ';

                        if($cli->edttype == 'I')
                        {
                            $loadcontent .= '<div class="col-2"> <span class="badge bg-success"> Inward </span> </div>';
                        }
                        else
                        {
                            $loadcontent .= '<div class="col-2"> <span class="badge bg-danger"> Outward </span> </div>';
                        }
                        
                        
                       $loadcontent .= ' <div class="col-2">
                        ' . $cli->edtamount . '
                        </div>

  
                    </div>
  
                </button>
  
            </h2>
  
            <div id="collapse' . $num . '" class="accordion-collapse collapse " aria-labelledby="headingOne" 
            >
                <div class="accordion-body">
  
                <table id="" class="table table-striped table-bordered" style="width:100%">
								<thead>
									<tr>
										<th>Sl No</th>
										<th>Transfer No</th>
										<th>Invoice No</th>
										<th>Branch</th>
										<th>Type</th>
										<th>Amount</th>
										<th>Edit Amount</th>
										
									</tr>
								</thead>
								<tbody>';

            $loadcontent .= $this->addTableRows( $clien,$request->from,$request->to,$cli->edttransfer_no,$cli->edttype );
            $loadcontent .= '</tbody>
								
							</table>
  
                </div>
            </div>
        </div>';
            $num++;
        }

        $myArr = [
            'content' => $loadcontent,
            'data' => $data,
        ];

        return view('Admin.editStockTransfer', $myArr);
    }

    function addTableRows($client,$from,$to,$transfer,$type)
    {

       $resArray = DB::select("select Clientid,transfer_no,Branch,invoice_no,Type,amount,edtamount,edit_id from (

        select t.transfer_date,t.transfer_no,t.clientid as ClientID,Branch,Invoice_No,t.type as type,sum((round((sale_rate/pack),3)*quantity)) as amount 
         from transfer1 t left join transfer_item1 ti on t.transfer_no = ti.transfer_no 
        and t.Clientid = ti.Clientid and t.type = ti.type 
        group by t.transfer_no,t.clientid,Branch,Invoice_No,t.type
        )tr left join (
            
            select edt.edit_id,edt.transfer_no as edttransfer_no,edt.clientid as edtClientID,Branch as edtbranch,edt.type as edttype,sum((round((sale_rate/pack),3)*quantity)) as edtamount 
         from edit_transfer1 edt 
            left join edit_transfer_item1 edti on edt.transfer_no = edti.transfer_no 
        and edt.Clientid = edti.Clientid and edt.type = edti.type and edt.edit_id = edti.edit_id 
            where edt.ClientID = '".$client."' and edt.Edit_date >= '".$from."' and edt.Edit_date <= '".$to."' 
            and edt.Transfer_no = ".$transfer." and edt.type = '".$type."'
        group by edt.transfer_no,edt.clientid,Branch,edt.type,edit_id
            
        )edttr on tr.clientid = edttr.edtClientID and tr.transfer_no = edttr.edttransfer_no and tr.type= edttr.edttype
        where amount <> edtamount");

        $load = '';

        $slno = 1;
        foreach ($resArray as $res) {
            $load .= '<tr>
        <td>' . $slno . '</td>
        <td> ' . $transfer . ' </td>
        <td>' . $res->invoice_no . '</td>
        <td>' . $res->Branch . '</td>
        <td>' . $res->Type . '</td>
        <td>' . $res->amount . '</td>
        <td>' . $res->edtamount . '</td>
    </tr>';
            $slno++;
        }

        return $load;
    }
}
