@extends('Admin.Layouts.master')

@section('content')

<div class="card">
    <div class="card-body">

        @if ($message = Session::get('success'))
        <div class="alert border-0 bg-light-success alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-success"><i class="bi bi-check-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-success">{{ $message }}</div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        @if ($message = Session::get('fail'))
        <div class="alert border-0 bg-light-danger alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-danger"><i class="bi bi-x-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-danger">
                        {{$message}}
                    </div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="ps-3">
                <h6 class="mb-0 text-uppercase">Purchase Orders</h6>
            </div>
            <div hidden class="ms-auto">
                <div class="btn-group">
                    <a href="{{ route('web.createnewuser') }}" class="btn btn-primary"> <i class="fadeIn animated bx bx-image-add"></i> Create User </a>
                </div>
            </div>
        </div>


        <hr />

        <div class="table-responsive">
            <table data-page-length='10' id="example2" class="table table-striped table-bordered">
                <thead class="table-secondary">
                    <tr>
                        <th>Sl No</th>
                        <th>Order Number</th>
                        <th>Order Date</th>
                        <th>Supplier</th>
                        <th>Delete Status</th>

                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php

                    $num = 1; ?>
                    @foreach( $orders as $od )
                    <tr>
                        <td>{{ $num }}</td>

                        <td> {{ $od->OrderNo  }} </td>
                        <td> {{ $od->OrderDate  }} </td>
                        <td> {{ $od->Supplier  }} </td>
                        
                        <td> {{ $od->del_status  }} </td>


                        <td>


                            <div class="col">
                                <div class="dropdown">
                                    <button class="btn btn-primary dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">Actions</button>
                                    <ul class="dropdown-menu">


                                        <li><a class="dropdown-item" href="">App Permissions</a>
                                        </li>

                                    </ul>
                                </div>
                            </div>

                        </td>
                    </tr>
                    <?php $num++; ?>
                    @endforeach

                </tbody>
            </table>
        </div>
    </div>
</div>

@endsection