@extends('Admin.Layouts.master')

@section('content')

<?php

use App\Http\Controllers\MainAcontroller; ?>


<div class="card">
    <div class="card-body">

        @if ($message = Session::get('success'))
        <div class="alert border-0 bg-light-success alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-success"><i class="bi bi-check-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-success">{{ $message }}</div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        @if ($message = Session::get('fail'))
        <div class="alert border-0 bg-light-danger alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-danger"><i class="bi bi-x-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-danger">
                        {{$message}}
                    </div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        <h6 class="mb-0 text-uppercase text-center">{{ $clientname[0] }} <br> {{ $area[0] }} , {{ $location[0] }} <br> <?php echo "CASH CLOSING REPORT " . (MainAcontroller::convertDate($from)) ?> TO <?php echo (MainAcontroller::convertDate($to)) ?> </h6>
        <hr />

        <div class="table-responsive">
            <table data-page-length='15' id="example2" class="table table-striped table-bordered">
                <thead class="table-secondary">
                    <tr>
                        <th>Sl No</th>
                        <th>Date</th>
                        <th>PRE Denomination</th>
                        <th>OPN Balance</th>
                        <th>Cash Sales</th>
                        <th>Credit Sales</th>
                        <th>Card Sales</th>
                        <th>SR Amount</th>
                        <th>PAID Amount</th>
                        <th>Denomination</th>

                        <!-- <th>Action</th> -->
                    </tr>
                </thead>
                <tbody>
                    <?php  $num = 1; ?>
                    @foreach($total as $client)
                    <tr>
                        <td>{{ $num }}</td>

                        <td> <?php echo (MainAcontroller::convertDate($client->dt)) ?>  </td>
                        <td>{{ $client->PrevDenTotal }} </td>
                        <td>{{ $client->OpAmount }}</td>
                        <td>{{ $client->CashSales }}</td>
                        <td>{{ $client->CreditSales }}</td>
                        <td>{{ $client->CardSales }}</td>
                        <td>{{ $client->SRAmount }}</td>
                        <td>{{ $client->Paid }}</td>
                        <td>{{ $client->DenominationAmt }}</td>



                        <!-- <td>
                            <div class="table-actions d-flex align-items-center gap-3 fs-6">

                                <a href="#" style="background: transparent;" type="submit" class="text-success" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Web Permissions"> <i class="fadeIn animated bx bx-shield-quarter"></i> </a>

                            </div>
                        </td> -->
                    </tr>
                    <?php $num++; ?>
                    @endforeach

                </tbody>
            </table>
        </div>
    </div>
</div>

<script>
    $(document).ready(function() {
        $(".clickToView").click(function() {


            $('#modalClientDetails').modal('show');

        });
    });
</script>
@endsection