@extends('Admin.Layouts.master')

@section('content')
<div class="card">
    <div class="card-body">

        @if ($message = Session::get('success'))
        <div class="alert border-0 bg-light-success alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-success"><i class="bi bi-check-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-success">{{ $message }}</div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        @if ($message = Session::get('fail'))
        <div class="alert border-0 bg-light-danger alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-danger"><i class="bi bi-x-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-danger">
                        {{$message}}
                    </div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        <div class="border p-4 rounded">
            <div class="card-title d-flex align-items-center">
                <h5 class="mb-0">Create Banner</h5>
            </div>
            <hr />

            <form method="post" action="{{ route('web.uploadBanner') }}" enctype="multipart/form-data">
                @csrf

                @if(session('LoggedUser')['userRole'] == 'admin')
                <div class="row mb-3">
                    <label for="inputPhoneNo2" class="col-sm-3 col-form-label">Client Names </label>
                    <div class="col-sm-9">
                        <select required name="b_client" type="text" class="single-select" id="bannerSelectShops" placeholder="">
                            <option value=""> Choose one </option>
                        </select>
                    </div>
                </div>
                @endif


                <div class="row mb-3">
                    <label for="inputEnterYourName" class="col-sm-3 col-form-label">Banner Image</label>
                    <div class="col-sm-9">
                        <input name="banner" type="file" required class="form-control" id="inputEnterYourName">
                    </div>
                </div>

                <div class="row mb-3">
                    <label for="inputAddress4" class="col-sm-3 col-form-label">Banner Description</label>
                    <div class="col-sm-9">
                        <textarea required name="b_desc" class="form-control" id="inputAddress4" rows="3" placeholder="enter banner description"></textarea>
                    </div>
                </div>

                <div class="row mb-3">
                    <label for="inputEnterYourName" class="col-sm-3 col-form-label">From Date</label>
                    <div class="col-sm-9">
                        <input name="b_from" type="date" required class="form-control" id="inputEnterYourName">
                    </div>
                </div>

                <div class="row mb-3">
                    <label for="inputEnterYourName" class="col-sm-3 col-form-label">To Date</label>
                    <div class="col-sm-9">
                        <input name="b_to" type="date" required class="form-control" id="inputEnterYourName">
                    </div>
                </div>

                <div class="row mb-3">
                    <label for="inputPhoneNo2" class="col-sm-3 col-form-label">Banner Status </label>
                    <div class="col-sm-9">
                        <select required name="b_status" type="text" class="form-control" id="inputPhoneNo2" placeholder="">
                            <option value=""> Choose one </option>
                            <option value="1"> Active </option>
                            <option value="0"> Inactive </option>
                        </select>
                    </div>
                </div>

                <div class="row">
                    <label class="col-sm-3 col-form-label"></label>
                    <div class="col-sm-9">
                        <button type="submit" class="btn btn-primary px-5">Create</button>
                    </div>
                </div>


            </form>

        </div>





    </div>
</div>

<script>
    $(document).ready(function() {

        $(".showImageLarge").click(function() {

            var id = $(this).data('path');
            document.getElementById("bannerLargeImage").src = id;
            $('#exampleLargeBanner').modal('show');

        });

        $.ajax({
            type: "GET",
            dataType: "json",
            url: "{{ route('web.getAllClients') }}",

            success: function(data) {

                $("#bannerSelectShops").empty();

                $('#bannerSelectShops')
                    .append($("<option></option>")
                        .attr("value", "")
                        .text("Choose one"));

                $.each(data, function(index, value) {

                    $('#bannerSelectShops')
                        .append($("<option></option>")
                            .attr("value", value.ClientID)
                            .text(value.ClientName + "|" + value.ClientID + "|" + value.Area + "|" + value.Location))

                });

            }
        });

    });
</script>
@endsection