<?php

use App\Http\Controllers\MainAcontroller;
use App\Http\Controllers\GeneralController; ?>



@extends('Admin.Layouts.master-dashboard')

@section('content')

<!-- <div class="row row-cols-1 row-cols-lg-2 row-cols-xl-2 row-cols-xxl-4"> -->

@if ($message = Session::get('success'))
<div class="alert border-0 bg-light-success alert-dismissible fade show py-2 success">
    <div class="d-flex align-items-center">
        <div class="fs-3 text-success"><i class="bi bi-check-circle-fill"></i>
        </div>
        <div class="ms-3">
            <div class="text-success">{{ $message }}</div>
        </div>
    </div>
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
</div>
@endif

@if ($message = Session::get('fail'))
<div class="alert border-0 bg-light-danger alert-dismissible fade show py-2">
    <div class="d-flex align-items-center">
        <div class="fs-3 text-danger"><i class="bi bi-x-circle-fill"></i>
        </div>
        <div class="ms-3">
            <div class="text-danger">
                {{$message}}
            </div>
        </div>
    </div>
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
</div>
@endif



@if(session('LoggedUser')['userRole'] == "admin")


<!-- <label class="text-danger"> <?php echo GeneralController::checkIsAssignedToAnyAnotherShop(1993); ?> </label> -->

<div class="row row-cols-1 row-cols-lg-2 row-cols-xl-2 row-cols-xxl-4">



    <div class="col">
        <div class="card radius-10">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="">
                        <p class="mb-1">Clients Management</p>
                        <h4 class="mb-0 text-danger"> {{ $clients }} </h4>
                    </div>
                    <div class="ms-auto fs-2 text-danger">
                        <i class="fadeIn animated bx bx-buildings"></i>
                    </div>
                </div>
                <hr class="my-2">
                <a href="{{ route('web.manageClientsNew','A') }}">manage clients</a>
                <i class="fadeIn animated bx bx-chevron-right-circle"></i>
            </div>
        </div>
    </div>

    <div class="col">
        <div class="card radius-10">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="">
                        <p class="mb-1">Users Management</p>
                        <h4 class="mb-0 text-primary"> {{ $users }} </h4>
                    </div>
                    <div class="ms-auto fs-2 text-primary">
                        <i class="fadeIn animated bx bx-store-alt"></i>
                    </div>
                </div>
                <hr class="my-2">
                <a href="{{ route('web.manageUsers') }}">manage users</a>
                <i class="fadeIn animated bx bx-chevron-right-circle"></i>
            </div>
        </div>
    </div>

    <div hidden class="col">
        <div class="card radius-10">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="">
                        <p class="mb-1">Loggined Users</p>
                        <h4 class="mb-0 text-primary"> {{ $logginedusers }} </h4>
                    </div>
                    <div class="ms-auto fs-2 text-primary">
                        <i class="fadeIn animated bx bx-store-alt"></i>
                    </div>
                </div>
                <hr class="my-2">
                <a href="{{ route('web.manageLogginedUsers') }}">manage users</a>
                <i class="fadeIn animated bx bx-chevron-right-circle"></i>
            </div>
        </div>
    </div>

    <div class="col">
        <div class="card radius-10">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="">
                        <p class="mb-1">Customer App Users</p>
                        <h4 class="mb-0 text-primary"> {{ $customerappusers }} </h4>
                    </div>
                    <div class="ms-auto fs-2 text-primary">
                        <i class="fadeIn animated bx bx-store-alt"></i>
                    </div>
                </div>
                <hr class="my-2">
                <a href="{{ route('web.customerappusers') }}">view users</a>
                <i class="fadeIn animated bx bx-chevron-right-circle"></i>
            </div>
        </div>
    </div>

    <div class="col">
        <div class="card radius-10">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="">
                        <p class="mb-1">Clients without users</p>
                        <h4 class="mb-0 text-primary"> {{ $clientwithoutusercount[0]->userCount }} </h4>
                    </div>
                    <div class="ms-auto fs-2 text-primary">
                        <i class="fadeIn animated bx bx-store-alt"></i>
                    </div>
                </div>
                <hr class="my-2">
                <a href="#clientsWithoutUsers">View Clients</a>
                <i class="fadeIn animated bx bx-chevron-right-circle"></i>
            </div>
        </div>
    </div>


</div>


<div class="row row-cols-1 row-cols-lg-2 row-cols-xl-2 row-cols-xxl-4">

    @foreach($packusers as $user)

    @if($user->Pack_Slug == 'platinum')
    <div class="col">
        <div class="card overflow-hidden radius-10">
            <div class="card-body p-2">
                <div class="d-flex align-items-stretch justify-content-between radius-10 overflow-hidden">
                    <div class="w-50 p-3 bg-light-primary">
                        <p>Platinum</p>
                        <h4 class="text-primary">{{ $user->pack }} User's</h4>
                        <a href="{{ route('web.showusersbyPackage',Crypt::encrypt($user->packid) ) }}">See all</a>
                    </div>
                    <div class="w-50 bg-primary p-3 text-center">
                        <!-- <p class="mb-3 text-white">+ 16% <i class="bi bi-arrow-up"></i></p>
                        <div id="chart1"></div> -->
                        <img width="100px" height="100px" src="https://medisoftapps.digitronicsindia.com/medisoft/public/uploads/platinum.png">
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endif

    @if($user->Pack_Slug == 'gold')
    <div class="col">
        <div class="card overflow-hidden radius-10">
            <div class="card-body p-2">
                <div class="d-flex align-items-stretch justify-content-between radius-10 overflow-hidden">
                    <div class="w-50 p-3 bg-light-primary">
                        <p>Gold</p>
                        <h4 class="text-primary">{{ $user->pack }} User's</h4>
                        <a href="{{ route('web.showusersbyPackage',Crypt::encrypt($user->packid) ) }}">See all</a>
                    </div>
                    <div class="w-50 bg-primary p-3 text-center">
                        <!-- <p class="mb-3 text-white">+ 16% <i class="bi bi-arrow-up"></i></p>
                        <div id="chart1"></div> -->
                        <img width="100px" height="100px" src="https://medisoftapps.digitronicsindia.com/medisoft/public/uploads/gold.png">
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endif

    @if($user->Pack_Slug == 'silver')
    <div class="col">
        <div class="card overflow-hidden radius-10">
            <div class="card-body p-2">
                <div class="d-flex align-items-stretch justify-content-between radius-10 overflow-hidden">
                    <div class="w-50 p-3 bg-light-primary">
                        <p>Silver</p>
                        <h4 class="text-primary">{{ $user->pack }} User's</h4>
                        <a href="{{ route('web.showusersbyPackage',Crypt::encrypt($user->packid) ) }}">See all</a>
                    </div>
                    <div class="w-50 bg-primary p-3 text-center">
                        <!-- <p class="mb-3 text-white">+ 16% <i class="bi bi-arrow-up"></i></p>
                        <div id="chart1"></div> -->
                        <img width="100px" height="100px" src="https://medisoftapps.digitronicsindia.com/medisoft/public/uploads/silver.png">
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endif

    @if($user->Pack_Slug == 'employe')
    <div class="col">
        <div class="card overflow-hidden radius-10">
            <div class="card-body p-2">
                <div class="d-flex align-items-stretch justify-content-between radius-10 overflow-hidden">
                    <div class="w-50 p-3 bg-light-primary">
                        <p>Staff Users</p>
                        <h4 class="text-primary">{{ $user->pack }} User's</h4>
                        <a href="{{ route('web.showusersbyPackage',Crypt::encrypt($user->packid) ) }}">See all</a>
                    </div>
                    <div class="w-50 bg-primary p-3 text-center">
                        <!-- <p class="mb-3 text-white">+ 16% <i class="bi bi-arrow-up"></i></p>
                        <div id="chart1"></div> -->
                        <img width="100px" height="100px" src="https://medisoftapps.digitronicsindia.com/medisoft/public/uploads/bronze.png">
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endif


    @endforeach

</div>

<div class="row row-cols-2 row-cols-sm-3 row-cols-md-4 row-cols-xl-6 row-cols-xxl-6">

    <div class="col">
        <div class="card radius-10 bg-danger">
            <div class="card-body text-center">
                <div class="widget-icon mx-auto mb-3 bg-white-1 text-white">
                    <i class="bi bi-hdd-fill"></i>
                </div>
                <h3 class="text-white"> {{ $noactive }} </h3>
                <p class="mb-0 text-white">No Active Pack </p>
            </div>
        </div>
    </div>

    <div class="col">
        <div class="card radius-10 bg-tiffany">
            <div class="card-body text-center">
                <div class="widget-icon mx-auto mb-3 bg-white-1 text-white">
                    <i class="bi bi-chat-left-fill"></i>
                </div>
                <h3 class="text-white">{{ $trial }}</h3>
                <p class="mb-0 text-white">Trial</p>
            </div>
        </div>
    </div>

    <div class="col">
        <div class="card radius-10 bg-success">
            <div class="card-body text-center">
                <div class="widget-icon mx-auto mb-3 bg-white-1 text-white">
                    <i class="bi bi-people-fill"></i>
                </div>
                <h3 class="text-white">{{ $active }}</h3>
                <p class="mb-0 text-white">Active Pack</p>
            </div>
        </div>
    </div>

</div>

<!-- show table for un used clients -->
                <h6 class="mb-0 text-uppercase">Clients without user account</h6>
				<hr/>
				<div id="clientsWithoutUsers" class="card">
					<div class="card-body">
						<div class="table-responsive">
							<table id="example2" class="table table-striped table-bordered">
								<thead>
									<tr>
										<th>Sl No</th>
										<th>Client</th>
										<th>Address</th>
										<th>Phone / Email</th>
									</tr>
								</thead>
								<tbody>
                                    <?php $num = 1; ?>
                                    @foreach($clientwithoutuser as $cli)
									<tr>
										<td>{{ $num }}</td>
										<td> <label class="text-danger"> {{ $cli->ClientID }} </label> - {{ $cli->ClientName }}</td>
										<td> {{ $cli->Address1 }} <br> {{ $cli->Address2 }} <br> {{ $cli->Address3 }}  </td>
										<td> {{ $cli->Phone }} <br> {{ $cli->Email }}  </td>
										
									</tr>
                                    <?php $num++; ?>
                                    @endforeach
								</tbody>
								
							</table>
						</div>
					</div>
				</div>
<!-- show table for un used clients close -->



@elseif(session('LoggedUser')['userRole'] == "shop")

<?php

$sale = 'sale';
$stock = 'stock';
$purchase = 'purchase';
$edit = 'edit';
$login = 'login';
$cashclose = 'cashclose';
$edtstktrnsfrrpt = 'edtstktrnsfrrpt';

?>

@if($slug['Pack_Name'] == 'PLATINUM')
<div class="col-4">
    <div class="card overflow-hidden radius-10">
        <div class="card-body p-2">
            <div class="d-flex align-items-stretch justify-content-between radius-10 overflow-hidden">
                <div class="w-50 p-3 bg-light-primary">
                    <!-- <p></p> -->
                    <h4 class="text-primary"> PLATINUM </h4>

                    <p> <?php echo MainAcontroller::getFromDateForTrial($userid) ?> to <?php echo MainAcontroller::getToDateForTrial($userid) ?> </p>

                    <p> <?php

                        if (GeneralController::daysleftDateOnly(MainAcontroller::getToDateForTrial($userid)) <= 10) {
                        ?>
                            <label class="text-danger"> <?php echo GeneralController::daysleftDateOnly(MainAcontroller::getToDateForTrial($userid)) ?> days left to expire </label>
                            <a class="btn btn-primary">pay Now</a>
                        <?php
                        } else if (GeneralController::daysleftDateOnly(MainAcontroller::getToDateForTrial($userid))  > 10) {
                        ?>
                            <label class="text-success"> <?php echo GeneralController::daysleftDateOnly(MainAcontroller::getToDateForTrial($userid)) ?> days left </label>
                        <?php
                        }


                        ?>
                    </p>



                </div>
                <div class="w-50 bg-primary p-3 text-center">
                    <!-- <p class="mb-3 text-white">+ 16% <i class="bi bi-arrow-up"></i></p>
                        <div id="chart1"></div> -->
                    <img width="100px" height="100px" src="https://medisoftapps.digitronicsindia.com/medisoft/public/uploads/platinum.png">
                </div>
            </div>
        </div>
    </div>
</div>
@endif

@if($slug['Pack_Name'] == 'GOLD')
<div class="col">
    <div class="card overflow-hidden radius-10">
        <div class="card-body p-2">
            <div class="d-flex align-items-stretch justify-content-between radius-10 overflow-hidden">
                <div class="w-50 p-3 bg-light-primary">
                    <!-- <p></p> -->
                    <h4 class="text-primary"> GOLD </h4>

                    <p> <?php echo MainAcontroller::getFromDateForTrial($userid) ?> to <?php echo MainAcontroller::getToDateForTrial($userid) ?> </p>

                    <p> <?php

                        if (GeneralController::daysleftDateOnly(MainAcontroller::getToDateForTrial($userid)) <= 10) {
                        ?>
                            <label class="text-danger"> <?php echo GeneralController::daysleftDateOnly(MainAcontroller::getToDateForTrial($userid)) ?> days left to expire </label>
                        <?php
                        } else if (GeneralController::daysleftDateOnly(MainAcontroller::getToDateForTrial($userid))  > 10) {
                        ?>
                            <label class="text-success"> <?php echo GeneralController::daysleftDateOnly(MainAcontroller::getToDateForTrial($userid)) ?> days left </label>
                        <?php
                        }




                        ?>
                    </p>

                </div>
                <div class="w-50 bg-primary p-3 text-center">
                    <!-- <p class="mb-3 text-white">+ 16% <i class="bi bi-arrow-up"></i></p>
                        <div id="chart1"></div> -->
                    <img width="100px" height="100px" src="https://medisoftapps.digitronicsindia.com/medisoft/public/uploads/gold.png">
                </div>
            </div>
        </div>
    </div>
</div>
@endif

@if($slug['Pack_Name'] == 'SILVER')
<div class="col">
    <div class="card overflow-hidden radius-10">
        <div class="card-body p-2">
            <div class="d-flex align-items-stretch justify-content-between radius-10 overflow-hidden">
                <div class="w-50 p-3 bg-light-primary">
                    <!-- <p></p> -->
                    <h4 class="text-primary"> SILVER </h4>

                    <p> <?php echo MainAcontroller::getFromDateForTrial($userid) ?> to <?php echo MainAcontroller::getToDateForTrial($userid) ?> </p>

                    <p> <?php

                        if (GeneralController::daysleftDateOnly(MainAcontroller::getToDateForTrial($userid)) <= 10) {
                        ?>
                            <label class="text-danger"> <?php echo GeneralController::daysleftDateOnly(MainAcontroller::getToDateForTrial($userid)) ?> days left to expire </label>
                        <?php
                        } else if (GeneralController::daysleftDateOnly(MainAcontroller::getToDateForTrial($userid))  > 10) {
                        ?>
                            <label class="text-success"> <?php echo GeneralController::daysleftDateOnly(MainAcontroller::getToDateForTrial($userid)) ?> days left </label>
                        <?php
                        }




                        ?>
                    </p>

                </div>
                <div class="w-50 bg-primary p-3 text-center">
                    <!-- <p class="mb-3 text-white">+ 16% <i class="bi bi-arrow-up"></i></p>
                        <div id="chart1"></div> -->
                    <img width="100px" height="100px" src="https://medisoftapps.digitronicsindia.com/medisoft/public/uploads/silver.png">
                </div>
            </div>
        </div>
    </div>
</div>
@endif

@if($slug['Pack_Name'] == 'EMPLOYE')
<div class="col">
    <div class="card overflow-hidden radius-10">
        <div class="card-body p-2">
            <div class="d-flex align-items-stretch justify-content-between radius-10 overflow-hidden">
                <div class="w-50 p-3 bg-light-primary">
                    <!-- <p></p> -->
                    <h4 class="text-primary"> EMPLOYE </h4>

                    <p> <?php echo MainAcontroller::getFromDateForTrial($userid) ?> to <?php echo MainAcontroller::getToDateForTrial($userid) ?> </p>

                    <p> <?php

                        if (GeneralController::daysleftDateOnly(MainAcontroller::getToDateForTrial($userid)) <= 10) {
                        ?>
                            <label class="text-danger"> <?php echo GeneralController::daysleftDateOnly(MainAcontroller::getToDateForTrial($userid)) ?> days left to expire </label>
                        <?php
                        } else if (GeneralController::daysleftDateOnly(MainAcontroller::getToDateForTrial($userid))  > 10) {
                        ?>
                            <label class="text-success"> <?php echo GeneralController::daysleftDateOnly(MainAcontroller::getToDateForTrial($userid)) ?> days left </label>
                        <?php
                        }




                        ?>
                    </p>

                </div>
                <div class="w-50 bg-primary p-3 text-center">
                    <!-- <p class="mb-3 text-white">+ 16% <i class="bi bi-arrow-up"></i></p>
                        <div id="chart1"></div> -->
                    <img width="100px" height="100px" src="https://medisoftapps.digitronicsindia.com/medisoft/public/uploads/bronze.png">
                </div>
            </div>
        </div>
    </div>
</div>
@endif

<div class="row row-cols-1 row-cols-lg-2 row-cols-xl-2 row-cols-xxl-4">


    <div class="col">
        <div class="card radius-10">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="">
                        <p class="mb-1">Stock Report</p>
                        <!-- <h4 class="mb-0 text-danger"> 0 </h4> -->
                    </div>
                    <div class="ms-auto fs-2 text-danger">
                        <i class="fadeIn animated bx bx-buildings"></i>
                    </div>
                </div>
                <hr class="my-2">

                <a href="{{ route('web.searchPage',Crypt::encrypt($stock) ) }}">Get Stock Report</a>

                <i class="fadeIn animated bx bx-chevron-right-circle"></i>
            </div>
        </div>
    </div>

    <div class="col">
        <div class="card radius-10">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="">
                        <p class="mb-1">Purchase Report</p>
                        <!-- <h4 class="mb-0 text-primary">0</h4> -->
                    </div>
                    <div class="ms-auto fs-2 text-primary">
                        <i class="fadeIn animated bx bx-store-alt"></i>
                    </div>
                </div>
                <hr class="my-2">
                <a href="{{ route('web.searchPage',Crypt::encrypt($purchase) ) }}">Get Purchase Report</a>
                <i class="fadeIn animated bx bx-chevron-right-circle"></i>
            </div>
        </div>
    </div>

    <div class="col">
        <div class="card radius-10">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="">
                        <p class="mb-1">Sale Report</p>
                        <!-- <h4 class="mb-0 text-success">0</h4> -->
                    </div>
                    <div class="ms-auto fs-2 text-success">
                        <i class="fadeIn animated bx bx-book-alt"></i>
                    </div>
                </div>
                <hr class="my-2">
                <a href="{{ route('web.searchPage',Crypt::encrypt($sale) ) }}">Get Sale Report</a>
                <i class="fadeIn animated bx bx-chevron-right-circle"></i>
            </div>
        </div>
    </div>

    <div class="col">
        <div class="card radius-10">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="">
                        <p class="mb-1"> Edit Delete Report</p>
                        <!-- <h4 class="mb-0 text-orange">0</h4> -->
                    </div>
                    <div class="ms-auto fs-2 text-orange">
                        <i class="bi bi-book"></i>
                    </div>
                </div>
                <hr class="my-2">
                <a href="{{ route('web.searchPage',Crypt::encrypt($edit) ) }}">Edit Delete Report</a>
                <i class="fadeIn animated bx bx-chevron-right-circle"></i>
            </div>
        </div>
    </div>

    <div class="col">
        <div class="card radius-10">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="">
                        <p class="mb-1">Cash Closing</p>
                        <!-- <h4 class="mb-0 text-pr0imary">0</h4> -->
                    </div>
                    <div class="ms-auto fs-2 text-primary">
                        <i class="fadeIn animated bx bx-store-alt"></i>
                    </div>
                </div>
                <hr class="my-2">
                <a href="{{ route('web.searchPage',Crypt::encrypt($cashclose) ) }}">Cash Closing Report</a>
                <i class="fadeIn animated bx bx-chevron-right-circle"></i>
            </div>
        </div>
    </div>

    <div class="col">
        <div class="card radius-10">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="">
                        <p class="mb-1">Login Report</p>
                        <!-- <h4 class="mb-0 text-pr0imary">0</h4> -->
                    </div>
                    <div class="ms-auto fs-2 text-primary">
                        <i class="fadeIn animated bx bx-store-alt"></i>
                    </div>
                </div>
                <hr class="my-2">
                <a href="{{ route('web.searchPage',Crypt::encrypt($login) ) }}">Login Report</a>
                <i class="fadeIn animated bx bx-chevron-right-circle"></i>
            </div>
        </div>
    </div>

</div>



@endif





@endsection