@extends('Admin.Layouts.master')

@section('content')

<div class="card">
    <div class="card-body">

        @if ($message = Session::get('success'))
        <div class="alert border-0 bg-light-success alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-success"><i class="bi bi-check-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-success">{{ $message }}</div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        @if ($message = Session::get('fail'))
        <div class="alert border-0 bg-light-danger alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-danger"><i class="bi bi-x-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-danger">
                        {{$message}}
                    </div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif



        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="ps-3">
                <h6 class="mb-0 text-uppercase">Manage Banners</h6>
            </div>
            <div class="ms-auto">
                <div class="btn-group">
                    <a href="{{ route('web.createBanner') }}" class="btn btn-primary"> <i class="fadeIn animated bx bx-image-add"></i>  Create Banner   </a>
                </div>
            </div>
        </div>


        <hr />

        <div class="table-responsive mt-3">
            <table class="table align-middle">
                <thead class="table-secondary">
                    <tr>
                        <th>#</th>
                        <th>Client ID</th>
                        <th>Banner</th>
                        <th>Description</th>
                        <th>From Date</th>
                        <th>To Date</th>
                        <th>Status</th>
                        <th>Created Date</th>
                        <th>Created By</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $cnt = 1; ?>
                    @foreach($banners as $banner)
                    <tr>
                        <td> {{ $cnt }} </td>

                        <td>{{ $banner->ClientID }}</td>
                        
                        <td>
                            <?php $path = 'https://api.digitronicsindia.com/medisoft/public/uploads/banners/' . $banner->ClientID . '/' . $banner->banner_img . '' ?>
                            <div class="d-flex align-items-center gap-3 cursor-pointer">
                                <a class="showImageLarge" data-path="<?php echo $path ?>"> <img src="<?php echo $path ?>" class="rounded-circle" width="44" height="44" alt=""> </a>
                                <div class="">
                                    <p class="mb-0"> </p>
                                </div>
                            </div>
                        </td>
                        
                        <td>{{ $banner->banner_desc }}</td>
                        <td>{{ $banner->from_date }}</td>
                        <td>{{ $banner->to_date }}</td>

                        @if($banner->banner_status == 1)
                        <td> <label class="text-success"> Active </label> </td>
                        @else
                        <td> <label class="text-danger"> Inactive </label> </td>
                        @endif

                        <td>{{ $banner->created_date }}</td>
                        <td>{{ $banner->created_by }}</td>

                        <td>
                            <div class="table-actions d-flex align-items-center gap-3 fs-6">
                                <a href="{{ route('web.updateBannerStatus',$banner->id) }}" class="text-warning" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Update status"><i class="bi bi-pencil-fill"></i></a>
                                <a onclick="return confirm('Are you sure want to delete this banner ?')" href="{{ route('web.deleteBanner',$banner->id) }}" class="text-danger" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete"><i class="bi bi-trash-fill"></i></a>
                            </div>
                        </td>
                    </tr>
                    <?php $cnt++; ?>
                    @endforeach


                </tbody>
            </table>
        </div>

    </div>
</div>

<script>
    $(document).ready(function() {

        $(".showImageLarge").click(function() {

            var id = $(this).data('path');
            document.getElementById("bannerLargeImage").src = id;
            $('#exampleLargeBanner').modal('show');

        });

    });
</script>
@endsection