@extends('Admin.Layouts.master')

@section('content')

<div class="card">
    <div class="card-body">

        @if ($message = Session::get('success'))
        <div class="alert border-0 bg-light-success alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-success"><i class="bi bi-check-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-success">{{ $message }}</div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        @if ($message = Session::get('fail'))
        <div class="alert border-0 bg-light-danger alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-danger"><i class="bi bi-x-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-danger">
                        {{$message}}
                    </div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        <h6 class="mb-0 text-uppercase">Manage Users</h6>
        <hr />

        <div class="table-responsive">
        <!-- data-page-length='10' id="example2" class="table table-striped table-bordered" -->
            <table id="example" class="display" style="width:100%"  >
                <thead class="table-secondary">
                    <tr>
                        <th>Sl No</th>
                        <th>Name</th>
                        <th>Username</th>
                        <th>Shop</th>
                        <th>Package Status</th>
                        <th>Account Type</th>
                        <th>App Status</th>
                        <th>Web Status</th>

                        <th>Action</th> 
                    </tr>
                </thead>
                <tbody>
                    <?php $num = 1; ?>
                    @foreach($users as $client)
                    <tr>
                        <td>{{ $num }}</td>

                        <td>{{ $client->Name }} </td>
                        <td>{{ $client->UserName }}</td>

                        <td>{{ $client->ClientName }} <p> {{ $client->Area }} </p>  <p> {{ $client->Location }}</p></td>

                        <!-- <td>{{ $client->Mobile }}</td> -->

                        @if($client->IsLive == 2)
                        <td> <label style="color: red;"> No Active Pack </label> </td>
                        @elseif( $client->IsLive == 1 )
                        <td> <label style="color: green;">Active Pack</label> </td>
                        @else
                        <td> <label style="color: blue;">Trial</label> </td>
                        @endif


                        @if($client->IsUser == 1)
                        <td> <label style="color: green;">USER</label> </td>
                        @elseif( $client->IsShop == 1 )
                        <td> <label style="color: green;">SHOP</label> </td>
                        @else
                        <td> <label style="color: green;">ADMIN</label> </td>
                        @endif

                        @if($client->Active == 1)
                        <td> <label style="color: green;">Active</label> </td>
                        @else
                        <td> <label style="color: red;">Inactive</label> </td>
                        @endif

                        @if($client->isWebLogin == 1)
                        <td> <label style="color: green;">Active</label> </td>
                        @else
                        <td> <label style="color: red;">Inactive</label> </td>
                        @endif

                        <td>

                            @if( $client->IsUser == 1 || $client->IsShop == 1 || $client->IsStaff == 1 )

                            <div class="col">
                                <div class="dropdown">
                                    <button class="btn btn-primary dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">Actions</button>
                                    <ul class="dropdown-menu">

                                        @if($client->Active == 1)
                                        <li><a class="dropdown-item text-danger" href="{{ route('web.updateAppLoginStatus',Crypt::encrypt($client->id)) }}">Disable App Login</a>
                                        </li>
                                        @else
                                        <li><a class="dropdown-item text-success" href=" {{ route('web.updateAppLoginStatus',Crypt::encrypt($client->id)) }}">Enable App Login</a>
                                        </li>
                                        @endif

                                        @if($client->isWebLogin == 1)
                                        <li><a class="dropdown-item text-danger" href="{{ route('web.updatewebpermissionstatus',Crypt::encrypt($client->id))}}">Disable Web Login</a>
                                        </li>
                                        @else
                                        <li><a class="dropdown-item text-success" href="{{ route('web.updatewebpermissionstatus',Crypt::encrypt($client->id))}}">Enable Web Login</a>
                                        </li>
                                        @endif

                                        <!-- <li><a class="dropdown-item" href="{{ route('web.manageUserPermissions',[ Crypt::encrypt($client->id) , Crypt::encrypt($client->userid)] )}}">Permissions</a>
                                        </li> -->

                                        <!-- <li><a class="dropdown-item" href="{{ route('web.assignUserPermission',[ Crypt::encrypt($client->id) , Crypt::encrypt($client->userid)] )}}">Permissions</a>
                                        </li> -->

                                        @if($client->isPrimary == 0 && $client->IsShop == 1)
                                        
                                        <li><a class="dropdown-item" href="{{ route('web.makeasprimaryaccount', Crypt::encrypt($client->id) )}}"> Make as Primary </a>
                                        </li>

                                        @endif

                                        @if($client->isPrimary == 1)
                                        
                                        <li><a class="dropdown-item" href="{{ route('web.managesubusers', Crypt::encrypt($client->userid) )}}"> Create Sub Users </a>
                                        </li>

                                        @endif

                                        <li><a class="dropdown-item" href="{{ route('web.assignedAppPermissions',[ Crypt::encrypt($client->id) , Crypt::encrypt($client->userid)] )}}">App Permissions</a>
                                        </li>

                                    </ul>
                                </div>
                            </div>

                            @endif



                            
                        </td>
                    </tr>
                    <?php $num++; ?>
                    @endforeach

                </tbody>
            </table>
        </div>
    </div>
</div>

<script>
    $(document).ready(function() {
        $(".clickToView").click(function() {


            $('#modalClientDetails').modal('show');

        });
    });
</script>
@endsection