@extends('Admin.Layouts.master')

@section('content')

<meta name="csrf-token" content="{{ csrf_token() }}" />

<?php

use App\Http\Controllers\MainAcontroller; ?>

<div class="card">
    <div class="card-body">

        @if ($message = Session::get('success'))
        <div class="alert border-0 bg-light-success alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-success"><i class="bi bi-check-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-success">{{ $message }}</div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        @if ($message = Session::get('fail'))
        <div class="alert border-0 bg-light-danger alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-danger"><i class="bi bi-x-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-danger">
                        {{$message}}
                    </div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        <div class="text-center">

            @if($supplier != '')
            <h6 class="text-danger">
                {{ $supplier }}
            </h6>
            @endif

            <h6 class="text-primary">
                {{ $clientname[0] }}
            </h6>

            <p> {{ $location[0] }} {{ $area[0] }} </p>

            <p> <?php echo MainAcontroller::convertDate($from)  ?> TO <?php echo MainAcontroller::convertDate($to)  ?> </p>

            <p style=""> TOTAL : <?php echo number_format($total[0]['tot'], 2) ?> </p>
        </div>




        <!-- accortion test -->
        <div class="row col-12">

            <div class="col-3">
                <h6>SL NO</h6>
            </div>

            <div class="col-3">
                <h6> Supplier Name </h6>
            </div>

            <div class="col-3">
                <h6>Invoice Date</h6>
            </div>

            <div class="col-3">
                <h6>Total Amount</h6>
            </div>


        </div>


        <div class="accordion" id="accordionExample">


            <?php echo $content; ?>


        </div>

        <br>
        <br>





        <!-- accortion test close -->


    </div>
</div>

<script>
    $(document).ready(function() {

        $(".accSupplierExp").click(function() {

            var supplier = $(this).data('supplier');
            var accID = $(this).data('opendiv');
            var client = $(this).data('client');
            var datez = $(this).data('date');
            var bid = $(this).data('id');

            var tableid = $(this).data('tableid');

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                type: 'POST',
                url: "{{ route('web.getMultiInvoiceBySupplier') }}",
                data: {
                    supplier: supplier,
                    client: client,
                    datez: datez
                },
                success: function(data) {

                    var content = "";
                    var num = 1;

                    data.forEach(function(number) {

                        // multiInvoiceSupplier

                        content += '<table class="table table-striped table-bordered" style="width:100%"> <thead class="table-secondary"> <tr> <th>SL NO</th> <th>INVOICE NO</th> <th>AMOUNT</th> </tr> </thead>';

                        content += '<tbody> <tr> <td> ' + num + ' </td> <td> ' + number['invoice_no'] + ' </td> <td> ' + number['tot'] + ' </td> </tr> ';

                        num++;

                        // ajas

                        // ajas close

                    });

                    $.ajax({
                        type: 'POST',
                        url: "{{ route('web.getMultiInvoiceAdjustment') }}",
                        data: {
                            supplier: supplier,
                            client: client,
                            datez: datez
                        },
                        success: function(data) {

                            // var content = "";
                            var num = 1;

                            data.forEach(function(number) {

                                // multiInvoiceSupplier


                                content += ' <tr> <td> Total </td> <td> Adjustment </td>  <td> Net Balance </td> </tr> ';
                                content += ' <tr> <td> ' + number['total'] + ' </td> <td> ' + number['adjustment'] + ' </td> <td> ' + number['NetBalance'] + ' </td> </tr> </tbody> </table>';

                                num++;

                            });

                            $('#' + tableid).html(content);


                        }
                    });

                }
            });





        });

    });
</script>

@endsection