@extends('Admin.Layouts.master')

<title> <?php echo $clientname[0] . " \n " . $area[0] . " \n " . $location[0] . " \n PURCHASE REPORT FROM " . $from . " to " . $to ?> </title>


<?php

use App\Http\Controllers\MainAcontroller; ?>

@section('content')

<div class="card">
    <div class="card-body">

        @if ($message = Session::get('success'))
        <div class="alert border-0 bg-light-success alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-success"><i class="bi bi-check-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-success">{{ $message }}</div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        @if ($message = Session::get('fail'))
        <div class="alert border-0 bg-light-danger alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-danger"><i class="bi bi-x-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-danger">
                        {{$message}}
                    </div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        @if($supplier != '')
        <h6 class="mb-0 text-uppercase text-center text-danger"> {{ $supplier }} </h6>
        @endif
        <h6 class="mb-0 text-uppercase text-center text-primary"> {{ $clientname[0] }} </h6>
        <p class="text-center"> {{ $location[0] }} , {{ $area[0] }}  </p>
        <p class="text-center"><?php echo "PURCHASE REPORT FROM " . (MainAcontroller::convertDate($from)) ?> TO <?php echo (MainAcontroller::convertDate($to)) ?> <br></p>
        <br>
        <h6 class="mb-0 text-uppercase text-center">TOTAL PURCHASE : {{ number_format((float) $overallPurchase[0]['overallPurchase'],2) }} </h6>
        <h6 class="mb-0 text-uppercase text-center">ADJUSTMENT : {{ number_format((float) $adjustment[0]['adjustment'],2) }} </h6>
        <h6 class="mb-0 text-uppercase text-center">NET BALANCE : {{ number_format((float) $NetBalance[0]['NetBalance'],2) }} </h6>
        <hr />

        <div id="renderTable" class="table-responsive">

            <table data-page-length='20' id="exampleONE" class="table table-striped table-bordered">
                <thead class="table-secondary">
                    <tr>
                        <th style="text-align: center;">Sl No</th>
                        <th style="text-align: center;">Bill Date</th>
                        <th style="text-align: right;">Purchase Amount</th>
                        <th style="text-align: center;">Action</th>
                    </tr>
                </thead>

                <tbody>
                    <?php $num = 1; ?>

                    @foreach($totalPurchase as $sale)
                    <tr>
                        <td style="text-align: center;">{{ $num }}</td>
                        <td style="text-align: center;"> <?php echo (MainAcontroller::convertDate($sale->purchase_date)) ?> </td>
                        <td style="text-align: right;"> {{ number_format((float) $sale->totalPurchase,2) }} </td>

                        <td style="text-align: center;">
                            <a href="{{ route('web.viewPurchaseReportThree',[$sale->purchase_date,$sale->purchase_date,$client,$supplier]) }}" class="btn btn-primary">View more</a>
                        </td>
                    </tr>

                    <?php $num++; ?>

                    @endforeach
                </tbody>
            </table>


        </div>


    </div>
</div>



<script>
    // let status = 0;
    $(document).ready(function() {

        $('#exampleONE').DataTable({
            dom: 'Bfrtip',

            buttons: [

                {

                    extend: 'pdf',
                    exportOptions: {
                        columns: [0, 1, 2, 3]
                    },
                    customize: function(doc) {

                        doc.styles.message.alignment = "right";

                        doc.content[1].table.widths = ['25%', '25%', '25%', '25%'];

                        var rowCount = doc.content[1].table.body.length;

                        doc.content[1].table.body[0][3].alignment = 'right';

                        for (i = 1; i < rowCount; i++) {

                            doc.content[1].table.body[i][0].alignment = 'center';
                            doc.content[1].table.body[i][1].alignment = 'center';
                            doc.content[1].table.body[i][2].alignment = 'center';
                            doc.content[1].table.body[i][3].alignment = 'right';

                            // doc.content[1].table.body[i][3].alignment = 'right';
                            // doc.content[1].table.body[i][3].text += ' €';
                        };

                    }


                }, {
                    extend: 'excel',
                    text: 'Excel',
                    exportOptions: {

                        modifier: {
                            page: 'all'
                        }
                    }
                }
            ]
        });
    });
</script>

@endsection