@extends('Admin.Layouts.master')
<meta name="csrf-token" content="{{ csrf_token() }}" />
@section('content')

<div class="card">
    <div class="card-body">

        @if ($message = Session::get('success'))
        <div class="alert border-0 bg-light-success alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-success"><i class="bi bi-check-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-success">{{ $message }}</div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        @if ($message = Session::get('fail'))
        <div class="alert border-0 bg-light-danger alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-danger"><i class="bi bi-x-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-danger">
                        {{$message}}
                    </div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        <h6 class="mb-0 text-uppercase text-center">Manage Permissions</h6>
        <br>
        <p class="text-danger text-center"> {{ $username }} ({{ $email }}) </p>
        <p class="text-danger text-center"> {{ $shopName }} : {{ $shopLocation }} , {{ $shopArea }} </p>

        <hr />

        <!-- report permissions  -->

        @if( count($reports) == 0 )
        <p>No permissions found for reports click to grant privilage </p>

        <form method="post" action="{{ route('web.createPrivilageForReports') }}">
            @csrf
            <input hidden name="userID" class="form-control" value="{{ $userid }}" />
            <input hidden name="clientID" class="form-control" value="{{ $clientID }}" />

            <button type="submit" class="btn btn-primary">Add Privilage</button>

        </form>
        @else

        <p class="text-danger">Reports</p>
        <div class="row row-cols-1 row-cols-lg-2 row-cols-xl-2 row-cols-xxl-4">

            @foreach($reports as $s)

            <div style="padding-bottom: 20px;">
                <input id="s1_isCashVisible" class="salePermission" type="checkbox" value="s1_isCashVisible" {{ $s->status == 1 ? 'checked' : '' }}> </input>
                <label for="s1_isCashVisible"> {{ $s->report_type }} </label>
                @if($s->slug_url == 'STKRPT')
                <div class="col" for="s1_isCashVisible">
                    <div class="btn-group">
                        <button type="button" class="btn btn-primary">Column</button>
                        <button type="button" class="btn btn-primary">Row</button>
                        
                    </div>
                </div>
                @endif
            </div>

            @endforeach

        </div>

        @endif
        <br>
        <br>
        <!-- report permissions close -->







        <!-- sale permission -->
        @if( count($sale) == 0 )

        <p>No permissions found for sale report click to grant privilage </p>

        <form method="post" action="{{ route('web.createSalePermissionsForUser') }}">
            @csrf
            <input hidden name="userID" class="form-control" value="{{ $userid }}" />
            <input hidden name="clientID" class="form-control" value="{{ $clientID }}" />

            <button type="submit" class="btn btn-primary">Add Privilage</button>

        </form>

        @else

        <p class="text-danger">Sales Activity - 1</p>
        <div class="row row-cols-1 row-cols-lg-2 row-cols-xl-2 row-cols-xxl-4">

            @foreach($sale as $s)
            <div style="padding-bottom: 20px;">
                <input id="s1_isCashVisible" class="salePermission" type="checkbox" value="s1_isCashVisible" {{ $s->s1_isCashVisible == 1 ? 'checked' : '' }}> </input>
                <label for="s1_isCashVisible"> Cash Card Visibility </label>
            </div>

            <div style="padding-bottom: 20px;">
                <input id="s1_isCreditVisible" class="salePermission" type="checkbox" value="s1_isCreditVisible" {{ $s->s1_isCreditVisible == 1 ? 'checked' : '' }}> </input>
                <label for="s1_isCreditVisible"> Credit card Visibility </label>
            </div>

            <div style="padding-bottom: 20px;">
                <input id="s1_isCardVisible" class="salePermission" type="checkbox" value="s1_isCardVisible" {{ $s->s1_isCardVisible == 1 ? 'checked' : '' }}> </input>
                <label for="s1_isCardVisible"> Card Visibility </label>
            </div>

            <div style="padding-bottom: 20px;">
                <input id="s1_isCashclick" class="salePermission" type="checkbox" value="s1_isCashclick" {{ $s->s1_isCashclick == 1 ? 'checked' : '' }}> </input>
                <label for="s1_isCashclick"> Cash Card Click </label>
            </div>

            <div style="padding-bottom: 20px;">
                <input id="s1_isCreditclick" class="salePermission" type="checkbox" value="s1_isCreditclick" {{ $s->s1_isCreditclick == 1 ? 'checked' : '' }}> </input>
                <label for="s1_isCreditclick"> Credit Card Click </label>
            </div>

            <div style="padding-bottom: 20px;">
                <input id="s1_isCardclick" class="salePermission" type="checkbox" value="s1_isCardclick" {{ $s->s1_isCardclick == 1 ? 'checked' : '' }}> </input>
                <label for="s1_isCardclick"> Card Click </label>
            </div>

            <div style="padding-bottom: 20px;">
                <input id="s1_isTotalBills" class="salePermission" type="checkbox" value="s1_isTotalBills" {{ $s->s1_isTotalBills == 1 ? 'checked' : '' }}></input>
                <label for="s1_isTotalBills"> Total Bill Count </label>
            </div>

            <div style="padding-bottom: 20px;">
                <input id="s1_isStartBills" class="salePermission" type="checkbox" value="s1_isStartBills" {{ $s->s1_isStartBills == 1 ? 'checked' : '' }}> </input>
                <label for="s1_isStartBills"> Starting Bill No </label>
            </div>

            <div style="padding-bottom: 20px;">
                <input id="s1_isEndBills" class="salePermission" type="checkbox" value="s1_isEndBills" {{ $s->s1_isEndBills == 1 ? 'checked' : '' }}> </input>
                <label for="s1_isEndBills"> Ending Bill No </label>
            </div>

            <div style="padding-bottom: 20px;">
                <input id="s1_isViewMore" class="salePermission" type="checkbox" value="s1_isViewMore" {{ $s->s1_isViewMore == 1 ? 'checked' : '' }}> </input>
                <label for="s1_isViewMore"> View More Click </label>
            </div>
            @endforeach

        </div>


        <p class="text-danger">Sales Activity - 2</p>

        <div class="row row-cols-1 row-cols-lg-2 row-cols-xl-2 row-cols-xxl-4">

            @foreach($sale as $s)
            <div style="padding-bottom: 20px;">
                <input id="s2_isViewMore" class="salePermission" type="checkbox" value="s2_isViewMore" {{ $s->s2_isViewMore == 1 ? 'checked' : '' }}> </input>
                <label for="s2_isViewMore"> View More Click </label>
            </div>

            <div style="padding-bottom: 20px;">
                <input id="s2_isTotalSale" class="salePermission" type="checkbox" value="s2_isTotalSale" {{ $s->s2_isTotalSale == 1 ? 'checked' : '' }}> </input>
                <label for="s2_isTotalSale"> View Total Sale </label>
            </div>
            @endforeach

        </div>


        <p class="text-danger">Sales Activity - 3</p>

        <div class="row row-cols-1 row-cols-lg-2 row-cols-xl-2 row-cols-xxl-4">

            @foreach($sale as $s)
            <div style="padding-bottom: 20px;">
                <input id="s3_isTotalSale" class="salePermission" type="checkbox" value="s3_isTotalSale" {{ $s->s3_isTotalSale == 1 ? 'checked' : '' }}> </input>
                <label for="s3_isTotalSale"> View Total Sale </label>
            </div>

            <div style="padding-bottom: 20px;">
                <input id="s3_isCashVisible" class="salePermission" type="checkbox" value="s3_isCashVisible" {{ $s->s3_isCashVisible == 1 ? 'checked' : '' }}> </input>
                <label for="s3_isCashVisible"> View Cash Sale </label>
            </div>

            <div style="padding-bottom: 20px;">
                <input id="s3_isCardVisible" class="salePermission" type="checkbox" value="s3_isCardVisible" {{ $s->s3_isCardVisible == 1 ? 'checked' : '' }}> </input>
                <label for="s3_isCardVisible"> View Card Sale </label>
            </div>

            <div style="padding-bottom: 20px;">
                <input id="s3_isCreditVisible" class="salePermission" type="checkbox" value="s3_isCreditVisible" {{ $s->s3_isCreditVisible == 1 ? 'checked' : '' }}> </input>
                <label for="s3_isCreditVisible"> View Credit Sale </label>
            </div>

            <div style="padding-bottom: 20px;">
                <input id="s3_isCashClick" class="salePermission" type="checkbox" value="s3_isCashClick" {{ $s->s3_isCashClick == 1 ? 'checked' : '' }}> </input>
                <label for="s3_isCashClick"> Cash Sale Click </label>
            </div>

            <div style="padding-bottom: 20px;">
                <input id="s3_isCardClick" class="salePermission" type="checkbox" value="s3_isCardClick" {{ $s->s3_isCardClick == 1 ? 'checked' : '' }}> </input>
                <label for="s3_isCardClick"> Card Sale Click </label>
            </div>

            <div style="padding-bottom: 20px;">
                <input id="s3_isCreditClick" class="salePermission" type="checkbox" value="s3_isCreditClick" {{ $s->s3_isCreditClick == 1 ? 'checked' : '' }}> </input>
                <label for="s3_isCreditClick"> Credit Sale Click </label>
            </div>

            <div style="padding-bottom: 20px;">
                <input id="s3_isBillCount" class="salePermission" type="checkbox" value="s3_isBillCount" {{ $s->s3_isBillCount == 1 ? 'checked' : '' }}> </input>
                <label for="s3_isBillCount"> View Bill Count </label>
            </div>

            <div style="padding-bottom: 20px;">
                <input id="s3_isStartBill" class="salePermission" type="checkbox" value="s3_isStartBill" {{ $s->s3_isStartBill == 1 ? 'checked' : '' }}> </input>
                <label for="s3_isStartBill"> View Start Bill No </label>
            </div>

            <div style="padding-bottom: 20px;">
                <input id="s3_isEndBill" class="salePermission" type="checkbox" value="s3_isEndBill" {{ $s->s3_isEndBill == 1 ? 'checked' : '' }}> </input>
                <label for="s3_isEndBill"> View End Bill No </label>
            </div>

            @endforeach

        </div>

        @endif


        <!-- purchase permission -->

        <br>
        <br>

        @if( count($purchase) == 0 )

        <p>No permissions found for purchase report click to grant privilage </p>

        <form method="post" action="{{ route('web.createPurchasePermissionsForUser') }}">
            @csrf
            <input hidden name="userID" class="form-control" value="{{ $userid }}" />
            <input hidden name="clientID" class="form-control" value="{{ $clientID }}" />

            <button type="submit" class="btn btn-primary">Add Privilage</button>

        </form>

        @else

        <p class="text-danger">Purchase Report </p>

        <div class="row row-cols-1 row-cols-lg-2 row-cols-xl-2 row-cols-xxl-4">

            @foreach($purchase as $s)
            <div style="padding-bottom: 20px;">
                <input id="p1_isViewMore" class="purPermission" type="checkbox" value="p1_isViewMore" {{ $s->p1_isViewMore == 1 ? 'checked' : '' }}> </input>
                <label for="p1_isViewMore"> View More Click </label>
            </div>

            <div style="padding-bottom: 20px;">
                <input id="p1_isTotalPurchase" class="purPermission" type="checkbox" value="p1_isTotalPurchase" {{ $s->p1_isTotalPurchase == 1 ? 'checked' : '' }}> </input>
                <label for="p1_isTotalPurchase"> View Total Purchase </label>
            </div>
            @endforeach

        </div>

        @endif









    </div>
</div>

<script>
    $(document).ready(function() {

        $(".salePermission").on('click', function(event) {

            if ($(this).prop("checked") == true) {

                var checkedValue = $(this).val();
                let user = "{{ $userid }}";
                let status = 1;

                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });

                $.ajax({
                    type: 'POST',
                    url: "{{ route('web.updateUserPermission') }}",
                    data: {
                        userid: user,
                        column: checkedValue,
                        status: status
                    },
                    success: function(data) {

                        if (data.success) {
                            iziToast.success({
                                title: 'Success',
                                position: 'topRight',
                                message: data.message,
                            });
                        }

                        if (data.fail) {
                            iziToast.error({
                                title: 'Failed',
                                position: 'topRight',
                                message: data.message,
                            });
                        }

                    }
                });



            } else if ($(this).prop("checked") == false) {

                var checkedValue = $(this).val();
                let user = "{{ $userid }}";
                let status = 0;

                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });

                $.ajax({
                    type: 'POST',
                    url: "{{ route('web.updateUserPermission') }}",
                    data: {
                        userid: user,
                        column: checkedValue,
                        status: status
                    },
                    success: function(data) {

                        if (data.success) {
                            iziToast.success({
                                title: 'Success',
                                position: 'topRight',
                                message: data.message,
                            });
                        }

                        if (data.fail) {
                            iziToast.error({
                                title: 'Failed',
                                position: 'topRight',
                                message: data.message,
                            });
                        }

                    }
                });

            }

        });

        // purchase checkbox - purPermission


        $(".purPermission").on('click', function(event) {

            if ($(this).prop("checked") == true) {

                var checkedValue = $(this).val();
                let user = "{{ $userid }}";
                let status = 1;

                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });

                $.ajax({
                    type: 'POST',
                    url: "{{ route('web.updateUserPurchasePermission') }}",
                    data: {
                        userid: user,
                        column: checkedValue,
                        status: status
                    },
                    success: function(data) {

                        if (data.success) {
                            iziToast.success({
                                title: 'Success',
                                position: 'topRight',
                                message: data.message,
                            });
                        }

                        if (data.fail) {
                            iziToast.error({
                                title: 'Failed',
                                position: 'topRight',
                                message: data.message,
                            });
                        }

                    }
                });



            } else if ($(this).prop("checked") == false) {

                var checkedValue = $(this).val();
                let user = "{{ $userid }}";
                let status = 0;

                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });

                $.ajax({
                    type: 'POST',
                    url: "{{ route('web.updateUserPurchasePermission') }}",
                    data: {
                        userid: user,
                        column: checkedValue,
                        status: status
                    },
                    success: function(data) {

                        if (data.success) {
                            iziToast.success({
                                title: 'Success',
                                position: 'topRight',
                                message: data.message,
                            });
                        }

                        if (data.fail) {
                            iziToast.error({
                                title: 'Failed',
                                position: 'topRight',
                                message: data.message,
                            });
                        }

                    }
                });

            }

        });





    });
</script>

@endsection