@extends('Admin.Layouts.master')

@section('content')

<div class="card">
    <div class="card-body">

        @if ($message = Session::get('success'))
        <div class="alert border-0 bg-light-success alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-success"><i class="bi bi-check-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-success">{{ $message }}</div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        @if ($message = Session::get('fail'))
        <div class="alert border-0 bg-light-danger alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-danger"><i class="bi bi-x-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-danger">
                        {{$message}}
                    </div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        <h6 class="mb-0 text-uppercase">View users by <label class="text-danger"> {{ $package }} </label> package</h6>
        <hr />

        <div class="table-responsive">
        <!-- data-page-length='20' id="example2" class="table table-striped table-bordered" -->
            <table id="example" class="display" style="width:100%"  >
                <thead class="table-secondary">
                    <tr>
                        <th>Sl No</th>
                        <th>Use Name</th>
                        <th>Client Name</th>
                        <th>Package</th>
                        <th>Area</th>
                        <th>Location</th>
                        <th>From</th>
                        <th>To</th>
                        <th>Expire Within</th>

                    </tr>
                </thead>
                <tbody>
                    <?php

use App\Http\Controllers\GeneralController;
use App\Http\Controllers\MainAcontroller;

 $num = 1; ?>
                    @foreach($users as $client)
                    <tr>
                        <td>{{ $num }}</td>

                        <td>{{ $client->Name }} </td>
                        <td>{{ $client->ClientName }} - <label class="text-danger">{{ $client->userid }}</label> </td>
                        <td>{{ $package }}</td>
                        <td>{{ $client->Area }}</td>
                        <td>{{ $client->Location }}</td>
                       
                        @if( MainAcontroller::getFromDateForTrial($client->id) != '01-01-1970' )
                        <td>  <label class="text-success"> <?php echo MainAcontroller::getFromDateForTrial($client->id) ?> </label> </td>
                        @else
                        <td>  <label class="text-danger"> Not Found </label> </td>
                        @endif
                        
                        @if( MainAcontroller::getToDateForTrial($client->id) != '01-01-1970' )
                        <td> <label class="text-info"> <?php echo MainAcontroller::getToDateForTrial($client->id) ?></label> </td>
                        @else
                        <td>  <label class="text-danger"> Not Found </label> </td>
                        @endif
                     
                        @if($client->per_to != null || $client->per_to != '' )
                        <td>
                            @if( GeneralController::daysleft($client->per_to) == 'Date is Expired' )
                            <a>
                                <span class="badge bg-danger"> <?php echo GeneralController::daysleft(MainAcontroller::getToDateForTrial($client->id)) ?> </span>
                            </a>
                            @else
                            <a>
                                <span class="badge bg-success"> <?php echo GeneralController::daysleft(MainAcontroller::getToDateForTrial($client->id)) ?> </span>
                            </a>
                            @endif


                        </td>
                        @else
                        <td> <label class="text-danger">Not Found</label> </td>
                        @endif

                        

                    
                      
                    </tr>
                    <?php $num++; ?>
                    @endforeach

                </tbody>
            </table>
        </div>
    </div>
</div>

<script>
    $(document).ready(function() {
        $(".clickToView").click(function() {


            $('#modalClientDetails').modal('show');

        });
    });
</script>
@endsection