
<?php

use App\Http\Controllers\PermissionMethodController;
use App\Http\Controllers\GeneralController;
use App\Http\Controllers\MainAcontroller;
?>
<?php $__env->startSection('content'); ?>

<div class="card">
    <div class="card-body" id="photo">

        <?php if($message = Session::get('success')): ?>
        <div class="alert border-0 bg-light-success alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-success"><i class="bi bi-check-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-success"><?php echo e($message); ?></div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        <?php endif; ?>

        <?php if($message = Session::get('fail')): ?>
        <div class="alert border-0 bg-light-danger alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-danger"><i class="bi bi-x-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-danger">
                        <?php echo e($message); ?>

                    </div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        <?php endif; ?>

        <h6 class="mb-0 text-uppercase text-center">
            <label id="saleOneClient" class="text-danger"> </label>
        </h6>

        <p class="text-center" id="saleOneAreaLoc"> </p>

        <div id="saleSearchForm" class="border p-4 rounded">
            <div class="card-title d-flex align-items-center">
                <h5 class="mb-0">Assigned Shops</h5>
            </div>
            <hr />

            <form action="<?php echo e(route('web.updateAssignedShop')); ?>" id="frm_saleActivityOne" method="post" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>

                <div hidden class="row mb-3">
                    <label for="inputEnterYourName" class="col-sm-3 col-form-label">User ID</label>
                    <input name="userID" value="<?php echo e($userid); ?>" class="form-control" type="text">
                </div>

                <div hidden class="row mb-3">
                    <label for="inputEnterYourName" class="col-sm-3 col-form-label">Client ID</label>
                    <input name="client" value="<?php echo e($client); ?>" class="form-control" type="text">
                </div>

                <div class="row mb-3">
                    <label for="inputEnterYourName" class="col-sm-3 col-form-label">Shop LIst</label>

                    <?php

                    $myArr = [];

                    foreach ($assignedShopList as $shop) {
                        array_push($myArr, $shop->Managed_ClientID);
                    }

                    ?>

                    <select name="shopList[]" class="multiple-select" data-placeholder="Choose anything" multiple="multiple">
                        <?php $__currentLoopData = $allClients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cli): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>


                        <?php if(in_array($cli->ClientID,$myArr)): ?>
                        <option selected value="<?php echo e($cli->ClientID); ?>"> <?php echo e($cli->ClientID); ?> | <?php echo e($cli->ClientName); ?> | <?php echo e($cli->Area); ?> | <?php echo e($cli->Location); ?> </option>
                        <?php else: ?>
                        <option value="<?php echo e($cli->ClientID); ?>"> <?php echo e($cli->ClientID); ?> | <?php echo e($cli->ClientName); ?> | <?php echo e($cli->Area); ?> | <?php echo e($cli->Location); ?> </option>
                        <?php endif; ?>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>

                </div>

                <div class="row">
                    <label class="col-sm-3 col-form-label"></label>
                    <div class="col-sm-9">
                        <button type="submit" class="btn btn-primary px-5 searchSale">Update</button>
                    </div>
                </div>

            </form>

        </div>

    </div>
</div>


<?php $__env->stopSection(); ?>
<?php echo $__env->make('Admin.Layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/digitronicsindia/public_html/medisoft/resources/views/Admin/manageAssignedShopList.blade.php ENDPATH**/ ?>