<?php

namespace App\Http\Controllers;

use App\Models\Clients;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class CashClosingController extends Controller
{
    function cashClosing(Request $request)
    {
        // $client = $request->denoShop;
        $client = session('LoggedUser')['userid'];
        $from = $request->from;
        $to = $request->to;

        $data = [

            'client' => $client,
            'from' => $from,
            'to' => $to,

            'clientname' => Clients::where('ClientID', '=', $client)->pluck('ClientName'),
            'area' => Clients::where('ClientID', '=', $client)->pluck('Area'),
            'location' => Clients::where('ClientID', '=', $client)->pluck('Location'),



            'total' => DB::select("select dt,sum(PrevDenTotal) as PrevDenTotal,sum(OpAmount) as OpAmount,sum(CashSales) as CashSales,sum(CreditSales) as CreditSales,sum(CardSales) as CardSales,sum(SRAmount) as SRAmount,Sum(Paid) as Paid,sum(DenominationAmt) as DenominationAmt from (

                select -1 as Flag,0 as cntbno,Entry_Date as dt,UserName as name,
                0 as PrevDenTotal,Opening_Amount as OpAmount,0 as CashSales,0 as CreditSales,0 as CardSales,0 as SRAmount,0 as DenominationAmt,0 as Paid,'' as tp from CashAccount_Closing1  Where 1>0
                and Entry_Date >='".$from."'
                and Entry_Date <='".$to."'
                and clientid =  '".$client."'
            
                Union
            
                select 1 as flag,count(bill_no) as cntbno,bill_date as dt,loginid as name,
                0 as PrevDenTotal,0 as OpAmount,sum(((granD_total-(grand_total* cash_discount*.01))-(ccardamount))) as CashSales,0 as CreditSales,0 as CardSales,0 as SRAmount,0 as DenominationAmt,
                sum(paid_amount) as Paid,type as tp from sales1   where 1>0
                and type ='D' and COALESCE(CType,'') = ''
                and bill_date >='".$from."'
                and bill_date <='".$to."'
                and ClientID = '".$client."'
                group by name,bill_date,type
            
                Union
            
                 select 2 as flag,count(bill_no) as cntbno,bill_date as dt,loginid as name,0 as OpAmount,0 as CashSales,sum(grand_total-(grand_total* cash_discount*.01)) as CreditSales,0 as CardSales,0 as SRAmount,0 as DenominationAmt,
                0 as PrevDenTotal,sum(paid_amount) as Paid,type as tp from sales1   where 1>0 and (type ='C' or type ='') and COALESCE(CType,'') = ''
                and bill_date >='".$from."'
                and bill_date <='".$to."'
                     and ClientID = '".$client."'
                group by name,bill_date,type
            
                Union
            
                select 3 as Flag,count(bill_no) as cntbno,bill_date as dt,loginid as name,
                0 as PrevDenTotal,0 as OpAmount,0 as CashSales,0 as CreditSales,sum(grand_total-(grand_total* cash_discount*.01)) as CardSales,0 as SRAmount,0 as DenominationAmt,sum(paid_amount) as Paid,type as tp from sales1 where 1>0 and COALESCE(CType,'') <> ''
                and bill_date >='".$from."'
                and bill_date <='".$to."'
                 and ClientID = '".$client."'
                group by name,bill_date,type,CType
            
                Union
            
                    select 4 as Flag,0 as cntbno,return_date as dt,'' as name,0 as PrevDenTotal,0 as OpAmount,0 as CashSales,0 as CreditSales,0 as CardSales,COALESCE(sum((amount+Adjustment)-Discount),0) as SRAmount,0 as DenominationAmt,0 as Paid,
                '' as tp from Sales_Return1  where 1>0
                and return_date >='".$from."'
                and return_date <='".$to."'
                      and ClientID = '".$client."'
                group by  return_date
            
                Union
            
                    select 5 as Flag,0 as cntbno,Entry_Date as dt,UserName as name,
                0 as PrevDenTotal,0 as OpAmount,0 as CashSales,0 ,0 as CardSales,0 as SRAmount,((2000*Multiple_2000)+(500*Multiple_500)+(200*Multiple_200)+(100*Multiple_100)+(50*Multiple_50)+(20*Multiple_20)+(10*Multiple_10)+(5*Multiple_5)+(2*Multiple_2)+(1*Multiple_1)+(Multiple_FVP * .50)) as DenominationAmt,0 as Paid,'' as tp from CashAccount_Closing1 Where 1>0
                and Entry_Date >='".$from."'
                and Entry_Date <='".$to."'
                         and ClientID = '".$client."'
            
                ) as t1 group by dt"),

        ];

        // return $data;
        return view('Admin.cashclosingreport', $data);
    }
}
