<?php

namespace App\Http\Controllers;

use App\Models\Clients;
use App\Models\DeleteReport;
use App\Models\Users;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class DeleteController extends Controller
{

    function deletehistory()
    {
        $data = [
            'report' => DeleteReport::select("tbl_deleteHistory.*","user.Name")
                ->leftjoin('user','tbl_deleteHistory.del_doneby','=','user.id')
                ->get()
        ];

        return view('Admin.deletehistory', $data);
    }


    function deleteFromDatabase(Request $request)
    {
        $tables = DB::select('SHOW TABLES');

        $clientID = $request->clientID;
        $Password = md5($request->proPassword);

        $allDet = Clients::where('ClientID','=',$clientID)->get();

        if (session('LoggedUser')['userRole'] == "admin") {

            $exPassword = Users::where('id','=',session('LoggedUser')['id'])->pluck('PassWord')->first();
            
            // return $exPassword;

            if ($exPassword == $Password) {

                foreach ($tables as $table) {

                    foreach ($table as $key => $value)
                    {
                        if (Schema::hasColumn($value, 'ClientID')) {

                            DB::table($value)
                                ->where('ClientID', '=', $clientID)
                                ->delete();
                        }

                        if (Schema::hasColumn($value, 'Client_ID')) {

                            DB::table($value)
                                ->where('Client_ID', '=', $clientID)
                                ->delete();
                        }
                        
                        if (Schema::hasColumn($value, 'userid')) {

                            DB::table($value)
                                ->where('userid', '=', $clientID)
                                ->delete();
                        }
                       
                    }

                }

                $history = new DeleteReport();

                $history->del_name = $allDet->ClientName;
                $history->del_client = $allDet->ClientID;
                $history->del_address = $allDet->Address1 . " , " . $allDet->Address2 . " , " . $allDet->Area . " , " . $allDet->Location;
                $history->del_reason = $request->delReason;
                $history->del_doneby = $allDet->session('LoggedUser')['id'];
                $history->del_date = date('Y-m-d');

                $saved = $history->save();

                if($saved)
                {
                    return back()->with('success', 'Client data removed from database');
                }
                else
                {
                    return back()->with('fail', 'Something went wrong');
                }


                
            } else 
            {
                return back()->with('fail', 'Incorrect password');
            }
        }
    }
}
