<?php

namespace App\Http\Controllers;

use App\Models\Clients;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\File;

class UploadQRController extends Controller
{
    function uploadPayQR()
    {
        $status = Clients::where('ClientID','=',session('LoggedUser')['userid'])->pluck('pay_qr_status')->first();
        $data = [ 'status' => $status ];
        return view('Admin.uploadQR',$data);
    }

    function updateQRUploadStatus($client)
    {
        $client = Crypt::decrypt($client);

        $id = Clients::where('ClientID', '=', $client)->pluck('id')->first();

        $bann = Clients::find($id);

        $bann->pay_qr_status = 0;

        $res = $bann->save();

        if ($res) {
            return back()->with('success', 'QR Uploaded status changed Successfully');
        } else {
            return back()->with('fail', 'Something went wrong');
        }
    }

    function uploadQRImage(Request $request)
    {
        $ClientID = session('LoggedUser')['userid'];

        $id = Clients::where('ClientID', '=', $ClientID)->pluck('id')->first();

        $path = public_path('uploads/payqr/' . $ClientID);

        if (!File::isDirectory($path)) {

            File::makeDirectory($path, 0777, true, false);
        }

        $file = $request->file('banner');
        $filename = time() . '.' . $file->getClientOriginalName();
        $file->move($path, $filename);

        $bann = Clients::find($id);

        $bann->pay_qr = $filename;

        $bann->pay_qr_status = 1;

        $res = $bann->save();

        if ($res) {
            return back()->with('success', 'QR Uploaded Successfully');
        } else {
            return back()->with('fail', 'Something went wrong');
        }
    }
}
