<?php

use App\Http\Controllers\MainAcontroller;
use App\Http\Controllers\BillRenderController;

?>

<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title></title>

    <style>
        * {
            box-sizing: border-box;
        }

        /* Create three equal columns that floats next to each other */
        .column {
            
            float: left;
            width: 33.33%;
            padding-top: 10px;
            padding-bottom: 10px;
            height: 130px;
            /* Should be removed. Only for demonstration */
        }

        /* Clear floats after the columns */
        .row:after {
            content: "";
            display: table;
            clear: both;
        }

        .pTextIng {
            font-size: 10px;
            margin: 0;
            padding: 0;
            width: 80px;
            display: inline-block;
        }

        .pTextIngRight {
            font-size: 10px;
            margin: 0;
            padding: 0;
            width: 50px;
            display: inline-block;
        }

        .pTextPor {
            font-size: 10px;
            width: 80px;
            height: auto;
            display: inline-block;
        }

        .pTextPorTime {
            font-size: 10px;
            height: auto;
            width: 150px;
            display: inline-block;
        }

        .center {
            text-align: center;
        }

        .centerimg {
            display: block;
            margin-left: auto;
            margin-right: auto;
            width: 50%;
        }

        th {
            border-left: 1px solid <?php echo $color ?>;
            border-right: 1px solid <?php echo $color ?>;

            font-style: normal;
            font-size: 10px;
            color: white;
            background-color: <?php echo $color ?>;
        }

        td {
            padding-left: 2px;
            padding-left: 2px;
            border-left: 1px solid grey;
            border-right: 1px solid grey;

            font-style: normal;
            font-size: 10px;
            color: black;

        }

        td1 {
            border: 1px solid <?php echo $color ?>;

            font-style: normal;
            font-size: 10px;
            color: black;

        }

        table {
            border-collapse: collapse;
            width: 100%;
        }

        p {
            font-size: 10px;
            margin: 0;
            padding: 0;
            width: 80px;
            display: inline-block;
        }

        p1 {
            font-size: 10px;
            margin: 0;
            padding: 0;
            width: 120px;
            display: inline-block;
        }

        p2 {
            font-size: 10px;
            margin: 0;
            padding: 0;

            display: inline-block;
        }
    </style>

</head>

<body>


    <div style="border: 1px solid; border-color: <?php echo $color; ?> ;" class="row">

        <!-- https://api.digitronicsindia.com/medisoft/public/uploads/billlogo/50/ACP.png -->


   

        <div style="padding-left: 10px;"  class="column">
            <div >
                <p id="" class="">Bill No</p>
                <p1 id="" class=""> : {{ $bill_no[0] }}</p1>
            </div>
            <div>
                <p id="" class="">Date / Time</p>
                <p1 id="" class=""> : <?php echo (MainAcontroller::convertDate($bill_date[0])) ?></p1>
            </div>
            <div>
                <p id="" class="">Patient Name</p>
                <p1 id="" class=""> : {{$patient[0]}}</p1>
            </div>
            <div>
                <p id="" class="">Contact No</p>
                <p1 id="" class=""> : +91 {{ $customer_phone[0] }}</p1>
            </div>
            <div>
                <p id="" class="">Doctor Name</p>
                <p1 id="pTextPor" class=""> : {{$doctor[0]}}</p1>
            </div>
            <div>
                <p id="" class="">Customer Name</p>
                <p1 id="" class=""> : {{$customer_name[0]}}</p1>
            </div>
            <div>
                <p id="" class="">Customer GSTIN</p>
                <p1 id="" class=""> : {{ $GSTNo[0] }}</p1>
            </div>

        </div>

        <div class="column">

            <div style="text-align: center;">

                <!-- <img width="80" src="https://api.digitronicsindia.com/medisoft/public/uploads/billlogo/50/ACP.png"> -->
                <h5>{{ $ClientName[0] }}</h5>

                <p2 style="margin-top: -15px;" class="center">{{ $Address1[0]}}  <br> {{ $Address2[0]}}</p2>

              

            </div>

        </div>

        <div style="padding-left: 15px;" class="column">
            <!-- <div>
                <p id="pTextIng" class="pTextIngRight">Branch</p>
                <p id="pTextPor" class="pTextPor"> : {{ $Location[0] }}</p>
            </div> -->

            <div>
                <p id="pTextIng" class="pTextIngRight">Tel No</p>
                <p id="pTextPor" class="pTextPorTime"> : {{ $Phone[0] }}</p>
            </div>

            <div>
                <p id="pTextIng" class="pTextIngRight">DL No</p>
                <p id="pTextPor" class="pTextPorTime"> : {{ $DL[0] }}</p>
            </div>

            <div>
                <p id="pTextIng" class="pTextIngRight">DL No</p>
                <p id="pTextPor" class="pTextPorTime"> : {{ $DL2[0] }}</p>
            </div>

            <!-- <div>
                <p id="pTextIng" class="pTextIngRight">GSTIN</p>
                <p id="pTextPor" class="pTextPorTime"> : {{ $TIN[0] }}</p>
            </div> -->

            <!-- <div>
                <p id="pTextIng" class="pTextIngRight">Division</p>
                <p id="pTextPor" class="pTextPorTime"> : {{ $Location[0] }} </p>
            </div> -->

        </div>

        

    </div>

    <table style="table-layout: auto; width: 100%;" border="1" frame="below above columns">

        <thead>
            <tr>
                <th align="center" style="width:5%; column-rule: 4px double white;" scope="col">SL NO</th>

                <!-- <th align="center" style="width:8%" scope="col">HSN CODE</th> -->

                <th align="center" style="width:24%" scope="col">PRODUCT NAME</th>

                <th align="center" style="width:5%" scope="col">MFR</th>

                <th align="center" style="width:10%" scope="col">BATCH</th>

                <th align="center" style="width:6%" scope="col">EXP DT</th>

                <th align="center" style="width:5%" scope="col">QTY</th>

                <th align="center" style="width:6%" scope="col">MRP</th>

                <th align="center" style="width:6%" scope="col">DISC %</th>

                <th align="center" style="width:6%" scope="col">RATE</th>

                <!-- <th align="center" style="width:5%" scope="col">GST %</th> -->

                <th align="center" style="width:8%" scope="col">AMOUNT</th>
            </tr>
        </thead>

        <?php
        $num = 1;
        $mrpTotal = 0;
        $taxableCalculation = 0;
        $nontaxableCalculation = 0;

        $SGST = 0;
        $CGST = 0;
        $IGST = 0;
        ?>



        @foreach( $items as $item ) <tr>

            <?php

            $mrpTotal = $mrpTotal + ($item->mrp * $item->quantity) ;

            if ($TaxableAmount == 0) {

                if ($item->SGST != 0 &&  $item->CGST != 0 ||  $item->IGST != 0) {
                    $taxableCalculation = $taxableCalculation +  BillRenderController::taxableAmountOne($item->amount, $item->SGST, $item->CGST);
                }

                if ($item->SGST == 0 &&  $item->CGST == 0 &&  $item->IGST == 0) {
                    $nontaxableCalculation = $nontaxableCalculation +  $item->rate * $item->quantity;
                }
            }
            ?>

            <?php



            ?>

            <?php
            if ($SGSTTotal == 0) {
                $SGST = $SGST +  BillRenderController::sgstAmount($item->SGST, $item->CGST, $item->amount);
            }

            ?>
            <?php
            if ($CGSTTotal == 0) {
                $CGST = $CGST +  BillRenderController::cgstAmount($item->SGST, $item->CGST, $item->amount);
            }

            ?>
            <?php

            if ($IGSTTotal == 0) {
                $IGST = $IGST +  BillRenderController::igstAmount($item->IGST, $item->rate);
            }
            ?>

            <td align="center">{{ $num }}</td>

            <!-- <td align="center">45784125</td> -->

            <td align="left">{{ $item->item_description }} </td>

            <td align="center"> <?php echo (substr($item->company_name, 0, 4)) ?> </td>

            <td align="center">{{ $item->batch }}</td>

            <td align="center"> <?php echo (MainAcontroller::convertDatetoExpiry($item->expiry_date))  ?> </td>

            <td align="center"> {{ $item->quantity }} </td>

            <td align="right"> <?php echo number_format($item->mrp,2)?> </td>

            <td align="center"> <?php echo (BillRenderController::discountPercentage($item->mrp, $item->rate))  ?> </td>

            <td align="right"> <?php echo (BillRenderController::formatAmount($item->rate)) ?> </td>

            <!-- <td align="center">{{ $item->CGST + $item->SGST }} </td> -->

            <td align="right"> <?php echo number_format($item->amount,2)?> </td>
        </tr>
        <?php $num++; ?>
        @endforeach


        <!-- first line -->
        <tr>
            <td style="border: 1px solid <?php echo $color; ?>; border-top: 1.5px solid <?php echo $color; ?>;" colspan="2">FSSAI NO :</td>
            <td style="border: 1px solid <?php echo $color; ?>; border-top: 1.5px solid <?php echo $color; ?>;" colspan="1"> 9022119922 </td>

            <td style="border: 1px solid <?php echo $color; ?>; border-top: 1.5px solid <?php echo $color; ?>;" colspan="2" align="center">TOTAL </td>
            <!-- <td style="border: 1px solid <?php echo $color; ?>; border-top: 1.5px solid <?php echo $color; ?>;" align="center" colspan="1"> {{ $totalItems }} </td> -->

            <td style="border: 1px solid <?php echo $color; ?>; border-top: 1.5px solid <?php echo $color; ?>;" colspan="1"></td>
            <td style="border: 1px solid <?php echo $color; ?>; border-top: 1.5px solid <?php echo $color; ?>;" align="center" colspan="1"> {{ $totalQuantity[0]['totalQuantity'] }} </td>
            <td style="border: 1px solid <?php echo $color; ?>; border-top: 1.5px solid <?php echo $color; ?>;" align="right" colspan="1"> <?php echo (number_format($mrpTotal,2)) ?> </td>

            <td style="border: 1px solid <?php echo $color; ?>; border-top: 1.5px solid <?php echo $color; ?>; padding-right: 5px;" align="center" colspan="4"></td>
            <!-- <td style="border: 1px solid <?php echo $color; ?>; border-top: 1.5px solid <?php echo $color; ?>;" align="right" colspan="2">  </td> -->
        </tr>

        <!-- second line -->

       

        <tr>
            <td style="border: 1px solid <?php echo $color; ?>;" colspan="8"> <?php echo (MainAcontroller::numberToWord($total[0]['total']))  ?> </td>
            <td style="border: 1px solid <?php echo $color; ?>; font-weight: bold" align="center" colspan="2"> Grand Total </td>
            <td style=" font-size: 15px; font-style: bold; border: 1px solid <?php echo $color; ?>;" align="right; " colspan="2"> <?php echo (number_format($total[0]['total'],2)) ?> </td>
        </tr>

        <!-- third line -->

        <tr>
            <td style="border: 1px solid <?php echo $color; ?>; font-style: bold;" colspan="12" align="center"> You have saved :
                <?php
                if ($DiscountAmount == 0) {
                ?>
                    Rs <?php echo ( number_format($actualTotal[0]['actualTotal'] - $total[0]['total'],2) ) ?>
                <?php
                } else {
                    echo (number_format($DiscountAmount,2) );
                }
                ?>


            </td>
        </tr>

        <tr>
            <td style="border: 1px solid <?php echo $color; ?>; background-color: <?php echo $color; ?>; color: white;" colspan="8" align="center">Note</td>
            <td style="border: 1px solid <?php echo $color; ?>; background-color: <?php echo $bgcolor; ?>; border-bottom: 1px solid <?php echo $color; ?>;" align="center" colspan="4" rowspan="3"> For Pharmacist </td>
        </tr>

        <tr>
            <td style="border: 1px solid <?php echo $color; ?>;" colspan="8"> 1. Reverse tax mechanism on items are not applicable. Exchange within 7 days from the date of purchase original bill mandatory for exchange of products </td>
        </tr>

        <tr>
            <td style="border: 1px solid <?php echo $color; ?>;" colspan="8"> Items requiring cold storage will not be returned or exchanged </td>
        </tr>


    </table>




</body>



</html>