@extends('Admin.Layouts.master')

@section('content')

<div class="card">
    <div class="card-body" id="photo">

        @if ($message = Session::get('success'))
        <div class="alert border-0 bg-light-success alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-success"><i class="bi bi-check-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-success">{{ $message }}</div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        @if ($message = Session::get('fail'))
        <div class="alert border-0 bg-light-danger alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-danger"><i class="bi bi-x-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-danger">
                        {{$message}}
                    </div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        <h6 class="mb-0 text-uppercase text-center">
            <label id="saleOneClient" class="text-danger"> </label>
        </h6>

        <p class="text-center" id="saleOneAreaLoc"> </p>

        <div id="saleSearchForm" class="border p-4 rounded">
            <div class="card-title d-flex align-items-center">
                <h5 class="mb-0">Purchase Order Delete Settings</h5>
            </div>
            <hr />

            @if( sizeof($existing) > 0 )
            @foreach($existing as $ext)

            @if($ext->slug == 'cart')
            <div class="row mb-3">
                <label for="inputPhoneNo2" class="col-sm-3 col-form-label">Cart Order Deletion Settings Found</label>
                <div class="col-sm-9">
                    <label style="color: red;" for="inputPhoneNo2" class="col-form-label"> Your order will be deleted afetr {{ $ext->po_days }} days from the date of order </label>
                </div>
            </div>
            @endif

            @if($ext->slug == 'order')
            <div class="row mb-3">
                <label for="inputPhoneNo2" class="col-sm-3 col-form-label">Order Deletion Settings Found</label>
                <div class="col-sm-9">
                    <label style="color: red;" for="inputPhoneNo2" class="col-form-label"> Your order will be deleted afetr {{ $ext->po_days }} days from the date of order </label>
                </div>
            </div>
            @endif

            @if($ext->slug == 'deleted')
            <div class="row mb-3">
                <label for="inputPhoneNo2" class="col-sm-3 col-form-label">Deleted Order permenantly deletion Settings Found</label>
                <div class="col-sm-9">
                    <label style="color: red;" for="inputPhoneNo2" class="col-form-label"> Your order will be deleted afetr {{ $ext->po_days }} days from the date of order </label>
                </div>
            </div>
            @endif



            @endforeach
            @endif

            <br>

            <form action="{{ route('web.saveDeletePurchaseOrderPermission') }}" id="frm_saleActivityOne" method="post" enctype="multipart/form-data">
                @csrf

                <!-- cartdate
                senddate
                deleteddate -->

                <div class="row mb-3">
                    <label for="inputPhoneNo2" class="col-sm-3 col-form-label">Deletion Type ( for cart orders ) </label>
                    <div class="col-sm-9">
                        <select required onchange="changeValue(this.value)" name="cartsettings" type="text" class="form-control" id="settingsDropCart" placeholder="">
                            <option value=""> Choose one </option>
                            @foreach( $settings as $set )
                            <option {{ $set->days == $cartdate ? 'selected' : '' }} value="{{ $set->days }}"> {{ $set->settings }} </option>
                            @endforeach
                        </select>
                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-sm-9">
                        <label style="color: red;" id="descSettingscart" for="inputPhoneNo2" class="col-sm-9 col-form-label"> </label>
                    </div>
                </div>

                <div class="row mb-3">

                    <label for="inputPhoneNo2" class="col-sm-3 col-form-label">Deletion Type ( for send orders ) </label>

                    <div class="col-sm-9">
                        <select required onchange="changeValueOrder(this.value)" name="ordersettings" type="text" class="form-control" id="settingsDropOrder" placeholder="">
                            <option value=""> Choose one </option>
                            @foreach( $settings as $set )
                            <option {{ $set->days == $senddate ? 'selected' : '' }} value="{{ $set->days }}"> {{ $set->settings }} </option>
                            @endforeach
                        </select>
                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-sm-9">
                        <label style="color: red;" id="descSettingsorder" for="inputPhoneNo2" class="col-sm-9 col-form-label"> </label>
                    </div>
                </div>

                <div class="row mb-3">
                    <label for="inputPhoneNo2" class="col-sm-3 col-form-label">Deletion Type ( for deleted orders ) </label>
                    <div class="col-sm-9">
                        <select required onchange="changeValueDeleted(this.value)" name="deletedsettings" type="text" class="form-control" id="settingsDropDeleted" placeholder="">
                            <option value=""> Choose one </option>
                            @foreach( $settings as $set )
                            <option {{ $set->days == $deleteddate ? 'selected' : '' }} value="{{ $set->days }}"> {{ $set->settings }} </option>
                            @endforeach
                        </select>
                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-sm-9">
                        <label style="color: red;" id="descSettingsdeleted" for="inputPhoneNo2" class="col-sm-9 col-form-label"> </label>
                    </div>
                </div>





                <div class="row">
                    <label class="col-sm-3 col-form-label"></label>
                    <div class="col-sm-9">
                        <button type="submit" class="btn btn-primary px-5 searchSale">Save Settings</button>
                    </div>
                </div>


            </form>

        </div>


    </div>
</div>

<script>
    function changeValue(value) {

        var days = value;

        let desc = document.getElementById("descSettingscart")

        desc.innerText = "Your cart orders will be deleted afetr " + days + " days from the date of order ";
    }

    function changeValueOrder(value) {

        var days = value;

        let desc = document.getElementById("descSettingsorder")

        desc.innerText = "Your order that already send will be deleted afetr " + days + " days from the date of order ";
    }

    function changeValueDeleted(value) {

        var days = value;

        let desc = document.getElementById("descSettingsdeleted")

        desc.innerText = "Your deleted orders will be premenantly deleted afetr " + days + " days from the date of order ";
    }
</script>


@endsection