@extends('Admin.Layouts.master')
<meta name="csrf-token" content="{{ csrf_token() }}" />
@section('content')

<div class="card">
    <div class="card-body">

        @if ($message = Session::get('success'))
        <div class="alert border-0 bg-light-success alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-success"><i class="bi bi-check-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-success">{{ $message }}</div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        @if ($message = Session::get('fail'))
        <div class="alert border-0 bg-light-danger alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-danger"><i class="bi bi-x-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-danger">
                        {{$message}}
                    </div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif



        <div style="display: none;" id="responseBadge" class="alert border-0 bg-light-success alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-success"><i class="bi bi-check-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div id="responseMessage" class="text-success"></div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>


        <div style="display: none;" id="responseBadgefail" class="alert border-0 bg-light-danger alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-danger"><i class="bi bi-x-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div id="responseMessage" class="text-danger">

                    </div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>


        <h6 class="mb-0 text-uppercase"> 
            {{ $username }} <br>
            {{ $Area }} ,
            {{ $Location }}
        </h6>
        <hr />

        <div id="renderTable" class="table-responsive">


            <table data-page-length='10' id="example2" class="table table-striped table-bordered">
                <thead class="table-secondary">
                    <tr>
                        <th>Sl No</th>
                        <th>Action</th>
                        <th>From</th>
                        <th>To</th>
                        <th>Status</th>

                        <th>Permissions</th>

                        <th>Actions</th>
                    </tr>
                </thead>

                <tbody>
                    <?php $num = 1; ?>

                    @foreach($assigned as $rpt)
                    <tr>
                        <td>{{ $num }}</td>
                        <td> {{ $rpt->action }} </td>
                        <td> {{ $rpt->fromdate }} </td>
                        <td> {{ $rpt->todate }} </td>

                        <td>

                            <?php echo ($rpt->status == 1 ? '<label class="text-success">Enabled</label>' : '<label class="text-danger">Disabled</label>'); ?>
                        </td>

                        <td>
                            @if($rpt->status == 0)
                            <form action="{{ route('web.updatepermissions') }}" method="post" id="toggleForm">
                                @csrf
                                <div class="form-check form-switch">
                                    <input hidden name="rowid" type="text" value="{{ $rpt->pid}}">

                                    <input onchange="this.form.submit()" type="checkbox" data-id="{{ $rpt->pid }}" name="status" class="js-switch" {{ $rpt->status == 1 ? 'checked' : '' }}>

                                    <label class="form-check-label text-success" for="flexSwitchCheckChecked">ENABLE</label>

                                </div>
                            </form>
                            @else
                            <form action="{{ route('web.updatepermissions') }}" method="post" id="toggleForm">
                                @csrf
                                <div class="form-check form-switch">
                                    <input hidden name="rowid" type="text" value="{{ $rpt->pid}}">

                                    <input onchange="this.form.submit()" type="checkbox" data-id="{{ $rpt->pid }}" name="status" class="js-switch" {{ $rpt->status == 1 ? 'checked' : '' }}>

                                    <label class="form-check-label text-danger" for="flexSwitchCheckChecked">DISABLE</label>

                                </div>
                            </form>
                            @endif
                        </td>


                        <td>
                            <div class="table-actions d-flex align-items-center gap-3 fs-6">

                                <div class="col">
                                    <a href="" type="button" class="btn btn-primary px-5">Manage</a>
                                </div>

                            </div>
                        </td>

                        
                    </tr>

                    <?php $num++; ?>

                    @endforeach
                </tbody>
            </table>


        </div>


    </div>
</div>


@endsection