@extends('Admin.Layouts.master')

@section('content')

<div class="card">
    <div class="card-body">

        @if ($message = Session::get('success'))
        <div class="alert border-0 bg-light-success alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-success"><i class="bi bi-check-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-success">{{ $message }}</div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        @if ($message = Session::get('fail'))
        <div class="alert border-0 bg-light-danger alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-danger"><i class="bi bi-x-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-danger">
                        {{$message}}
                    </div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="ps-3">
                <h6 class="mb-0 text-uppercase">Manage Assigned Shop List</h6>
            </div>

            <div class="ms-auto">
                <div class="col">
                    <div>
                        <input hidden id="allClientID" class="form-control" value="{{ $allClients }}">
                        <input hidden id="allClientID" class="form-control" value="{{ $allClients }}">
                        <button type="button" class="btn btn-primary grantForAllAssigned">Extend Privilege</button>
                    </div>
                </div>
            </div>

        </div>


        <hr />

        <div class="table-responsive">
            <table data-page-length='10' id="example2" class="table table-striped table-bordered">
                <thead class="table-secondary">
                    <tr>
                        <th>Sl No</th>

                        <th>Shop</th>
                        <th>User Name</th>
                        <th>Package</th>
                        <th>Permission Left</th>


                        <!-- <th>Action</th> -->
                    </tr>
                </thead>
                <tbody>
                    <?php

                    use App\Http\Controllers\GeneralController;
                    use App\Http\Controllers\MainAcontroller;

                    $num = 1; ?>
                    @foreach($data as $client)
                    <tr>
                        <td>{{ $num }}</td>

                        <td>
                            <label class="text-danger"> {{ $client->Managed_ClientID }}</label>
                            <label>{{ $client->ClientName }}</label>
                            <label> {{ $client->Area }} </label>
                            <label> {{ $client->Location }}</label>
                        </td>

                        <td>{{ $client->UserName }}</td>

                        @if($client->IsLive == 2)

                        <td align="center"> <label style="color: red;"> No Active Pack </label> </td>

                        @elseif( $client->IsLive == 1 )

                        <td align="center"> <label style="color: green;">Active Pack</label> <br>

                            <a href="{{ route('web.assignedAppPermissions',[ Crypt::encrypt($client->userid) , Crypt::encrypt($client->Managed_ClientID)] )}}" class="btn alert-success radius-30 px-4"> <label class="text-danger"> <?php echo MainAcontroller::getFromDateForTrial($client->userid) ?> to <?php echo MainAcontroller::getToDateForTrial($client->userid) ?></label> </a>

                        </td>

                        @else
                        <td align="center"> <label style="color: blue;">Trial</label> <br>

                            <a href="{{ route('web.assignedAppPermissions',[ Crypt::encrypt($client->userid) , Crypt::encrypt($client->Managed_ClientID)] )}}" class="btn alert-success radius-30 px-4">
                                <label class="text-danger">
                                    <?php echo MainAcontroller::getFromDateForTrialWithClient($client->userid, $client->Managed_ClientID) ?> -
                                    <?php echo MainAcontroller::getToDateForTrialWithClient($client->userid, $client->Managed_ClientID) ?>
                                </label> </a>

                        </td>
                        @endif



                        @if( GeneralController::daysleft(MainAcontroller::getToDateForTrialWithClientID($client->userid, $client->Managed_ClientID)) == 'Date is Expired' )
                        <td> <label class="btn btn-danger"> <?php echo GeneralController::daysleft(MainAcontroller::getToDateForTrialWithClientID($client->userid, $client->Managed_ClientID)) ?> </label> </td>
                        @else
                        <td> <label class="btn btn-success"> <?php echo GeneralController::daysleft(MainAcontroller::getToDateForTrialWithClientID($client->userid, $client->Managed_ClientID)) ?> </label> </td>
                        @endif




                        <!-- <td>Actions</td> -->






                    </tr>
                    <?php $num++; ?>
                    @endforeach

                </tbody>
            </table>
        </div>
    </div>
</div>


<div class="modal fade" id="grantForAllClients" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Grant Privilege For All Clients</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form method="POST" action="{{ route('web.grantPrivilegeForAll')}}">
                @csrf
                <div class="modal-body">

                    <div hidden ="col-12">
                        <label class="form-label">Clients</label>
                        <input id="perClientList" required name="from" type="text" class="form-control">
                    </div>

                    <div class="col-12">
                        <label class="form-label">From Date</label>
                        <input id="dateFrom" required name="from" type="date" class="form-control">
                    </div>

                    <div class="col-12">
                        <label class="form-label">To Date</label>
                        <input id="dateFrom" required name="to" type="date" class="form-control">
                    </div>

                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Save</button>
                </div>

            </form>
        </div>
    </div>
</div>

<script>
    $(document).ready(function() {
        $(".clickToView").click(function() {
            $('#modalClientDetails').modal('show');
        });

        $(".grantForAllAssigned").click(function() {

            var clients = document.getElementById('allClientID').value;
            
            $("#perClientList").val(clients);

            $('#grantForAllClients').modal('show');

        });

        $(".manageMaxConnections").click(function() {

            var clientid = $(this).data("id");
            var userid = $(this).data("uid");
            var max = $(this).data("max");

            document.getElementById("maxConn").value = max;
            document.getElementById("maxclientid").value = clientid;
            document.getElementById("maxuserid").value = userid;

            $('#modalManageMaxConnection').modal('show');

        });
    });
</script>
@endsection