@extends('Admin.Layouts.master')

@section('content')

<?php

use App\Http\Controllers\MainAcontroller; ?>


<div class="card">
    <div class="card-body">

        @if ($message = Session::get('success'))
        <div class="alert border-0 bg-light-success alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-success"><i class="bi bi-check-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-success">{{ $message }}</div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        @if ($message = Session::get('fail'))
        <div class="alert border-0 bg-light-danger alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-danger"><i class="bi bi-x-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-danger">
                        {{$message}}
                    </div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        <h6 class="mb-0 text-uppercase text-center">{{ $clientname[0] }} <br> {{ $area[0] }} , {{ $location[0] }} <br> <?php echo "LOGIN REPORT " . (MainAcontroller::convertDate($from)) . " to " . (MainAcontroller::convertDate($to))  ?> </h6>
        <hr />

        <div class="table-responsive">
            <table data-page-length='15' id="example2" class="table table-striped table-bordered">
                <thead class="table-secondary">
                    <tr>
                        <th>Sl No</th>
                        <th>Date</th>

                        <th>First Login User</th>
                        <th>Login Time</th>

                        <th>Last Logout User</th>
                        <th>Last Logout Time</th>
                        <th>Action</th>

                    </tr>
                </thead>
                <tbody>
                    <?php $num = 1; ?>
                    @foreach($total as $cli)
                    <tr>
                        <td>{{ $num }}</td>

                        <td> <?php echo MainAcontroller::convertDate(substr($cli->login_date, 0, 10))  ?> </td>

                        <td>{{ $cli->FirstloginUser }} </td>
                        <td> <?php echo MainAcontroller::convertDateandTime($cli->logintime) ?> </td>


                        <td>{{ $cli->LastLogoutUser }}</td>
                        <td> <?php echo MainAcontroller::convertDateandTime($cli->logouttime) ?> </td>


                        <td> <a href=" {{ route('web.loginReportDetail',[$client,$cli->login_date ]) }} " class="btn btn-primary">View More</a> </td>

                    </tr>
                    <?php $num++; ?>
                    @endforeach

                </tbody>
            </table>
        </div>
    </div>
</div>

<script>
    $(document).ready(function() {
        $(".clickToView").click(function() {


            $('#modalClientDetails').modal('show');

        });
    });
</script>
@endsection