@extends('Admin.Layouts.master')
<?php

use App\Http\Controllers\PermissionMethodController;
use App\Http\Controllers\GeneralController;
use App\Http\Controllers\MainAcontroller;
?>
@section('content')

<div class="card">
    <div class="card-body" id="photo">

        @if ($message = Session::get('success'))
        <div class="alert border-0 bg-light-success alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-success"><i class="bi bi-check-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-success">{{ $message }}</div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        @if ($message = Session::get('fail'))
        <div class="alert border-0 bg-light-danger alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-danger"><i class="bi bi-x-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-danger">
                        {{$message}}
                    </div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        <h6 class="mb-0 text-uppercase text-center">
            <label id="saleOneClient" class="text-danger"> </label>
        </h6>

        <p class="text-center" id="saleOneAreaLoc"> </p>

        <div id="saleSearchForm" class="border p-4 rounded">
            <div class="card-title d-flex align-items-center">
                <h5 class="mb-0">Assigned Shops</h5>
            </div>
            <hr />

            <form action="{{ route('web.updateAssignedShop') }}" id="frm_saleActivityOne" method="post" enctype="multipart/form-data">
                @csrf

                <div hidden class="row mb-3">
                    <label for="inputEnterYourName" class="col-sm-3 col-form-label">User ID</label>
                    <input name="userID" value="{{ $userid }}" class="form-control" type="text">
                </div>

                <div hidden class="row mb-3">
                    <label for="inputEnterYourName" class="col-sm-3 col-form-label">Client ID</label>
                    <input name="client" value="{{ $client }}" class="form-control" type="text">
                </div>

                <div class="row mb-3">
                    <label for="inputEnterYourName" class="col-sm-3 col-form-label">Shop LIst</label>

                    <?php

                    $myArr = [];

                    foreach ($assignedShopList as $shop) {
                        array_push($myArr, $shop->Managed_ClientID);
                    }

                    ?>

                    <select name="shopList[]" class="multiple-select" data-placeholder="Choose anything" multiple="multiple">
                        @foreach($allClients as $cli)


                        @if(in_array($cli->ClientID,$myArr))
                        <option selected value="{{ $cli->ClientID }}"> {{ $cli->ClientID }} | {{ $cli->ClientName }} | {{ $cli->Area }} | {{ $cli->Location }} </option>
                        @else
                        <option value="{{ $cli->ClientID }}"> {{ $cli->ClientID }} | {{ $cli->ClientName }} | {{ $cli->Area }} | {{ $cli->Location }} </option>
                        @endif

                        @endforeach
                    </select>

                </div>

                <div class="row">
                    <label class="col-sm-3 col-form-label"></label>
                    <div class="col-sm-9">
                        <button type="submit" class="btn btn-primary px-5 searchSale">Update</button>
                    </div>
                </div>

            </form>

        </div>

    </div>
</div>


@endsection