@extends('Admin.Layouts.master')

@section('content')

<div class="card">
    <div class="card-body">

        @if ($message = Session::get('success'))
        <div class="alert border-0 bg-light-success alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-success"><i class="bi bi-check-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-success">{{ $message }}</div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        @if ($message = Session::get('fail'))
        <div class="alert border-0 bg-light-danger alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="fs-3 text-danger"><i class="bi bi-x-circle-fill"></i>
                </div>
                <div class="ms-3">
                    <div class="text-danger">
                        {{$message}}
                    </div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif



        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="ps-3">
                <h6 class="mb-0 text-uppercase">Manage Packages</h6>
            </div>
            <div class="ms-auto">
                <div class="btn-group">
                    @if( count($packages) < 3 ) <a href="{{ route('managePackages.create') }}" class="btn btn-primary"> <i class="fadeIn animated bx bx-image-add"></i> Create Package </a>
                        @endif
                </div>
            </div>
        </div>


        <hr />

        <div class="table-responsive mt-3">
            <table class="table align-middle">
                <thead class="table-secondary">
                    <tr>
                        <th>#</th>
                        <th>Pack Name</th>
                        <th>Pack Slug</th>
                        <th>Status</th>
                        <th>Plan Amount</th>
                        <th>Created Date</th>
                        <th>User Actions</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $cnt = 1; ?>
                    @foreach($packages as $pack)
                    <tr>
                        <td> {{ $cnt }} </td>

                        <td>{{ $pack->Pack_Name }}</td>


                        <td>{{ $pack->Pack_Slug }}</td>


                        @if($pack->Pack_Status == 1)
                        <td> <label class="text-success"> Active </label> </td>
                        @else
                        <td> <label class="text-danger"> Inactive </label> </td>
                        @endif

                        <td>{{ $pack->Pack_payment }}</td>

                        <td>{{ $pack->Pack_Created }}</td>

                        <td>

                            <a href="{{ route('web.seeUserActions', $pack->Pack_Slug ) }}" class="btn btn-primary"> User Actions </a>

                        </td>

                        <td>
                            <div class="table-actions d-flex align-items-center gap-3 fs-6">

                                <a data-aid="{{ $pack->id }}" data-id="{{ $pack->Pack_payment }}" class="btn btn-primary showPriceChange" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Update status"> <i class="fadeIn animated bx bx-rupee"></i> </a>

                                <a href="{{ route('managePackages.status', Crypt::encrypt($pack->id) ) }}" class="text-warning" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Update status"><i class="bi bi-pencil-fill"></i></a>

                                <a onclick="return confirm('Are you sure want to delete this package ?')" href="{{ route('managePackages.deletePackage', Crypt::encrypt($pack->id) ) }}" class="text-danger" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete"><i class="bi bi-trash-fill"></i></a>

                            </div>
                        </td>
                    </tr>
                    <?php $cnt++; ?>
                    @endforeach


                </tbody>
            </table>
        </div>

    </div>
</div>


<div class="modal fade" id="modalChangePackPrice" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"> Change Price </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form method="post" action="{{ route('web.updatePackagePrice')}}" class="row g-3">
                @csrf
                <div class="modal-body">
                    <label class="form-label">Price</label>
                    <input hidden required name="packid" id="packid" class="form-control mb-3" aria-label="Default select example">
                    <input type="number" pattern="[0-9]" required name="amount" id="amount" class="form-control mb-3" aria-label="Default select example">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Update</button>

                </div>
            </form>
        </div>
    </div>
</div>

<script>
    $(document).ready(function() {

        $(".showImageLarge").click(function() {

            var id = $(this).data('path');
            document.getElementById("bannerLargeImage").src = id;
            $('#exampleLargeBanner').modal('show');

        });

        $(".showPriceChange").click(function() {


            var myBookId = $(this).attr('data-id');
            var aID = $(this).attr('data-aid');

            // alert(myBookId);
            document.getElementById("packid").value = aID;
            document.getElementById("amount").value = myBookId;
            $('#modalChangePackPrice').modal('show');

        });

    });
</script>
@endsection